/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.ChoiceItem;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import net.minecraft.nbt.NBTTagCompound;

public class BeatUp
extends SpecialAttackBase {
    public BeatUp() {
        super(EffectBase.ApplyStage.During, false);
    }

    @Override
    public boolean ApplyEffect(PixelmonWrapper user, PixelmonWrapper target, double crit) throws Exception {
        PlayerStorage storage = user.pokemon.getStorage();
        for (NBTTagCompound p : storage.getList()) {
            if (this.isFainted(p) || this.hasVolatileStatus(p)) continue;
            this.doAttack(user, target);
        }
        return true;
    }

    private void doAttack(PixelmonWrapper user, PixelmonWrapper target) {
        Attack a = user.attack;
        double stab = 1.0;
        if (user.pokemon.baseStats.type1 == EnumType.Dark || user.pokemon.baseStats.type2 == EnumType.Dark) {
            stab = 1.5;
        }
        double critical = Attack.calcCriticalHit(null, user, target);
        double rand = 1.0;
        double modifier = stab * 1.0 * critical;
        double attack = 0.0;
        double defense = 0.0;
        double Level2 = user.pokemon.getLvl().getLevel();
        attack = (double)user.pokemon.battleStats.attackStat * user.pokemon.battleStats.getAttackModifier() * 0.01;
        defense = (double)target.pokemon.battleStats.defenceStat * (double)target.pokemon.battleStats.getDefenceModifier() * 0.01;
        if (ItemHeld.isItemOfType(user.pokemon.func_70694_bm(), EnumHeldItems.choiceItem)) {
            attack = ((ChoiceItem)user.pokemon.func_70694_bm().func_77973_b()).affectAttack(attack);
        }
        double DamageBase = (2.0 * Level2 / 5.0 + 2.0) * attack * (double)(user.pokemon.baseStats.attack / 10 + 5) * 0.02 / defense + 2.0;
        double Damage2 = DamageBase * modifier * 0.85;
        for (int i = 0; i < target.pokemon.getStatusSize(); ++i) {
            StatusBase e = target.pokemon.getStatus(i);
            try {
                Damage2 = e.adjustRecievedDamage(a, Damage2, user.pokemon, target.pokemon, critical);
                continue;
            }
            catch (Exception exc) {
                if (!PixelmonConfig.printErrors) continue;
                System.out.println("Error in adjustDamage for " + e.getClass().toString() + " for Beat Up.");
                System.out.println(exc.getStackTrace());
            }
        }
        target.pokemon.doBattleDamage(user, (int)Damage2);
    }

    private boolean hasVolatileStatus(NBTTagCompound nbt) {
        return nbt.func_74765_d("EffectCount") > 0;
    }

    private boolean isFainted(NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_74767_n("IsFainted")) {
                return true;
            }
            if (nbt.func_74765_d("Health") <= 0) {
                return true;
            }
        }
        return false;
    }
}

