/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;

public class SleepTalk
extends SpecialAttackBase {
    private static String[] notAllowedList = new String[]{"Bounce", "Chatter", "Copycat", "Dig", "Dive", "Fly", "Focus Punch", "Me First", "Metronome", "Mirror Move", "Shadow Force", "Sketch", "Skull Bash", "Sky Attack", "SolarBeam", "Razor Wind", "Uproar", "Sleep Talk"};

    public SleepTalk() {
        super(EffectBase.ApplyStage.During, false);
    }

    @Override
    public boolean ApplyEffect(PixelmonWrapper user, PixelmonWrapper target, double crit) throws Exception {
        if (!user.pokemon.hasStatus(StatusType.Sleep)) {
            return true;
        }
        ArrayList<Attack> possibleAttacks = new ArrayList<Attack>();
        for (Attack a : user.pokemon.getMoveset()) {
            if (!this.canSelect(a)) continue;
            possibleAttacks.add(a);
        }
        if (possibleAttacks.size() > 0) {
            Attack a = (Attack)possibleAttacks.get(user.pokemon.func_70681_au().nextInt(possibleAttacks.size()));
            ArrayList<PixelmonWrapper> targets = user.getTargets(a);
            user.bc.sendToAll("pixelmon.battletext.used", user.pokemon.getNickname(), a.baseAttack.getLocalizedName());
            for (PixelmonWrapper t : targets) {
                a.use(user, t);
            }
        }
        return true;
    }

    private boolean canSelect(Attack a) {
        String attackName = a.baseAttack.getUnLocalizedName();
        for (String attack : notAllowedList) {
            if (!attack.equalsIgnoreCase(attackName)) continue;
            return false;
        }
        return true;
    }
}

