/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn;

import com.pixelmonmod.pixelmon.battles.attacks.Value;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Flying;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;

public class Fly
extends MultiTurnSpecialAttackBase {
    public Fly() {
        super(new Value[0]);
    }

    @Override
    public boolean ApplyEffect(PixelmonWrapper user, PixelmonWrapper target, double crit) throws Exception {
        if (!this.doesPersist(user.pokemon)) {
            this.setPersists(user.pokemon, true);
            this.setTurnCount(user.pokemon, 2);
        }
        this.decrementTurnCount(user.pokemon);
        if (this.getTurnCount(user.pokemon) == 1) {
            user.bc.sendToAll("pixelmon.effect.flyup", user.pokemon.getNickname());
            user.pokemon.addStatus(new Flying(), user.pokemon);
            return true;
        }
        if (!user.pokemon.hasStatus(StatusType.Flying)) {
            this.setPersists(user.pokemon, false);
            return true;
        }
        for (int i = 0; i < user.pokemon.getStatusSize(); ++i) {
            StatusBase e = user.pokemon.getStatus(i);
            if (e.type != StatusType.Flying) continue;
            user.pokemon.removeStatus(e);
        }
        this.setPersists(user.pokemon, false);
        return false;
    }

    @Override
    public boolean cantMiss(PixelmonWrapper user) throws Exception {
        return this.getTurnCount(user.pokemon) == 0;
    }

    @Override
    public boolean ignoresType(EntityPixelmon user) {
        return this.getTurnCount(user) == -1;
    }

    @Override
    public void removeEffect(EntityPixelmon user, EntityPixelmon target) {
        if (user.hasStatus(StatusType.Flying)) {
            user.removeStatus(StatusType.Flying);
        }
        this.setPersists(user, false);
    }
}

