/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.comm.packetHandlers.KeyPacket;
import com.pixelmonmod.pixelmon.structure.StructureData;
import com.pixelmonmod.pixelmon.structure.StructureRegistry;
import com.pixelmonmod.pixelmon.structure.generation.StructureScattered;
import com.pixelmonmod.pixelmon.worldGeneration.battleDimension.BattleDimWorldProvider;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BattleArenaManager {
    BattleControllerBase bc;
    private World mainWorld;
    private World battleWorld;
    public ChunkCoordinates arenaLocation;
    private int arenaWidth;
    private int arenaLength;
    protected StructureData structure;
    private ArrayList<double[]> participantPositions = new ArrayList();
    private ArrayList<double[]> pokemonPositions = new ArrayList();

    public BattleArenaManager(BattleControllerBase bc) throws Exception {
        this.bc = bc;
        this.arenaLocation = BattleRegistry.getArenaLocation();
    }

    public void createBattleArena(World mainWorld, BiomeGenBase biome) {
        this.mainWorld = mainWorld;
        this.battleWorld = MinecraftServer.func_71276_C().func_71218_a(BattleDimWorldProvider.DimID);
        this.structure = StructureRegistry.getArenaFromBiome(mainWorld.field_73012_v, biome);
        if (this.structure == null) {
            return;
        }
        StructureScattered s = this.structure.createStructure(this.battleWorld.field_73012_v, this.arenaLocation.field_71574_a * 100, 64, this.arenaLocation.field_71573_c * 100, false, true);
        if (!s.generate(this.battleWorld, this.battleWorld.field_73012_v)) {
            System.out.println("Couldn't create battle arena");
        }
    }

    public void manageEntities() {
        for (BattleParticipant p : this.bc.participants) {
            p.setOriginalPosition();
        }
        this.generateLocations();
        for (BattleParticipant p : this.bc.participants) {
            if (p instanceof PlayerParticipant && KeyPacket.playerPokeballs.containsKey(((PlayerParticipant)p).player)) {
                KeyPacket.playerPokeballs.remove(((PlayerParticipant)p).player);
            }
            p.transferToDimension(BattleDimWorldProvider.DimID);
        }
        int pokemonPos = 0;
        for (int i = 0; i < this.bc.participants.size(); ++i) {
            BattleParticipant p = this.bc.participants.get(i);
            p.setPosition(this.participantPositions.get(i));
            for (PixelmonWrapper pw : p.controlledPokemon) {
                pw.setBasePosition(this.pokemonPositions.get(pokemonPos++));
                pw.returnToBasePos();
            }
        }
    }

    public void resetParticipantLocations() {
        for (int i = 0; i < this.bc.participants.size(); ++i) {
            BattleParticipant p = this.bc.participants.get(i);
            if (!(p instanceof PlayerParticipant) && !(p instanceof TrainerParticipant)) continue;
            p.setPosition(this.participantPositions.get(i));
        }
    }

    private void generateLocations() {
        for (double[] pos : this.structure.participantPos) {
            this.participantPositions.add(new double[]{pos[0], 65.0, pos[1]});
        }
        for (double[] pos : this.structure.pokemonPos) {
            this.pokemonPositions.add(new double[]{pos[0], 65.0, pos[1]});
        }
    }

    public void endBattle() {
        for (BattleParticipant p : this.bc.participants) {
            p.transferToDimension(0);
            p.setToOriginalPosition();
        }
    }
}

