/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.RunAway;
import net.minecraft.entity.Entity;
import net.minecraft.util.ChatComponentTranslation;

public class BattleController2Participant
extends BattleControllerBase {
    public BattleController2Participant(BattleParticipant participant1, BattleParticipant participant2) throws Exception {
        super(new BattleParticipant[]{participant1}, new BattleParticipant[]{participant2});
    }

    @Override
    protected void initBattle() throws Exception {
        super.initBattle();
        this.getInitiateMessage();
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                pw.pokemon.getAbility().applySwitchInEffect(pw, this);
            }
        }
    }

    @Override
    public boolean tryFlee(PixelmonWrapper p) {
        if (p.willTryFlee) {
            this.calculateEscape(p, p.pokemon, this.otherParticipant((BattleParticipant)p.getParticipant()).controlledPokemon[0].pokemon);
            p.priority = 6;
            return true;
        }
        return false;
    }

    private void calculateEscape(PixelmonWrapper p, EntityPixelmon user, EntityPixelmon target) {
        float A = (float)user.stats.Speed * (float)user.battleStats.getSpeedModifier() * (float)user.battleStats.getHeldItemSpeedModifier() / 100.0f;
        float B = (float)target.stats.Speed * (float)target.battleStats.getSpeedModifier() * (float)target.battleStats.getHeldItemSpeedModifier() / 100.0f;
        B = B / 4.0f % 256.0f;
        float C = ++p.escapeAttempts;
        float F = A * 32.0f / B + 30.0f * C;
        int random = RandomHelper.getRandomNumberBetween(1, 255);
        if (user.getAbility() instanceof RunAway) {
            ChatHandler.sendBattleMessage((Entity)user.func_70902_q(), (Entity)target.func_70902_q(), user.getNickname() + " fled using Run Away!", new Object[0]);
            this.endBattle();
            return;
        }
        if (user.func_70694_bm() != null && user.func_70694_bm().func_77973_b() == PixelmonItemsHeld.smokeBall) {
            ChatHandler.sendBattleMessage((Entity)user.func_70902_q(), (Entity)target.func_70902_q(), "battlecontroller.escaped", new ChatComponentTranslation("pixelmon." + user.getName().toLowerCase() + ".name", new Object[0]));
            this.endBattle();
            return;
        }
        if (F > 255.0f || (float)random < F) {
            if (!user.isLockedInBattle) {
                ChatHandler.sendBattleMessage((Entity)user.func_70902_q(), (Entity)target.func_70902_q(), "battlecontroller.escaped", new ChatComponentTranslation("pixelmon." + user.getName().toLowerCase() + ".name", new Object[0]));
                this.endBattle();
            } else {
                ChatHandler.sendBattleMessage((Entity)user.func_70902_q(), (Entity)target.func_70902_q(), "battlecontroller.!escaped", new ChatComponentTranslation("pixelmon." + user.getName().toLowerCase() + ".name", new Object[0]));
            }
        } else {
            ChatHandler.sendBattleMessage((Entity)user.func_70902_q(), (Entity)target.func_70902_q(), "battlecontroller.!escaped", new ChatComponentTranslation("pixelmon." + user.getName().toLowerCase() + ".name", new Object[0]));
        }
    }

    public BattleParticipant otherParticipant(BattleParticipant participant) {
        for (BattleParticipant p : this.participants) {
            if (p == participant) continue;
            return p;
        }
        return null;
    }

    public void getInitiateMessage() {
        for (BattleParticipant p : this.participants) {
            if (p.startedBattle) {
                ChatHandler.sendBattleMessage((Entity)p.getEntity(), "battlecontroller.initbattle.you", this.otherParticipant(p).getName());
                continue;
            }
            ChatHandler.sendBattleMessage((Entity)p.getEntity(), "battlecontroller.initbattle.toyou", this.otherParticipant(p).getName());
        }
    }
}

