/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.PlayerBattleEndedAbnormalEvent;
import com.pixelmonmod.pixelmon.api.events.PlayerBattleEndedEvent;
import com.pixelmonmod.pixelmon.api.events.PlayerBattleStartedEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.BattleDamageSource;
import com.pixelmonmod.pixelmon.battles.controller.BattleArenaManager;
import com.pixelmonmod.pixelmon.battles.controller.CalcPriority;
import com.pixelmonmod.pixelmon.battles.controller.Experience;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.status.Clear;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SwitchCamera;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.DamagePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.HealPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BattleControllerBase {
    public ArrayList<BattleParticipant> participants = new ArrayList();
    public GlobalStatusController globalStatusController = new GlobalStatusController();
    public BattleArenaManager arenaManager;
    protected int battleTicks = 0;
    private ArrayList<EntityPlayerMP> spectators = new ArrayList();
    public ArrayList<StatusBase> battleStatusList = new ArrayList();
    public boolean battleEnded = false;
    public int battleIndex;
    public int money;
    private boolean init = false;
    private Stage stage = Stage.PickAction;
    public int turn = 0;
    public ArrayList<PixelmonWrapper> turnList = new ArrayList();
    boolean paused = false;

    public BattleControllerBase(BattleParticipant[] team1, BattleParticipant[] team2) throws Exception {
        this.globalStatusController.addGlobalStatus(new Clear());
        for (BattleParticipant p : team1) {
            p.team = 0;
            this.participants.add(p);
        }
        for (BattleParticipant p : team2) {
            p.team = 1;
            this.participants.add(p);
        }
        BattleRegistry.registerBattle(this);
    }

    protected void initBattle() throws Exception {
        if (this.shouldSwitchDimension()) {
            this.switchDimension();
        }
        for (BattleParticipant p : this.participants) {
            if (p.checkPokemon()) continue;
            throw new Exception("Battle Could not start!");
        }
        for (BattleParticipant p : this.participants) {
            p.StartBattle(this);
        }
        for (BattleParticipant p : this.participants) {
            p.updateOtherPokemon();
            if (!p.canGainXP()) continue;
            p.addToAttackersList();
        }
        for (BattleParticipant p : this.participants) {
            if (!(p instanceof PlayerParticipant)) continue;
            ((PlayerParticipant)p).openGui();
            Pixelmon.EVENT_BUS.post((Event)new PlayerBattleStartedEvent(((PlayerParticipant)p).player, this));
        }
        this.init = true;
    }

    public void update() {
        if (this.battleEnded) {
            return;
        }
        try {
            if (!this.init) {
                try {
                    this.initBattle();
                }
                catch (Exception e) {
                    BattleRegistry.deRegisterBattle(this);
                    return;
                }
            }
            this.onUpdate();
            if (this.isWaiting() || this.paused) {
                if (PixelmonConfig.afkHandlerOn) {
                    for (BattleParticipant p : this.participants) {
                        if (p.getType() != ParticipantType.Player || !p.getWait()) continue;
                        if (!p.isAFK && p.getTurnTimeSeconds() > (long)PixelmonConfig.afkTimerActivateSeconds) {
                            p.isAFK = true;
                            for (BattleParticipant p2 : this.participants) {
                                if (p2.getType() != ParticipantType.Player) continue;
                                if (p.getEntity().func_145782_y() == p2.getEntity().func_145782_y()) {
                                    ChatHandler.sendChat((Entity)p.getEntity(), "battlecontroller.selfafk", PixelmonConfig.afkTimerActivateSeconds, PixelmonConfig.afkTimerTurnSeconds);
                                    continue;
                                }
                                ChatHandler.sendChat((Entity)p2.getEntity(), "battlecontroller.afk", p.getName(), PixelmonConfig.afkTimerActivateSeconds, PixelmonConfig.afkTimerTurnSeconds);
                            }
                        }
                        if (!p.isAFK || p.getTurnTimeSeconds() <= (long)PixelmonConfig.afkTimerTurnSeconds) continue;
                        for (PixelmonWrapper pw : p.controlledPokemon) {
                            Attack randomAttack = Attack.getWhichMoveIsBest(pw);
                            pw.setAttack(randomAttack, pw.getTargets(randomAttack));
                            p.wait = false;
                        }
                    }
                }
                return;
            }
            int tickTop = this.stage == Stage.PickAction ? 30 : 70;
            if (this.participants.size() < 2) {
                return;
            }
            if (this.battleTicks++ > tickTop) {
                if (this.stage == Stage.PickAction) {
                    for (BattleParticipant p : this.participants) {
                        p.clearTurnVariables();
                        p.selectAction();
                    }
                    this.stage = Stage.DoAction;
                    this.turn = 0;
                } else if (this.stage == Stage.DoAction) {
                    for (BattleParticipant p : this.participants) {
                        for (PixelmonWrapper pw : p.controlledPokemon) {
                            int[] stats = new int[]{pw.pokemon.stats.Attack, pw.pokemon.stats.Defence, pw.pokemon.stats.SpecialAttack, pw.pokemon.stats.SpecialDefence, pw.pokemon.stats.Speed, pw.pokemon.battleStats.getEvasion(), pw.pokemon.battleStats.getAccuracy()};
                            stats = pw.pokemon.getAbility().modifyStats(pw, stats);
                            for (int i = 0; i < pw.pokemon.getStatusSize(); ++i) {
                                stats = pw.pokemon.getStatus(i).modifyStats(pw, stats);
                            }
                            pw.pokemon.battleStats.setStatsForTurn(stats);
                        }
                    }
                    if (this.turn == 0) {
                        CalcPriority.checkMoveSpeed(this);
                    }
                    for (BattleParticipant p : this.participants) {
                        for (PixelmonWrapper poke : p.controlledPokemon) {
                            if (poke.pokemon.isLoaded()) continue;
                            poke.pokemon.catchInPokeball();
                            poke.pokemon.releaseFromPokeball();
                            poke.pokemon.field_70172_ad = 0;
                        }
                    }
                    boolean endTurn = false;
                    if (this.turn < this.turnList.size()) {
                        this.takeTurn(this.turnList.get(this.turn));
                        ++this.turn;
                        if (this.turn == this.turnList.size()) {
                            endTurn = true;
                            this.endTurn();
                        }
                    }
                    for (BattleParticipant p : this.participants) {
                        for (PixelmonWrapper pw : p.controlledPokemon) {
                            ItemHeld.useBattleItems(pw.pokemon);
                        }
                    }
                    this.checkPokemon();
                    if (!endTurn && this.turn == this.turnList.size()) {
                        this.endTurn();
                    }
                }
                this.battleTicks = 0;
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in battle.  Continuing...");
            e.printStackTrace();
        }
    }

    private void endTurn() {
        int i;
        this.stage = Stage.PickAction;
        for (PixelmonWrapper pixelmonWrapper : this.turnList) {
            pixelmonWrapper.turnTick();
        }
        for (i = 0; i < this.battleStatusList.size(); ++i) {
            try {
                this.battleStatusList.get(i).turnTick(null);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error on battleStatus tick for " + this.battleStatusList.get((int)i).type.toString());
                exception.printStackTrace();
            }
        }
        for (i = 0; i < this.globalStatusController.getGlobalStatusSize(); ++i) {
            if (!this.globalStatusController.getGlobalStatus(i).endOfTurnMessage(this).equals("")) {
                this.sendToAll(this.globalStatusController.getGlobalStatus(i).endOfTurnMessage(this), new Object[0]);
            }
            this.globalStatusController.getGlobalStatus(i).applyRepeatedEffect(this.globalStatusController, this.participants);
        }
        for (BattleParticipant battleParticipant : this.participants) {
            for (PixelmonWrapper pw : battleParticipant.controlledPokemon) {
                pw.pokemon.getAbility().applyRepeatedEffect(pw);
            }
        }
    }

    private void onUpdate() {
        for (BattleParticipant p : this.participants) {
            p.tick();
        }
        if (this.arenaManager != null) {
            this.arenaManager.resetParticipantLocations();
        }
        if (this.isPvP()) {
            for (BattleParticipant p : this.participants) {
                if (((PlayerParticipant)p).player != null && ((PlayerParticipant)p).player.func_70089_S()) continue;
                Pixelmon.EVENT_BUS.post((Event)new PlayerBattleEndedAbnormalEvent(((PlayerParticipant)p).player, this));
                this.endBattleWithoutXP();
            }
        } else {
            for (BattleParticipant p : this.participants) {
                if (p.getType() != ParticipantType.Player || ((PlayerParticipant)p).player != null && !((PlayerParticipant)p).player.field_70128_L) continue;
                Pixelmon.EVENT_BUS.post((Event)new PlayerBattleEndedAbnormalEvent(((PlayerParticipant)p).player, this));
                this.endBattleWithoutXP();
            }
        }
    }

    public void endBattle() {
        this.battleEnded = true;
        boolean hasPlayers = false;
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                pw.pokemon.getAbility().applyEndOfBattleEffect(pw.pokemon);
            }
            p.EndBattle();
            if (p.getType() != ParticipantType.Player) continue;
            Pixelmon.EVENT_BUS.post((Event)new PlayerBattleEndedEvent(((PlayerParticipant)p).player, this));
            hasPlayers = true;
        }
        if (!hasPlayers) {
            BattleRegistry.deRegisterBattle(this);
        }
    }

    public void endBattleWithoutXP() {
        this.battleEnded = true;
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                pw.pokemon.getAbility().applyEndOfBattleEffect(pw.pokemon);
            }
            p.EndBattle();
        }
    }

    private boolean isPvP() {
        for (BattleParticipant p : this.participants) {
            if (p instanceof PlayerParticipant) continue;
            return false;
        }
        return true;
    }

    public void pauseBattle() {
        this.paused = true;
    }

    public boolean isWaiting() {
        for (BattleParticipant p : this.participants) {
            if (!p.getWait()) continue;
            return true;
        }
        return false;
    }

    public void endPause() {
        this.paused = false;
    }

    private void takeTurn(PixelmonWrapper p) {
        if (this.tryFlee(p)) {
            return;
        }
        for (BattleParticipant part : this.participants) {
            if (part.bc != null) continue;
            this.endBattle();
            return;
        }
        p.takeTurn();
    }

    public boolean tryFlee(PixelmonWrapper p) {
        return false;
    }

    private void checkPokemon() {
        for (BattleParticipant p : this.participants) {
            p.resetMoveTimer();
            if (this.battleEnded || p.isDefeated) continue;
            for (PixelmonWrapper poke : p.controlledPokemon) {
                if (!poke.getIsFaintedOrDead()) continue;
                if (p instanceof WildPixelmonParticipant && this.participants.size() == 2) {
                    for (BattleParticipant part : this.participants) {
                        if (part == p || !(part instanceof PlayerParticipant)) continue;
                        Pixelmon.EVENT_BUS.post((Event)new BeatWildPixelmonEvent(((PlayerParticipant)part).player, (WildPixelmonParticipant)p));
                        ((PlayerParticipant)part).checkPlayerItems();
                    }
                }
                if (poke.pokemon == null) {
                    this.endBattleWithoutXP();
                    return;
                }
                String name = poke.pokemon.getNickname();
                if (name.equals(poke.pokemon.getName())) {
                    name = "pixelmon." + name.toLowerCase() + ".name";
                }
                this.sendToOthers(StatCollector.func_74838_a((String)name) + " fainted!", p, new Object[0]);
                if (p.getType() == ParticipantType.Player) {
                    Pixelmon.network.sendTo((IMessage)new SwitchCamera(), (EntityPlayerMP)p.getEntity());
                    ChatHandler.sendChat((Entity)p.getEntity(), "battlecontroller.fainted", new ChatComponentTranslation(name, new Object[0]));
                }
                if (this.turnList.contains(poke)) {
                    this.turnList.remove(poke);
                }
                Experience.awardExp(this.participants, p, poke.pokemon);
                EntityLivingBase g = poke.pokemon.func_70902_q();
                poke.pokemon.func_70606_j(0.0f);
                poke.pokemon.func_70106_y();
                poke.pokemon.isFainted = true;
                poke.pokemon.catchInPokeball();
                p.updatePokemon(poke);
                if (p.hasMorePokemon()) {
                    poke.willTryFlee = false;
                    p.wait = true;
                    p.getNextPokemon();
                    continue;
                }
                if (p.hasRemainingPokemon()) continue;
                if (this.isOneAlive(this.getTeamPokemon(p))) {
                    p.isDefeated = true;
                    continue;
                }
                ChatHandler.sendBattleMessage((Entity)g, "battlecontroller.outofpokemon", new Object[0]);
                this.endBattle();
            }
        }
    }

    private boolean isOneAlive(ArrayList<PixelmonWrapper> teamPokemon) {
        for (PixelmonWrapper pw : teamPokemon) {
            if (pw.pokemon.field_70128_L || pw.pokemon.isEgg || pw.pokemon.isFainted || !(pw.pokemon.func_110143_aJ() > 0.0f)) continue;
            return true;
        }
        return false;
    }

    public void sendToAll(String string, Object ... data) {
        ChatHandler.sendBattleMessage(this.participants, string, data);
    }

    public void sendToOthers(String string, BattleParticipant battleParticipant, Object ... data) {
        for (BattleParticipant p : this.participants) {
            if (p == battleParticipant) continue;
            ChatHandler.sendBattleMessage((Entity)p.getEntity(), string, data);
        }
    }

    public void clearHurtTimer() {
        for (BattleParticipant part : this.participants) {
            for (PixelmonWrapper pokemon : part.controlledPokemon) {
                pokemon.pokemon.field_70737_aN = 0;
            }
        }
    }

    public void setAttack(EntityPixelmon mypixelmon, Attack a) {
        if (a == null) {
            return;
        }
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw.pokemon != mypixelmon) continue;
                return;
            }
        }
    }

    public void setUseItem(int[] pokemonId, EntityPlayer user, ItemStack usedStack, int additionalInfo) {
        for (BattleParticipant p : this.participants) {
            if (p.getType() != ParticipantType.Player || p.getEntity() != user) continue;
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (!PixelmonMethods.isIDSame(pw.pokemon, pokemonId)) continue;
                pw.willUseItemInStack = usedStack;
                pw.willUseItemInStackInfo = additionalInfo;
                pw.wait = false;
            }
        }
    }

    public void setUseItem(int[] pokemonId, EntityPlayer player, ItemStack usedStack, int[] targetPokemonId) {
        for (BattleParticipant p : this.participants) {
            if (p.getType() == ParticipantType.Player && p.getEntity() == player) {
                for (PixelmonWrapper pw : p.controlledPokemon) {
                    if (!PixelmonMethods.isIDSame(pw.pokemon, pokemonId)) continue;
                    pw.willUseItemInStack = usedStack;
                    pw.willUseItemPokemon = targetPokemonId;
                    pw.willUseItemInStackInfo = -1;
                    pw.wait = false;
                }
            }
            if (p.getEntity() != player || !p.isAFK) continue;
            p.isAFK = false;
            for (BattleParticipant p2 : this.participants) {
                if (p2.getType() != ParticipantType.Player) continue;
                if (p.getEntity().func_145782_y() == p2.getEntity().func_145782_y()) {
                    ChatHandler.sendChat((Entity)p.getEntity(), "battlecontroller.selfafkback", PixelmonConfig.afkTimerActivateSeconds, PixelmonConfig.afkTimerTurnSeconds);
                    continue;
                }
                ChatHandler.sendChat((Entity)p2.getEntity(), "battlecontroller.afkback", p.getName(), PixelmonConfig.afkTimerActivateSeconds, PixelmonConfig.afkTimerTurnSeconds);
            }
        }
    }

    public void SwitchPokemon(int[] switchingPokemonId, int[] newPokemonId, boolean switchInstantly) {
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (!PixelmonMethods.isIDSame(pw.pokemon, switchingPokemonId)) continue;
                pw.isSwitching = true;
                pw.newPokemonId = newPokemonId;
                if (pw.pokemon.isFainted || switchInstantly) {
                    pw.doSwitch();
                }
                pw.wait = false;
                p.wait = false;
            }
        }
    }

    public void setFlee(int[] fleeingId) {
        for (BattleParticipant p : this.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (!PixelmonMethods.isIDSame(fleeingId, pw.pokemon)) continue;
                p.wait = false;
                pw.wait = false;
                pw.willTryFlee = true;
                pw.wait = false;
            }
        }
    }

    public ParticipantType[][] getBattleType(BattleParticipant teamMate) {
        int i;
        ParticipantType[][] type = new ParticipantType[2][];
        ArrayList<ParticipantType> team1 = new ArrayList<ParticipantType>();
        ArrayList<ParticipantType> team2 = new ArrayList<ParticipantType>();
        for (BattleParticipant p : this.participants) {
            if (p.team == teamMate.team) {
                team1.add(p.getType());
                continue;
            }
            team2.add(p.getType());
        }
        type[0] = new ParticipantType[team1.size()];
        for (i = 0; i < team1.size(); ++i) {
            type[0][i] = (ParticipantType)((Object)team1.get(i));
        }
        type[1] = new ParticipantType[team2.size()];
        for (i = 0; i < team2.size(); ++i) {
            type[1][i] = (ParticipantType)((Object)team2.get(i));
        }
        return type;
    }

    public void updatePokemonHealth(EntityPixelmon entityPixelmon) {
        for (BattleParticipant p : this.participants) {
            if (!(p instanceof PlayerParticipant)) continue;
            ((PlayerParticipant)p).updatePokemonHealth(entityPixelmon);
        }
    }

    public ArrayList<BattleParticipant> getOpponents(BattleParticipant participant) {
        ArrayList<BattleParticipant> opps = new ArrayList<BattleParticipant>();
        for (BattleParticipant p : this.participants) {
            if (p.team == participant.team) continue;
            opps.add(p);
        }
        return opps;
    }

    public ArrayList<BattleParticipant> getTeam(BattleParticipant participant) {
        ArrayList<BattleParticipant> team = new ArrayList<BattleParticipant>();
        for (BattleParticipant p : this.participants) {
            if (p.team != participant.team) continue;
            team.add(p);
        }
        return team;
    }

    public ArrayList<PixelmonWrapper> getTeamPokemon(BattleParticipant participant) {
        ArrayList<BattleParticipant> team = this.getTeam(participant);
        ArrayList<PixelmonWrapper> teamPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : team) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw == null) continue;
                teamPokemon.add(pw);
            }
        }
        return teamPokemon;
    }

    public ArrayList<PixelmonWrapper> getOpponentPokemon(BattleParticipant participant) {
        ArrayList<BattleParticipant> opponents = this.getOpponents(participant);
        ArrayList<PixelmonWrapper> opponentPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : opponents) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw == null) continue;
                opponentPokemon.add(pw);
            }
        }
        return opponentPokemon;
    }

    public BattleParticipant getParticipantForEntity(EntityLivingBase entity) {
        for (BattleParticipant p : this.participants) {
            if (p.getEntity() != entity) continue;
            return p;
        }
        return null;
    }

    private boolean shouldSwitchDimension() {
        if (!PixelmonConfig.useBattleDimension) {
            return false;
        }
        for (BattleParticipant p : this.participants) {
            if (!(p instanceof PlayerParticipant)) continue;
            return true;
        }
        return false;
    }

    public void switchDimension() throws Exception {
        BattleParticipant part = this.participants.get(0);
        World world = part.getEntity().field_70170_p;
        this.arenaManager = new BattleArenaManager(this);
        this.arenaManager.createBattleArena(world, world.func_72807_a((int)part.getEntity().field_70165_t, (int)part.getEntity().field_70161_v));
        this.arenaManager.manageEntities();
    }

    public void spectateBattle(EntityPlayerMP player) {
        this.spectators.add(player);
    }

    public void stopSpectatingBattle(EntityPlayerMP player) {
        if (this.spectators.contains(player)) {
            this.spectators.remove(player);
        }
    }

    public void sendDamagePacket(EntityPixelmon target, BattleDamageSource source, int damage) {
        for (BattleParticipant p : this.participants) {
            p.sendDamagePacket(target, source, damage);
        }
        for (EntityPlayerMP spectator : this.spectators) {
            Pixelmon.network.sendTo((IMessage)new DamagePacket(target, source, damage), spectator);
        }
    }

    public void sendHealPacket(EntityPixelmon target, int amount) {
        for (BattleParticipant p : this.participants) {
            p.sendHealPacket(target, amount);
        }
        for (EntityPlayerMP spectator : this.spectators) {
            Pixelmon.network.sendTo((IMessage)new HealPacket(target, amount), spectator);
        }
    }

    public PixelmonWrapper getOppositePokemon(PixelmonWrapper pw) {
        int index;
        ArrayList<PixelmonWrapper> oppPokemon = pw.bc.getOpponentPokemon(pw.getParticipant());
        ArrayList<PixelmonWrapper> teamPokemon = pw.bc.getTeamPokemon(pw.getParticipant());
        for (index = teamPokemon.indexOf(pw); index >= oppPokemon.size(); --index) {
        }
        return oppPokemon.get(index);
    }

    static enum Stage {
        PickAction,
        DoAction;

    }
}

