/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.Priority;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.TrickRoom;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import java.util.ArrayList;
import java.util.Collections;

public class CalcPriority {
    public static void checkMoveSpeed(BattleControllerBase bc) {
        ArrayList fullParticipants = new ArrayList();
        ArrayList sortedParticipants = new ArrayList();
        for (BattleParticipant p : bc.participants) {
            Collections.addAll(fullParticipants, p.controlledPokemon);
        }
        int order = 0;
        for (int i = 0; i < fullParticipants.size(); ++i) {
            PixelmonWrapper p = (PixelmonWrapper)fullParticipants.get(i);
            if (p.willUseItemInStack == null && !p.isSwitching && !p.willTryFlee) continue;
            if (p.isSwitching) {
                for (int o = 1; o < fullParticipants.size(); ++o) {
                    if (((PixelmonWrapper)fullParticipants.get((int)o)).attack == null || !((PixelmonWrapper)fullParticipants.get((int)o)).attack.baseAttack.getUnLocalizedName().equals("Pursuit") || !((PixelmonWrapper)fullParticipants.get((int)o)).targets.contains(fullParticipants.get(i))) continue;
                    sortedParticipants.add(fullParticipants.get(o));
                    fullParticipants.remove(o);
                }
            }
            p.moveOrder = order++;
            sortedParticipants.add(p);
            fullParticipants.remove(i);
            --i;
        }
        boolean hasPriorityEffect = false;
        for (StatusBase e : bc.battleStatusList) {
            if (!e.hasPriorityEffect()) continue;
            hasPriorityEffect = true;
        }
        for (PixelmonWrapper p : fullParticipants) {
            if (p.attack == null) continue;
            p.priority = 0;
            p.priority = p.pokemon.getAbility().modifyPriority(p, p.priority);
            for (EffectBase e : p.attack.baseAttack.effects) {
                if (e.applyStage != EffectBase.ApplyStage.Priority) continue;
                p.priority = ((Priority)e).value;
            }
        }
        PixelmonWrapper[] array = fullParticipants.toArray(new PixelmonWrapper[fullParticipants.size()]);
        for (int i = 1; i < array.length; ++i) {
            PixelmonWrapper p = array[i];
            for (int holePos = i; holePos > 0 && (array[holePos - 1].priority < p.priority || array[holePos - 1].priority == p.priority && CalcPriority.doesGoFirst(p, array[holePos - 1])); --holePos) {
                array[holePos] = array[holePos - 1];
            }
            array[holePos] = p;
        }
        for (PixelmonWrapper p : fullParticipants) {
            for (EffectBase e : p.attack.baseAttack.effects) {
                e.ApplyEarlyEffect(p, array);
                if (e.applyStage != EffectBase.ApplyStage.Start) continue;
                try {
                    p.attack.willFail = false;
                }
                catch (Exception e1) {}
            }
        }
        Collections.addAll(sortedParticipants, array);
        bc.turnList.clear();
        for (PixelmonWrapper p : sortedParticipants) {
            bc.turnList.add(p);
        }
    }

    private static boolean doesGoFirst(PixelmonWrapper p, PixelmonWrapper foe) {
        block5: {
            try {
                for (int i = 0; i < p.bc.globalStatusController.getGlobalStatusSize(); ++i) {
                    if (!(p.bc.globalStatusController.getGlobalStatus(i) instanceof TrickRoom)) continue;
                    return ((TrickRoom)p.bc.globalStatusController.getGlobalStatus(i)).participantMovesFirst(p.pokemon, foe.pokemon);
                }
            }
            catch (Exception e) {
                System.out.println("Caught error in participantMovesFirst, cause in doesGoFirst");
                if (!PixelmonConfig.printErrors) break block5;
                e.printStackTrace();
            }
        }
        if ((double)p.pokemon.battleStats.speedStat * p.pokemon.battleStats.getSpeedModifier() * p.pokemon.battleStats.getHeldItemSpeedModifier() > (double)foe.pokemon.battleStats.speedStat * foe.pokemon.battleStats.getSpeedModifier() * foe.pokemon.battleStats.getHeldItemSpeedModifier()) {
            return true;
        }
        if ((double)foe.pokemon.battleStats.speedStat * foe.pokemon.battleStats.getSpeedModifier() > (double)p.pokemon.battleStats.speedStat * p.pokemon.battleStats.getSpeedModifier()) {
            return false;
        }
        return RandomHelper.getRandomNumberBetween(0, 2) < 1;
    }

    private static BattleParticipant otherParticipant(BattleParticipant current, ArrayList<BattleParticipant> participants) {
        for (BattleParticipant p : participants) {
            if (p == current) continue;
            return p;
        }
        return null;
    }
}

