/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVsStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.EVAdjusting;
import com.pixelmonmod.pixelmon.items.heldItems.ItemLuckyEgg;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class Experience {
    public static double xpModifier = 1.0;

    public static void awardExp(ArrayList<BattleParticipant> participants, BattleParticipant losingTeamOwner, EntityPixelmon faintedPokemon) {
        if (!PixelmonConfig.allowPVPExperience) {
            boolean allPlayers = true;
            for (BattleParticipant p : participants) {
                if (p.getType() == ParticipantType.Player) continue;
                allPlayers = false;
            }
            if (allPlayers) {
                return;
            }
        }
        if (!PixelmonConfig.allowTrainerExperience) {
            for (BattleParticipant p : participants) {
                if (p.getType() != ParticipantType.Trainer) continue;
                return;
            }
        }
        try {
            for (BattleParticipant teamOwner : participants) {
                Item item;
                if (teamOwner.team == losingTeamOwner.team || !(teamOwner instanceof PlayerParticipant)) continue;
                PlayerParticipant player = (PlayerParticipant)teamOwner;
                ArrayList enemyIdList = player.attackersList;
                PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)teamOwner.getEntity());
                ArrayList<int[]> doneUsers = new ArrayList<int[]>();
                for (PixelmonWrapper pokemon : teamOwner.controlledPokemon) {
                    boolean contains = false;
                    for (int[] id : enemyIdList) {
                        if (!PixelmonMethods.isIDSame(id, pokemon.pokemon)) continue;
                        contains = true;
                    }
                    if (contains) continue;
                    enemyIdList.add(pokemon.pokemon.getPokemonId());
                }
                for (int i = 0; i < enemyIdList.size(); ++i) {
                    if (!storage.isFainted((int[])enemyIdList.get(i))) continue;
                    enemyIdList.remove(i);
                    --i;
                }
                int expShareCount = 0;
                for (NBTTagCompound nbt : storage.getList()) {
                    ItemStack stack;
                    if (nbt == null || !nbt.func_74764_b("HeldItemStack") || (stack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("HeldItemStack")))) == null || (item = stack.func_77973_b()) == null || ((ItemHeld)item).getHeldItemType() != EnumHeldItems.expShare || nbt.func_74767_n("IsFainted") || nbt.func_74765_d("Health") <= 0) continue;
                    ++expShareCount;
                }
                int numPokemon = Experience.calcUniqueParticipants(enemyIdList);
                for (NBTTagCompound nbt : storage.getList()) {
                    if (nbt == null || !nbt.func_74764_b("HeldItemStack") || ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("HeldItemStack"))) == null || !((item = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("HeldItemStack"))).func_77973_b()) instanceof ItemHeld) || ((ItemHeld)item).getHeldItemType() != EnumHeldItems.expShare || nbt.func_74767_n("IsFainted") || nbt.func_74765_d("Health") <= 0) continue;
                    Experience.calcExp(storage, faintedPokemon, PixelmonMethods.getID(nbt), 0.5 / (double)expShareCount, numPokemon);
                }
                for (int[] ido : enemyIdList) {
                    if (Experience.contains(doneUsers, ido)) continue;
                    Experience.calcExp(storage, faintedPokemon, ido, expShareCount > 0 ? 0.5 : 1.0, numPokemon);
                    doneUsers.add(ido);
                }
            }
        }
        catch (PlayerNotLoadedException playerNotLoadedException) {
            // empty catch block
        }
    }

    private static int calcUniqueParticipants(ArrayList<int[]> enemyIdList) {
        ArrayList<int[]> doneUsers = new ArrayList<int[]>();
        for (int[] ido : enemyIdList) {
            if (Experience.contains(doneUsers, ido)) continue;
            doneUsers.add(ido);
        }
        return doneUsers.size();
    }

    private static boolean contains(ArrayList<int[]> doneUsers, int[] ido) {
        for (int i = 0; i < doneUsers.size(); ++i) {
            if (!PixelmonMethods.isIDSame(doneUsers.get(i), ido)) continue;
            return true;
        }
        return false;
    }

    private static void calcExp(PlayerStorage storage, EntityPixelmon faintedPokemon, int[] ido, double scaleFactor, int numPokemon) {
        Item item;
        NBTTagCompound expReceiver = null;
        expReceiver = storage.getNBT(ido);
        if (expReceiver == null) {
            return;
        }
        double a = 1.5;
        double t = expReceiver.func_74779_i("originalTrainer").equals(storage.player.getDisplayName()) ? 1.5 : 1.0;
        double baseExp = faintedPokemon.baseStats.baseExp;
        double eggMultiplier = 1.0;
        NBTTagCompound nbt = storage.getNBT(ido);
        if (nbt.func_74764_b("HeldItemStack") && (item = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("HeldItemStack"))).func_77973_b()) instanceof ItemLuckyEgg) {
            eggMultiplier = 1.5;
        }
        double faintedLevel = faintedPokemon.getLvl().getLevel();
        double Lp = expReceiver.func_74762_e("Level");
        double s = numPokemon;
        double power = 1.0;
        if (s == 0.0) {
            s = 1.0;
        }
        double exp = (a * baseExp * faintedLevel / (5.0 * s) * (Math.pow(2.0 * faintedLevel + 10.0, 2.5) / Math.pow(faintedLevel + Lp + 10.0, 2.5)) + 1.0) * t * eggMultiplier * power;
        exp *= scaleFactor;
        if (storage.EntityAlreadyExists(ido, faintedPokemon.field_70170_p)) {
            EntityPixelmon pokemon = storage.getAlreadyExists(ido, faintedPokemon.field_70170_p);
            pokemon.getLvl().awardEXP((int)(exp * xpModifier));
            EVsStore evStore = faintedPokemon.baseStats.evGain.cloneEVs();
            if (ItemHeld.isItemOfType(pokemon.func_70694_bm(), EnumHeldItems.evAdjusting)) {
                EVAdjusting item2 = (EVAdjusting)pokemon.func_70694_bm().func_77973_b();
                if (item2.type.statAffected == StatsType.None) {
                    evStore.doubleValues();
                } else {
                    evStore.addEVs(4, item2.type.statAffected);
                }
            }
            pokemon.stats.EVs.gainEV(evStore);
            pokemon.updateStats();
            storage.update(pokemon, EnumUpdateType.Stats);
        } else {
            EntityPixelmon pokemon = storage.sendOut(ido, faintedPokemon.field_70170_p);
            pokemon.getLvl().awardEXP((int)exp);
            EVsStore evStore = faintedPokemon.baseStats.evGain.cloneEVs();
            if (ItemHeld.isItemOfType(pokemon.func_70694_bm(), EnumHeldItems.evAdjusting)) {
                EVAdjusting item3 = (EVAdjusting)pokemon.func_70694_bm().func_77973_b();
                if (item3.type.statAffected == StatsType.None) {
                    evStore.doubleValues();
                } else {
                    evStore.addEVs(4, item3.type.statAffected);
                }
            }
            pokemon.stats.EVs.gainEV(evStore);
            pokemon.updateStats();
        }
    }
}

