/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.BattleDamageSource;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.ArrayList;
import java.util.Date;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ChatComponentStyle;
import net.minecraft.util.ChunkCoordinates;

public abstract class BattleParticipant {
    public boolean startedBattle = false;
    public BattleControllerBase bc;
    public int team = 0;
    public ArrayList<int[]> attackersList = new ArrayList();
    public boolean wait = false;
    public PixelmonWrapper[] controlledPokemon;
    public boolean isDefeated = false;
    public Long lngLastMoveMilli;
    public boolean isAFK = false;
    private double[] originalPos;

    public Long getCurrentTime() {
        return Long.parseLong("" + new Date().getTime());
    }

    public void resetMoveTimer() {
        this.lngLastMoveMilli = this.getCurrentTime();
    }

    public Long getTurnTimeSeconds() {
        if (this.lngLastMoveMilli == null) {
            this.resetMoveTimer();
            return 0L;
        }
        return (this.getCurrentTime() - this.lngLastMoveMilli) / 1000L;
    }

    public BattleParticipant(int numControlledPokemon) {
        this.controlledPokemon = new PixelmonWrapper[numControlledPokemon];
        this.lngLastMoveMilli = this.getCurrentTime();
    }

    public abstract boolean hasMorePokemon();

    public abstract boolean canGainXP();

    public void StartBattle(BattleControllerBase bc) {
        this.bc = bc;
        for (PixelmonWrapper p : this.controlledPokemon) {
            p.pokemon.battleController = bc;
        }
    }

    public abstract void EndBattle();

    public abstract ChatComponentStyle getName();

    public abstract Attack getMove(PixelmonWrapper var1);

    public abstract PixelmonWrapper switchPokemon(PixelmonWrapper var1, int[] var2);

    public abstract boolean checkPokemon();

    public abstract void updatePokemon(PixelmonWrapper var1);

    public abstract EntityLivingBase getEntity();

    public abstract void updateOtherPokemon();

    public abstract ParticipantType getType();

    public abstract void getNextPokemon();

    public void tick() {
    }

    public void clearTurnVariables() {
        for (PixelmonWrapper p : this.controlledPokemon) {
            p.clearTurnVariables();
        }
    }

    public void selectAction() {
        for (PixelmonWrapper p : this.controlledPokemon) {
            p.selectAIAction();
        }
    }

    public void addToAttackersList() {
        for (PixelmonWrapper p : this.controlledPokemon) {
            this.attackersList.add(p.pokemon.getPokemonId());
        }
    }

    public boolean getWait() {
        boolean wait = this.wait;
        for (PixelmonWrapper p : this.controlledPokemon) {
            if (!p.wait) continue;
            wait = true;
        }
        return wait;
    }

    public PixelmonWrapper getFaintedPokemon() {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!pw.pokemon.field_70128_L && !pw.pokemon.isEgg && !pw.pokemon.isFainted && !(pw.pokemon.func_110143_aJ() <= 0.0f)) continue;
            return pw;
        }
        return null;
    }

    public boolean hasRemainingPokemon() {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.pokemon.field_70128_L || pw.pokemon.isEgg || pw.pokemon.isFainted || !(pw.pokemon.func_110143_aJ() > 0.0f)) continue;
            return true;
        }
        return false;
    }

    public void setOriginalPosition() {
        this.originalPos = new double[3];
        this.originalPos[0] = this.getEntity().field_70165_t;
        this.originalPos[1] = this.getEntity().field_70163_u;
        this.originalPos[2] = this.getEntity().field_70161_v;
    }

    public void setNewPositions(ChunkCoordinates arenaPosition) {
    }

    public abstract void transferToDimension(int var1);

    public void setPosition(double[] ds) {
        this.getEntity().func_70634_a(ds[0], ds[1], ds[2]);
    }

    public void setToOriginalPosition() {
        this.setPosition(this.originalPos);
    }

    public void sendDamagePacket(EntityPixelmon target, BattleDamageSource source, int damage) {
    }

    public void sendHealPacket(EntityPixelmon target, int amount) {
    }
}

