/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.TargettingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.BatonPass;
import com.pixelmonmod.pixelmon.battles.controller.BattleController2Participant;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity7HasAI;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.worldGeneration.battleDimension.BlankTeleporter;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PixelmonWrapper {
    public EntityPixelmon pokemon;
    private BattleParticipant participant;
    public ArrayList<String> attackList = new ArrayList();
    public Attack attack;
    public boolean canAttack = true;
    public boolean willTryFlee = false;
    public boolean isSwitching = false;
    public ItemStack willUseItemInStack;
    public int moveOrder;
    public int priority;
    public int escapeAttempts = 0;
    public int willUseItemInStackInfo;
    public int damageTakenThisTurn = 0;
    public boolean nextSwitchIsMove;
    public int[] willUseItemPokemon;
    public boolean wait;
    public int position;
    private double[] basePos;
    public ArrayList<PixelmonWrapper> targets = new ArrayList();
    public BattleControllerBase bc;
    public int[] newPokemonId;

    public PixelmonWrapper(BattleParticipant participant, EntityPixelmon pokemon) {
        this.participant = participant;
        this.pokemon = pokemon;
    }

    public PixelmonWrapper(BattleParticipant participant, EntityPixelmon pixelmon, BattleControllerBase bc) {
        this(participant, pixelmon);
        this.pokemon.battleController = bc;
        this.bc = bc;
    }

    public void clearTurnVariables() {
        this.canAttack = true;
        this.willTryFlee = false;
        this.isSwitching = false;
    }

    public void setMoveTargets(PixelmonWrapper ... pokemon) {
        this.targets.clear();
        Collections.addAll(this.targets, pokemon);
    }

    public void selectAIAction() {
        if (this.attack == null || !this.attack.doesPersist(this.pokemon)) {
            if (this.bc == null) {
                this.bc = this.participant.bc;
            }
            if (PixelmonConfig.allowWildPokemonFleeing && this.bc instanceof BattleController2Participant && !this.pokemon.hasStatus(StatusType.Sleep) && !this.pokemon.hasStatus(StatusType.Paralysis) && this.pokemon.getBossMode() == EnumBossMode.NotBoss && this.pokemon.getTrainer() == null) {
                float fleeChance = 0.0f;
                if (this.pokemon.aggression == Entity7HasAI.Aggression.timid) {
                    fleeChance += 0.2f;
                } else if (this.pokemon.aggression == Entity7HasAI.Aggression.aggressive) {
                    fleeChance -= 0.2f;
                }
                if (this.pokemon.func_110143_aJ() < 0.2f * (float)this.pokemon.stats.HP) {
                    fleeChance += 0.1f;
                }
                float effectiveness = 1.0f;
                PixelmonWrapper target = this.bc.getOppositePokemon(this);
                if (target.pokemon.func_110143_aJ() < 0.2f * (float)target.pokemon.stats.HP) {
                    fleeChance -= 0.3f;
                }
                for (EnumType type : target.pokemon.type) {
                    effectiveness *= EnumType.getTotalEffectiveness(this.pokemon.getEffectiveTypes(target.pokemon), type);
                }
                if (effectiveness > 1.0f) {
                    fleeChance -= 0.1f;
                } else if (effectiveness < 1.0f) {
                    fleeChance += 0.1f;
                }
                int levelDiff = target.pokemon.getLvl().getLevel() - this.pokemon.getLvl().getLevel();
                if (levelDiff >= 20) {
                    fleeChance += 0.3f;
                } else if (levelDiff >= 10) {
                    fleeChance += 0.2f;
                }
                if (this.pokemon.func_70681_au().nextFloat() < fleeChance) {
                    this.willTryFlee = true;
                    return;
                }
            }
            this.attack = this.participant.getMove(this);
            ArrayList<PixelmonWrapper> targets = this.getTargets(this.attack);
            this.setAttack(this.attack, targets);
        }
    }

    public ArrayList<PixelmonWrapper> getTargets(Attack chosenAttack) {
        ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
        if (chosenAttack == null) {
            return targets;
        }
        TargettingInfo info = chosenAttack.baseAttack.targettingInfo;
        ArrayList<PixelmonWrapper> teamPokemon = this.bc.getTeamPokemon(this.participant);
        ArrayList<PixelmonWrapper> opponentPokemon = this.bc.getOpponentPokemon(this.participant);
        boolean[][] targetted = new boolean[][]{new boolean[teamPokemon.size()], new boolean[opponentPokemon.size()]};
        int mypos = teamPokemon.indexOf(this);
        if (info.hitsAll) {
            if (info.hitsOppositeFoe) {
                targetted[1][mypos] = true;
            }
            if (info.hitsAdjacentFoe) {
                if (mypos - 1 >= 0) {
                    targetted[1][mypos - 1] = true;
                }
                if (mypos + 1 < targetted[1].length) {
                    targetted[1][mypos + 1] = true;
                }
            }
            if (info.hitsExtendedFoe) {
                if (mypos - 2 >= 0) {
                    targetted[1][mypos - 2] = true;
                }
                if (mypos + 2 < targetted[1].length) {
                    targetted[1][mypos + 2] = true;
                }
            }
            if (info.hitsSelf) {
                targetted[0][mypos] = true;
            }
            if (info.hitsAdjacentAlly) {
                if (mypos - 1 >= 0) {
                    targetted[0][mypos - 1] = true;
                }
                if (mypos + 1 < targetted[0].length) {
                    targetted[0][mypos + 1] = true;
                }
            }
            if (info.hitsExtendedAlly) {
                if (mypos - 2 >= 0) {
                    targetted[0][mypos - 2] = true;
                }
                if (mypos + 2 < targetted[0].length) {
                    targetted[0][mypos + 2] = true;
                }
            }
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < targetted[i].length; ++j) {
                    if (!targetted[i][j]) continue;
                    if (i == 0) {
                        targets.add(teamPokemon.get(j));
                        continue;
                    }
                    targets.add(opponentPokemon.get(j));
                }
            }
        } else {
            ArrayList<PixelmonWrapper> tempTargets = new ArrayList<PixelmonWrapper>();
            if (info.hitsSelf) {
                tempTargets.add(this);
            }
            if (info.hitsAdjacentAlly) {
                if (mypos > 0) {
                    tempTargets.add(teamPokemon.get(mypos - 1));
                }
                if (mypos < teamPokemon.size() - 1) {
                    tempTargets.add(teamPokemon.get(mypos + 1));
                }
            }
            if (info.hitsExtendedAlly) {
                if (mypos > 1) {
                    tempTargets.add(teamPokemon.get(mypos - 2));
                }
                if (mypos < teamPokemon.size() - 2) {
                    tempTargets.add(teamPokemon.get(mypos + 2));
                }
            }
            if (info.hitsOppositeFoe) {
                tempTargets.add(opponentPokemon.get(mypos));
            }
            if (info.hitsAdjacentFoe) {
                if (mypos > 0) {
                    tempTargets.add(opponentPokemon.get(mypos - 1));
                }
                if (mypos < opponentPokemon.size() - 1) {
                    tempTargets.add(opponentPokemon.get(mypos + 1));
                }
            }
            if (info.hitsExtendedFoe) {
                if (mypos > 1) {
                    tempTargets.add(opponentPokemon.get(mypos - 2));
                }
                if (mypos < opponentPokemon.size() - 2) {
                    tempTargets.add(opponentPokemon.get(mypos + 2));
                }
            }
            for (int i = 0; i < tempTargets.size(); ++i) {
                if (tempTargets.get(i) != null) continue;
                tempTargets.remove(i);
                --i;
            }
            if (tempTargets.size() > 0) {
                targets.add((PixelmonWrapper)tempTargets.get(RandomHelper.getRandomNumberBetween(0, tempTargets.size() - 1)));
            }
        }
        return targets;
    }

    public void useAttack() {
        this.bc.sendToAll("pixelmon.battletext.used", this.pokemon.getNickname(), this.attack.baseAttack.getLocalizedName());
        boolean reducePP = false;
        for (PixelmonWrapper target : this.targets) {
            reducePP = reducePP || this.attack.use(this, target);
        }
        if (reducePP) {
            --this.attack.pp;
            this.pokemon.update(EnumUpdateType.Moveset);
        }
    }

    public void useItem() {
        NBTTagCompound targetNBT = null;
        EntityPixelmon targetPokemon = null;
        PixelmonItem item = null;
        EntityPlayerMP user = null;
        ItemStack usedStack = null;
        int additionalInfo = 0;
        try {
            user = ((PlayerParticipant)this.participant).player;
            PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(user);
            if (this.willUseItemInStackInfo == -1) {
                targetNBT = storage.getNBT(this.willUseItemPokemon);
            }
            EntityPixelmon userPokemon = this.pokemon;
            usedStack = this.willUseItemInStack;
            additionalInfo = this.willUseItemInStackInfo;
            this.willUseItemInStack = null;
            this.willUseItemInStackInfo = 0;
            if (this.bc.getOpponentPokemon(this.participant).size() == 1) {
                targetPokemon = this.bc.getOpponentPokemon((BattleParticipant)this.participant).get((int)0).pokemon;
            }
            if ((item = (PixelmonItem)usedStack.func_77973_b()).useFromBag(userPokemon, targetPokemon, additionalInfo)) {
                ItemStack[] inv = user.field_71071_by.field_70462_a;
                item.removeFromInventory(inv);
            } else if (item.useFromBagNBT((EntityPlayer)user, targetNBT, storage)) {
                ItemStack[] inv = user.field_71071_by.field_70462_a;
                item.removeFromInventory(inv);
            }
        }
        catch (PlayerNotLoadedException e) {
            // empty catch block
        }
    }

    public void turnTick() {
        if (this.bc == null) {
            this.bc = this.participant.bc;
        }
        this.returnToBasePos();
        if (this.pokemon != null && this.pokemon.func_110143_aJ() > 0.0f) {
            for (int i = 0; i < this.pokemon.getStatusSize(); ++i) {
                StatusBase s = this.pokemon.getStatus(i);
                try {
                    s.applyRepeatedEffect(this);
                    s.turnTick(this);
                    continue;
                }
                catch (Exception e) {
                    if (!PixelmonConfig.printErrors) continue;
                    System.out.println("Error calculating turnTick for " + s.type.toString());
                    System.out.println(e.getStackTrace());
                }
            }
            this.damageTakenThisTurn = 0;
        }
    }

    public BattleParticipant getParticipant() {
        return this.participant;
    }

    public void doSwitch() {
        this.isSwitching = false;
        ArrayList<StatusBase> statusCopy = new ArrayList<StatusBase>();
        int[] modifiers = new int[6];
        for (int i = 0; i < this.pokemon.getStatusSize(); ++i) {
            try {
                if (this.pokemon.getStatus(i).isTeamStatus()) {
                    statusCopy.add(this.pokemon.getStatus(i));
                }
                this.pokemon.removeStatus(this.pokemon.getStatus((int)i).type);
                continue;
            }
            catch (Exception e2) {
                if (!PixelmonConfig.printErrors) continue;
                System.out.println(e2.getStackTrace());
            }
        }
        boolean batonPassing = false;
        if (this.nextSwitchIsMove && this.attack.baseAttack.getUnLocalizedName().equals("Baton Pass")) {
            batonPassing = true;
            for (int i = 0; i < this.pokemon.getStatusSize(); ++i) {
                if (!BatonPass.isBatonPassable(this.pokemon.getStatus(i))) continue;
                statusCopy.add(this.pokemon.getStatus(i));
            }
            modifiers[0] = (int)this.pokemon.battleStats.getAttackModifier();
            modifiers[1] = this.pokemon.battleStats.getDefenceModifier();
            modifiers[2] = (int)this.pokemon.battleStats.getSpecialAttackModifier();
            modifiers[3] = this.pokemon.battleStats.getSpecialDefenceModifier();
            modifiers[4] = (int)this.pokemon.battleStats.getSpeedModifier();
            modifiers[5] = this.pokemon.battleStats.getAccuracy();
        }
        PixelmonWrapper newPokemon = this.participant.switchPokemon(this, this.newPokemonId);
        newPokemon.pokemon.battleController = this.bc;
        if (batonPassing) {
            newPokemon.pokemon.battleStats.setAttackModifier(modifiers[0]);
            newPokemon.pokemon.battleStats.setDefenceModifier(modifiers[1]);
            newPokemon.pokemon.battleStats.setSpecialAttackModifier(modifiers[2]);
            newPokemon.pokemon.battleStats.setSpecialDefenceModifier(modifiers[3]);
            newPokemon.pokemon.battleStats.setSpeedModifier(modifiers[4]);
            newPokemon.pokemon.battleStats.setAccuracy(modifiers[5]);
        }
        if (statusCopy.size() != 0) {
            for (StatusBase e : statusCopy) {
                newPokemon.pokemon.addStatus(e, newPokemon.pokemon);
            }
            for (StatusBase e : statusCopy) {
                e.applyEffectOnSwitch(newPokemon);
            }
        }
        for (PixelmonWrapper pw : this.bc.getOpponentPokemon(this.participant)) {
            if (!pw.targets.contains(this)) continue;
            pw.targets.remove(this);
            pw.targets.add(newPokemon);
        }
        for (PixelmonWrapper pw : this.bc.getTeamPokemon(this.participant)) {
            if (pw == this || !pw.targets.contains(this)) continue;
            pw.targets.remove(this);
            pw.targets.add(newPokemon);
        }
        for (BattleParticipant p2 : this.bc.participants) {
            if (p2.team == this.participant.team) continue;
            p2.attackersList.clear();
            for (PixelmonWrapper poke : p2.controlledPokemon) {
                p2.attackersList.add(poke.pokemon.getPokemonId());
            }
            p2.updateOtherPokemon();
        }
    }

    public void takeTurn() {
        if (this.isSwitching) {
            this.doSwitch();
        } else if (this.willUseItemInStack != null) {
            this.useItem();
        } else {
            for (int i = 0; i < this.pokemon.getStatusSize(); ++i) {
                StatusBase e = this.pokemon.getStatus(i);
                try {
                    if (e.canAttackThisTurn(this, this.attack)) continue;
                    this.canAttack = false;
                    this.attackList.add("None");
                    break;
                }
                catch (Exception exc) {
                    if (!PixelmonConfig.printErrors) continue;
                    System.out.println("Error calculating canAttackThisTurn for " + e.type.toString());
                    System.out.println(exc.getStackTrace());
                }
            }
            if (this.canAttack) {
                this.participant.bc.clearHurtTimer();
                this.useAttack();
            }
        }
    }

    public String getFaintMessage() {
        return this.pokemon.getNickname() + " fainted!";
    }

    public void setAttack(int buttonId, ArrayList<PixelmonWrapper> targets) {
        Attack attack = this.pokemon.getMoveset().get(buttonId);
        this.setAttack(attack, targets);
    }

    public void setAttack(Attack attack, ArrayList<PixelmonWrapper> targets) {
        this.attack = attack;
        this.wait = false;
        this.targets = targets;
        if (attack != null) {
            this.attackList.add(attack.baseAttack.getUnLocalizedName());
        }
    }

    public boolean getIsFaintedOrDead() {
        return this.pokemon.field_70128_L || this.pokemon.isFainted || this.pokemon.func_110143_aJ() <= 0.0f;
    }

    public void setStruggle(ArrayList<PixelmonWrapper> targets) {
        this.setAttack(DatabaseMoves.getAttack("Struggle"), targets);
    }

    public void returnToBasePos() {
        if (this.basePos != null) {
            this.pokemon.func_70012_b(this.basePos[0], this.basePos[1], this.basePos[2], this.participant.team == 0 ? 270.0f : 90.0f, 0.0f);
            this.pokemon.field_70126_B = this.pokemon.field_70177_z;
        }
    }

    public void transferToDimension(int dimID) {
        this.pokemon.field_70170_p.func_72900_e((Entity)this.pokemon);
        this.pokemon.field_70128_L = false;
        MinecraftServer mc = MinecraftServer.func_71276_C();
        WorldServer worldserver = mc.func_71218_a(this.pokemon.field_70170_p.field_73011_w.field_76574_g);
        WorldServer worldserver1 = mc.func_71218_a(dimID);
        MinecraftServer.func_71276_C().func_71203_ab().transferEntityToWorld((Entity)this.pokemon, dimID, worldserver, worldserver1, (Teleporter)new BlankTeleporter((WorldServer)this.pokemon.field_70170_p));
        this.pokemon.battleController = this.bc;
        EntityPixelmon entity = (EntityPixelmon)PixelmonEntityList.createEntityByName(this.pokemon.getName(), (World)worldserver1);
        if (entity != null) {
            entity.func_82141_a((Entity)this.pokemon, true);
            worldserver1.func_72838_d((Entity)entity);
        }
        this.pokemon.field_70128_L = true;
        worldserver.func_82742_i();
        worldserver1.func_82742_i();
        this.pokemon = entity;
    }

    public void setBasePosition(double[] ds) {
        this.basePos = ds;
        this.pokemon.func_70012_b(ds[0], ds[1], ds[2], 0.0f, 0.0f);
    }
}

