/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.BattleDamageSource;
import com.pixelmonmod.pixelmon.battles.controller.BattleController2Participant;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BackToMainMenu;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.DamagePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnforcedSwitch;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ExitBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.HealPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetBattlingPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonTeamData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pcClientStorage.PCClear;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.items.ItemShrineOrb;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.worldGeneration.battleDimension.BattleDimWorldProvider;
import com.pixelmonmod.pixelmon.worldGeneration.battleDimension.BlankTeleporter;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentStyle;
import net.minecraft.util.ChatComponentText;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;

public class PlayerParticipant
extends BattleParticipant {
    public EntityPlayerMP player;
    PlayerStorage storage;
    int startAir = 0;
    long guiCheck = 0L;

    public PlayerParticipant(EntityPlayerMP p, EntityPixelmon ... startingPixelmon) throws PlayerNotLoadedException {
        super(startingPixelmon.length);
        this.player = p;
        for (int i = 0; i < this.controlledPokemon.length; ++i) {
            this.controlledPokemon[i] = new PixelmonWrapper(this, startingPixelmon[i]);
        }
        this.storage = PixelmonStorage.PokeballManager.getPlayerStorage(this.player);
        this.startAir = p.func_70086_ai();
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.Player;
    }

    @Override
    public boolean canGainXP() {
        return true;
    }

    @Override
    public boolean hasMorePokemon() {
        return this.storage.countAblePokemon() > 0;
    }

    @Override
    public void StartBattle(BattleControllerBase bc) {
        super.StartBattle(bc);
        this.player.field_71075_bZ.field_75102_a = true;
        Pixelmon.network.sendTo((IMessage)new PCClear(), this.player);
        Pixelmon.network.sendTo((IMessage)new StartBattle(bc.battleIndex, bc.getBattleType(this)), this.player);
        try {
            PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(this.player);
            storage.pokedex.sendToPlayer(this.player);
            Pixelmon.network.sendTo((IMessage)new SetBattlingPokemon(this.getTeamPokemonList()), this.player);
            for (EntityPixelmon p : PixelmonMethods.getAllActivePokemon((EntityPlayer)this.player)) {
                p.func_70012_b(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, this.player.field_70177_z, 0.0f);
                for (int i = 0; i < 4; ++i) {
                    if (p.getMoveset().get(i) == null) continue;
                    p.getMoveset().get(i).setDisabled(false, p);
                }
            }
            for (NBTTagCompound nBTTagCompound : storage.getList()) {
                if (nBTTagCompound == null) continue;
                storage.updateClient(nBTTagCompound, EnumUpdateType.Moveset);
            }
            for (PixelmonWrapper pixelmonWrapper : this.controlledPokemon) {
                if (!PixelmonConfig.useBattleDimension && !PixelmonStorage.PokeballManager.getPlayerStorage(this.player).EntityAlreadyExists(pixelmonWrapper.pokemon.getPokemonId(), this.player.field_70170_p)) {
                    pixelmonWrapper.pokemon.func_70012_b(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, this.player.field_70177_z, 0.0f);
                    pixelmonWrapper.pokemon.releaseFromPokeball();
                }
                pixelmonWrapper.bc = bc;
                if (PixelmonConfig.useBattleDimension) continue;
                pixelmonWrapper.pokemon.battleController = bc;
            }
        }
        catch (PlayerNotLoadedException playerNotLoadedException) {
            // empty catch block
        }
    }

    private ArrayList<PixelmonWrapper> getTeamPokemonList() {
        ArrayList<BattleParticipant> team = this.bc.getTeam(this);
        ArrayList<PixelmonWrapper> teamPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : team) {
            Collections.addAll(teamPokemon, p.controlledPokemon);
        }
        return teamPokemon;
    }

    @Override
    public void EndBattle() {
        if (!this.player.field_71075_bZ.field_75098_d) {
            this.player.field_71075_bZ.field_75102_a = false;
        }
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.pokemon.battleStats.clearBattleStats();
            for (int i = 0; i < pw.pokemon.getStatusSize(); ++i) {
                try {
                    if (!pw.pokemon.getStatus(i).clearsOnBattleEnd()) continue;
                    pw.pokemon.removeStatus(pw.pokemon.getStatus(i));
                    --i;
                    continue;
                }
                catch (Exception exc) {
                    if (!PixelmonConfig.printErrors) continue;
                    System.out.println("Error in clearsOnBattleEnd for " + pw.pokemon.getStatus((int)i).type.toString());
                    System.out.println(exc.getStackTrace());
                }
            }
            pw.pokemon.EndBattle();
            pw.pokemon.catchInPokeball();
        }
        Pixelmon.network.sendTo((IMessage)new ExitBattle(), this.player);
        Pixelmon.network.sendTo((IMessage)new PCClear(), this.player);
        if (this.bc != null && this.bc instanceof BattleController2Participant && ((BattleController2Participant)this.bc).otherParticipant(this) instanceof PlayerParticipant) {
            if (!this.hasMorePokemon()) {
                try {
                    PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player).stats.addLoss();
                }
                catch (PlayerNotLoadedException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player).stats.addWin();
                }
                catch (PlayerNotLoadedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void getNextPokemon() {
        if (PixelmonConfig.afkHandlerOn && this.isAFK) {
            try {
                for (PixelmonWrapper pw : this.controlledPokemon) {
                    if (!pw.pokemon.field_70128_L && !pw.pokemon.isEgg && !pw.pokemon.isFainted && !(pw.pokemon.func_110143_aJ() <= 0.0f)) continue;
                    this.switchPokemon(pw, this.storage.getFirstAblePokemon(this.getEntity().field_70170_p).getPokemonId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Pixelmon.network.sendTo((IMessage)new EnforcedSwitch(), this.player);
        }
    }

    @Override
    public ChatComponentStyle getName() {
        return new ChatComponentText(this.player.getDisplayName());
    }

    @Override
    public void selectAction() {
        this.getMove(null);
    }

    @Override
    public Attack getMove(PixelmonWrapper pokemon) {
        if (this.bc == null) {
            return null;
        }
        boolean canSwitch = true;
        ArrayList<PixelmonWrapper> pokemonToChoose = new ArrayList<PixelmonWrapper>();
        for (PixelmonWrapper p : this.controlledPokemon) {
            if (p.pokemon.getMoveset().size() == 0) {
                this.bc.endBattle();
                return null;
            }
            for (int i = 0; i < p.pokemon.getStatusSize(); ++i) {
                StatusBase status = p.pokemon.getStatus(i);
                try {
                    if (!status.stopsSwitching()) continue;
                    canSwitch = false;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (p.pokemon.heldItem != null && (p.pokemon.heldItem.func_77973_b() == PixelmonItemsHeld.choiceBand || p.pokemon.heldItem.func_77973_b() == PixelmonItemsHeld.choiceScarf || p.pokemon.heldItem.func_77973_b() == PixelmonItemsHeld.choiceSpectacles)) {
                p.pokemon.mustUseLastMove = true;
            }
            if (p.attack == null || p.attack != null && !p.attack.doesPersist(p.pokemon)) {
                pokemonToChoose.add(p);
                p.wait = true;
                continue;
            }
            p.wait = false;
        }
        if (pokemonToChoose.size() > 0) {
            Pixelmon.network.sendTo((IMessage)new BackToMainMenu(canSwitch, pokemonToChoose), this.player);
        }
        return null;
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper pw, int[] newPixelmonId) {
        PixelmonWrapper newWrapper;
        double x = this.player.field_70165_t;
        double y = this.player.field_70163_u;
        double z = this.player.field_70161_v;
        pw.pokemon.battleStats.clearBattleStats();
        if (!pw.pokemon.isFainted) {
            pw.pokemon.getAbility().applySwitchOutEffect(pw, pw.bc);
            ChatHandler.sendBattleMessage((Entity)this.player, "playerparticipant.enough", pw.pokemon.getLocalizedName());
            this.bc.sendToOthers(this.player.getDisplayName(), this, "playerparticipant.withdrew", this.player.getDisplayName(), pw.pokemon.getLocalizedName());
        }
        pw.pokemon.catchInPokeball();
        if (this.storage.EntityAlreadyExists(newPixelmonId, this.player.field_70170_p)) {
            EntityPixelmon oldPokemon = this.storage.getAlreadyExists(newPixelmonId, this.player.field_70170_p);
            oldPokemon.field_70153_n = null;
            oldPokemon.catchInPokeball();
        }
        EntityPixelmon newPixelmon = this.storage.sendOut(newPixelmonId, pw.pokemon.func_70902_q().field_70170_p);
        newPixelmon.field_70179_y = 0.0;
        newPixelmon.field_70181_x = 0.0;
        newPixelmon.field_70159_w = 0.0;
        newPixelmon.func_70012_b(x, y, z, this.player.field_70177_z, 0.0f);
        newPixelmon.releaseFromPokeball();
        ChatHandler.sendBattleMessage((Entity)this.player, "playerparticipant.go", newPixelmon.getNickname().equals("") ? newPixelmon.getLocalizedName() : newPixelmon.getNickname());
        this.bc.sendToOthers((this.player.getDisplayName() + " sent out " + newPixelmon.getNickname()).equals("") ? newPixelmon.getLocalizedName() : newPixelmon.getNickname() + "!", this, new Object[0]);
        int index = 0;
        for (int i = 0; i < this.controlledPokemon.length; ++i) {
            if (this.controlledPokemon[i] != pw) continue;
            index = i;
        }
        this.controlledPokemon[index] = newWrapper = new PixelmonWrapper(this, newPixelmon, this.bc);
        for (BattleParticipant p : this.bc.participants) {
            p.updateOtherPokemon();
        }
        newWrapper.pokemon.getAbility().applySwitchInEffect(newWrapper, this.bc);
        this.attackersList.add(newPixelmon.getPokemonId());
        return newWrapper;
    }

    @Override
    public boolean checkPokemon() {
        for (NBTTagCompound n : this.storage.getList()) {
            if (n == null || n.func_74762_e("PixelmonNumberMoves") != 0) continue;
            ChatHandler.sendChat((Entity)this.player, "playerparticipant.load", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
        this.storage.update(pw.pokemon, EnumUpdateType.HP);
    }

    @Override
    public EntityLivingBase getEntity() {
        return this.player;
    }

    @Override
    public void updateOtherPokemon() {
        if (this.bc == null) {
            this.EndBattle();
            return;
        }
        ArrayList<PixelmonWrapper> opponents = this.bc.getOpponentPokemon(this);
        for (int i = 0; i < opponents.size(); ++i) {
            if (opponents.get(i) != null) continue;
            opponents.remove(i);
            --i;
        }
        PixelmonData[] data = new PixelmonData[opponents.size()];
        for (int i = 0; i < opponents.size(); ++i) {
            data[i] = new PixelmonData(opponents.get((int)i).pokemon);
        }
        Pixelmon.network.sendTo((IMessage)new SetPokemonBattleData(data), this.player);
        Pixelmon.network.sendTo((IMessage)new SetBattlingPokemon(this.getTeamPokemonList()), this.player);
        if (this.bc.getTeam(this).size() > 1) {
            ArrayList<BattleParticipant> team = this.bc.getTeam(this);
            ArrayList<PixelmonWrapper> otherTeamPokemon = new ArrayList<PixelmonWrapper>();
            for (BattleParticipant p : team) {
                if (p == this) continue;
                Collections.addAll(otherTeamPokemon, p.controlledPokemon);
            }
            Pixelmon.network.sendTo((IMessage)new SetPokemonTeamData(otherTeamPokemon), this.player);
        }
    }

    public void updatePokemonHealth(EntityPixelmon pixelmon) {
        this.updateOtherPokemon();
        if (pixelmon.field_70128_L || pixelmon.isFainted || pixelmon.func_110143_aJ() <= 0.0f) {
            this.GivePlayerExp(pixelmon);
        }
    }

    public void checkPlayerItems() {
        for (int i = 0; i < this.player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack item;
            int dmg;
            if (this.player.field_71071_by.field_70462_a[i] == null || !(this.player.field_71071_by.field_70462_a[i].func_77973_b() instanceof ItemShrineOrb) || (dmg = (item = this.player.field_71071_by.field_70462_a[i]).func_77960_j()) >= ItemShrineOrb.full) continue;
            item.func_77964_b(dmg + 1);
            break;
        }
    }

    public int getHighestLevel() {
        int lvl = -1;
        for (NBTTagCompound nbt : this.storage.getList()) {
            if (nbt == null || nbt.func_74762_e("Level") <= lvl) continue;
            lvl = nbt.func_74762_e("Level");
        }
        return lvl;
    }

    @Override
    public void tick() {
        this.player.func_70050_g(this.startAir);
        try {
            if (!PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player).guiOpened) {
                this.openGui();
            }
        }
        catch (PlayerNotLoadedException e) {
            e.printStackTrace();
        }
    }

    public void GivePlayerExp(EntityPixelmon pixelmon) {
        int opponentPixelmonLevel = pixelmon.getLvl().getLevel();
        int ExpAmmount = 0;
        int divisor = 5;
        if (opponentPixelmonLevel >= 75) {
            ExpAmmount = opponentPixelmonLevel / (divisor * 5);
            this.player.func_71023_q(ExpAmmount);
        } else if (opponentPixelmonLevel >= 50) {
            ExpAmmount = opponentPixelmonLevel / (divisor * 4);
            this.player.func_71023_q(ExpAmmount);
        } else if (opponentPixelmonLevel >= 35) {
            ExpAmmount = opponentPixelmonLevel / (divisor * 2);
            this.player.func_71023_q(ExpAmmount);
        } else if (opponentPixelmonLevel > divisor) {
            ExpAmmount = opponentPixelmonLevel / divisor;
            this.player.func_71023_q(ExpAmmount);
        } else {
            this.player.func_71023_q(1);
        }
    }

    public void openGui() {
        if (this.guiCheck == 0L || System.currentTimeMillis() - this.guiCheck > 1000L) {
            this.player.openGui((Object)Pixelmon.instance, EnumGui.Battle.getIndex().intValue(), this.player.field_70170_p, BattleRegistry.getIndex(this.bc), 0, 0);
            this.guiCheck = System.currentTimeMillis();
        }
    }

    @Override
    public void transferToDimension(int dimID) {
        this.player.field_71133_b.func_71203_ab().transferPlayerToDimension(this.player, dimID, (Teleporter)new BlankTeleporter((WorldServer)this.player.field_70170_p));
        if (dimID == BattleDimWorldProvider.DimID) {
            for (PixelmonWrapper p : this.controlledPokemon) {
                p.transferToDimension(dimID);
            }
        }
    }

    @Override
    public void setPosition(double[] ds) {
        this.player.field_71135_a.func_147364_a(ds[0], ds[1], ds[2], this.player.field_70177_z, this.player.field_70125_A);
    }

    @Override
    public void sendDamagePacket(EntityPixelmon user, BattleDamageSource source, int damage) {
        Pixelmon.network.sendTo((IMessage)new DamagePacket(user, source, damage), this.player);
    }

    @Override
    public void sendHealPacket(EntityPixelmon target, int amount) {
        Pixelmon.network.sendTo((IMessage)new HealPacket(target, amount), this.player);
    }
}

