/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.IBattlingNPC;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import java.util.ArrayList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentStyle;
import net.minecraft.util.ChatComponentText;

public class TrainerParticipant
extends BattleParticipant {
    public IBattlingNPC trainer;

    public TrainerParticipant(IBattlingNPC trainer, EntityPlayer opponent, int numPokemon) throws Exception {
        super(numPokemon);
        if (trainer.canStartBattle(opponent, true)) {
            this.trainer = trainer;
            for (int i = 0; i < numPokemon; ++i) {
                EntityPixelmon p = trainer.releasePokemon();
                this.controlledPokemon[i] = new PixelmonWrapper(this, p);
            }
        } else {
            throw new Exception("Already Battled");
        }
    }

    @Override
    public void StartBattle(BattleControllerBase bc) {
        super.StartBattle(bc);
        this.trainer.setBattleController(bc);
        this.trainer.startBattle(bc.getOpponents(this).get(0));
        if (this.trainer.getBossMode() != EnumBossMode.NotBoss) {
            int lvl = 1;
            for (BattleParticipant p : bc.participants) {
                if (p.team == this.team || !(p instanceof PlayerParticipant) || lvl >= ((PlayerParticipant)p).getHighestLevel()) continue;
                lvl = ((PlayerParticipant)p).getHighestLevel();
            }
            lvl += this.trainer.getBossMode().extraLevels;
            for (PixelmonWrapper p : this.controlledPokemon) {
                p.pokemon.getLvl().setLevel(lvl);
                if (p.pokemon.getMoveset().size() != 0) continue;
                p.pokemon.loadMoveset();
            }
        }
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.Trainer;
    }

    @Override
    public boolean hasMorePokemon() {
        return this.trainer.hasAblePokemon();
    }

    @Override
    public boolean canGainXP() {
        return false;
    }

    @Override
    public void EndBattle() {
        ArrayList<BattleParticipant> opponents = new ArrayList<BattleParticipant>();
        for (BattleParticipant p : this.bc.participants) {
            if (p.team == this.team) continue;
            opponents.add(p);
        }
        if (this.hasMorePokemon()) {
            PixelmonWrapper faintedPokemon = this.getFaintedPokemon();
            if (faintedPokemon != null) {
                faintedPokemon.pokemon.battleStats.clearBattleStats();
                faintedPokemon.pokemon.EndBattle();
                faintedPokemon.pokemon.clearStatus();
                faintedPokemon.pokemon.func_70106_y();
            }
            this.trainer.setAttackTargetPix(null);
            this.trainer.healAllPokemon();
            for (PixelmonWrapper p : this.controlledPokemon) {
                p.pokemon.unloadEntity();
            }
            this.trainer.winBattle(opponents);
        } else {
            this.trainer.loseBattle(opponents);
            for (PixelmonWrapper pw : this.controlledPokemon) {
                if (pw.pokemon == null) continue;
                pw.pokemon.EndBattle();
            }
        }
        this.trainer.setBattleController(null);
    }

    @Override
    public void getNextPokemon() {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!pw.pokemon.field_70128_L && !pw.pokemon.isFainted && !pw.pokemon.isEgg && !(pw.pokemon.func_110143_aJ() <= 0.0f)) continue;
            this.bc.SwitchPokemon(pw.pokemon.getPokemonId(), this.trainer.getNextPokemonID(), true);
        }
    }

    @Override
    public ChatComponentStyle getName() {
        return new ChatComponentText(this.trainer.getNPCName());
    }

    @Override
    public Attack getMove(PixelmonWrapper p) {
        return Attack.getWhichMoveIsBest(p);
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper oldPokemon, int[] newPixelmonId) {
        oldPokemon.pokemon.battleStats.clearBattleStats();
        if (!oldPokemon.pokemon.isFainted) {
            oldPokemon.pokemon.getAbility().applySwitchOutEffect(oldPokemon, oldPokemon.bc);
            this.bc.sendToOthers("playerparticipant.withdrew", this, this.trainer.getNPCName(), oldPokemon.pokemon.getNickname());
        }
        oldPokemon.pokemon.catchInPokeball();
        this.trainer.getPokemonStorage().getNBT(oldPokemon.pokemon.getPokemonId()).func_74757_a("IsFainted", true);
        EntityPixelmon pixelmon = this.trainer.releasePokemon();
        int index = 0;
        for (int i = 0; i < this.controlledPokemon.length; ++i) {
            if (this.controlledPokemon[i] != oldPokemon) continue;
            index = i;
        }
        PixelmonWrapper newWrapper = new PixelmonWrapper(this, pixelmon, this.bc);
        if (this.trainer.getBossMode() != EnumBossMode.NotBoss) {
            int lvl = 1;
            for (BattleParticipant p : this.bc.participants) {
                if (p.team == this.team || !(p instanceof PlayerParticipant) || lvl >= ((PlayerParticipant)p).getHighestLevel()) continue;
                lvl = ((PlayerParticipant)p).getHighestLevel();
            }
            newWrapper.pokemon.getLvl().setLevel(lvl += this.trainer.getBossMode().extraLevels);
        }
        this.controlledPokemon[index] = newWrapper;
        this.bc.sendToOthers("pixelmon.battletext.sentout", this, this.trainer.getNPCName(), pixelmon.getNickname());
        for (BattleParticipant p : this.bc.participants) {
            p.updateOtherPokemon();
        }
        this.attackersList.add(pixelmon.getPokemonId());
        newWrapper.pokemon.getAbility().applySwitchInEffect(newWrapper, this.bc);
        return newWrapper;
    }

    @Override
    public boolean checkPokemon() {
        for (NBTTagCompound n : this.trainer.getPokemonStorage().getList()) {
            if (n == null || n.func_74762_e("PixelmonNumberMoves") != 0) continue;
            if (PixelmonConfig.printErrors) {
                System.out.println("Couldn't load pokemon's moves");
            }
            return false;
        }
        return true;
    }

    @Override
    public void updatePokemon(PixelmonWrapper p) {
        if (this.trainer != null && p.pokemon != null) {
            this.trainer.getPokemonStorage().getNBT(p.pokemon.getPokemonId()).func_74757_a("IsFainted", true);
        }
    }

    public EntityLiving getEntity() {
        return this.trainer.getEntity();
    }

    @Override
    public void updateOtherPokemon() {
    }

    @Override
    public void transferToDimension(int dimID) {
    }
}

