/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ChatComponentStyle;
import net.minecraft.util.ChatComponentTranslation;

public class WildPixelmonParticipant
extends BattleParticipant {
    public WildPixelmonParticipant(EntityPixelmon ... pixelmon) {
        super(pixelmon.length);
        for (int i = 0; i < pixelmon.length; ++i) {
            this.controlledPokemon[i] = new PixelmonWrapper(this, pixelmon[i]);
        }
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.WildPokemon;
    }

    @Override
    public boolean hasMorePokemon() {
        return false;
    }

    @Override
    public boolean canGainXP() {
        return false;
    }

    @Override
    public void StartBattle(BattleControllerBase bc) {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.pokemon.getBossMode() != EnumBossMode.NotBoss) {
                int lvl = 1;
                for (BattleParticipant p : bc.participants) {
                    if (p.team == this.team || !(p instanceof PlayerParticipant) || lvl >= ((PlayerParticipant)p).getHighestLevel()) continue;
                    lvl = ((PlayerParticipant)p).getHighestLevel();
                }
                pw.pokemon.getLvl().setLevel(lvl += pw.pokemon.getBossMode().extraLevels);
                pw.pokemon.loadMoveset();
            }
            pw.pokemon.func_70606_j(pw.pokemon.stats.HP);
            for (int i = 0; i < 4; ++i) {
                if (pw.pokemon.getMoveset().attacks[i] == null) continue;
                pw.pokemon.getMoveset().attacks[i].setDisabled(false, pw.pokemon);
            }
        }
        super.StartBattle(bc);
    }

    @Override
    public void EndBattle() {
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.pokemon.EndBattle();
            if (pw.pokemon.isFainted || pw.pokemon.field_70128_L || PixelmonConfig.despawnOnFleeOrLoss) {
                pw.pokemon.func_70106_y();
                continue;
            }
            pw.pokemon.battleStats.clearBattleStats();
            pw.pokemon.clearStatus();
            pw.pokemon.func_70606_j(pw.pokemon.stats.HP);
            for (Attack a : pw.pokemon.getMoveset().attacks) {
                if (a == null) continue;
                a.pp = a.ppBase;
            }
        }
    }

    @Override
    public void getNextPokemon() {
    }

    @Override
    public ChatComponentStyle getName() {
        return new ChatComponentTranslation("pixelmon." + this.controlledPokemon[0].pokemon.getLocalizedName().toLowerCase() + ".name", new Object[0]);
    }

    @Override
    public Attack getMove(PixelmonWrapper pw) {
        if (pw.pokemon.getMoveset().size() > 0) {
            return Attack.getWhichMoveIsBest(pw);
        }
        if (this.bc == null) {
            return null;
        }
        this.bc.setFlee(pw.pokemon.getPokemonId());
        return null;
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper pw, int[] newPixelmonId) {
        return null;
    }

    @Override
    public boolean checkPokemon() {
        boolean allGood = true;
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.pokemon.getMoveset().size() != 0) continue;
            pw.pokemon.loadMoveset();
            if (pw.pokemon.getMoveset().size() != 0) continue;
            if (PixelmonConfig.printErrors) {
                System.out.println("Couldn't load " + pw.pokemon.getLocalizedName() + "'s moves");
            }
            allGood = false;
        }
        return allGood;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
    }

    public EntityLiving getEntity() {
        return this.controlledPokemon[0].pokemon;
    }

    @Override
    public void updateOtherPokemon() {
    }

    @Override
    public void transferToDimension(int dimID) {
        this.controlledPokemon[0].transferToDimension(dimID);
    }

    @Override
    public void setPosition(double[] ds) {
    }
}

