/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.Random;

public class Confusion
extends StatusBase {
    private int effectTurns = new Random().nextInt(4) + 2;

    public Confusion() {
        super(StatusType.Confusion);
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) throws Exception {
        --this.effectTurns;
        if (this.effectTurns == 0) {
            user.bc.sendToAll("pixelmon.status.confusionsnap", user.pokemon.getNickname());
            user.pokemon.removeStatus(this);
            return true;
        }
        user.bc.sendToAll("pixelmon.status.confused", user.pokemon.getNickname());
        if (user.pokemon.func_70681_au().nextFloat() < 0.5f) {
            user.pokemon.doBattleDamage(user, this.calculateConfusionDamage(user.pokemon));
            user.bc.sendToAll("pixelmon.status.confusionhurtself", user.pokemon.getNickname());
            return false;
        }
        return true;
    }

    private int calculateConfusionDamage(EntityPixelmon user) throws Exception {
        double stab = 1.0;
        double type = 1.0;
        double critical = 1.0;
        double rand = (double)RandomHelper.getRandomNumberBetween(85, 100) / 100.0;
        double modifier = stab * type * critical * rand;
        double attack = (double)user.battleStats.attackStat * (user.battleStats.getAttackModifier() * user.battleStats.getHeldItemAttackModifier()) / 100.0;
        double defence = (double)user.battleStats.defenceStat * (double)user.battleStats.getDefenceModifier() / 100.0;
        double Damage2 = ((double)(2 * user.getLvl().getLevel() + 10) / 250.0 * (attack / defence) * 40.0 + 2.0) * modifier;
        return (int)Math.floor(Damage2);
    }
}

