/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class PartialTrap
extends StatusBase {
    public AttackBase variant;
    int turnsToGo;

    public PartialTrap(AttackBase variant) {
        super(StatusType.PartialTrap);
        this.variant = variant;
        this.turnsToGo = RandomHelper.getRandomNumberBetween(4, 5);
    }

    @Override
    public boolean stopsSwitching() {
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper user) throws Exception {
        --this.turnsToGo;
        if (this.turnsToGo == 0) {
            user.pokemon.removeStatus(this);
            if (this.variant.getUnLocalizedName().equals("Sand Tomb")) {
                user.bc.sendToAll("pixelmon.status.freefromsandtomb", user.pokemon.getNickname());
            } else if (this.variant.getUnLocalizedName().equals("Clamp")) {
                user.bc.sendToAll("pixelmon.status.freefromclamp", user.pokemon.getNickname());
            } else if (this.variant.getUnLocalizedName().equals("Magma Storm")) {
                user.bc.sendToAll("pixelmon.status.freefromwhirlpool", user.pokemon.getNickname());
            } else if (this.variant.getUnLocalizedName().equals("Wrap")) {
                user.bc.sendToAll("pixelmon.status.freefromwrap", user.pokemon.getNickname());
            } else if (this.variant.getUnLocalizedName().equals("Bind")) {
                user.bc.sendToAll("pixelmon.status.freefrombind", user.pokemon.getNickname());
            } else if (this.variant.getUnLocalizedName().equals("Fire Spin")) {
                user.bc.sendToAll("pixelmon.status.freefromfirespin", user.pokemon.getNickname());
            }
            return;
        }
        user.pokemon.doBattleDamage(user, user.pokemon.func_110138_aP() / 16.0f);
        user.bc.sendToAll("pixelmon.status.hurtby", user.pokemon.getNickname(), this.variant.getLocalizedName());
    }
}

