/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public class Sleep
extends StatusPersist {
    int effectTurns = -1;
    boolean setTurns = false;

    public Sleep() {
        super(StatusType.Sleep);
        this.effectTurns = RandomHelper.getRandomNumberBetween(1, 4);
    }

    public Sleep(int i) {
        super(StatusType.Sleep);
        this.effectTurns = i;
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) throws Exception {
        if (this.effectTurns == 0) {
            user.bc.sendToAll("pixelmon.status.wokeup", user.pokemon.getNickname());
            user.pokemon.removeStatus(this);
            return true;
        }
        if (a.baseAttack.getUnLocalizedName().equals("Sleep Talk")) {
            ArrayList<Attack> attacks = new ArrayList<Attack>();
            for (Attack b : user.pokemon.getMoveset()) {
                if (b == a) continue;
                attacks.add(b);
            }
            boolean reducePP = false;
            Attack newAttack = (Attack)attacks.get(new Random().nextInt(attacks.size()));
            for (PixelmonWrapper target : user.targets) {
                reducePP = reducePP || newAttack.use(user, target);
            }
            if (reducePP) {
                --newAttack.pp;
            }
            return true;
        }
        user.bc.sendToAll("pixelmon.status.stillsleeping", user.pokemon.getNickname());
        return false;
    }

    @Override
    public void turnTick(PixelmonWrapper user) throws Exception {
        if (this.effectTurns == 0) {
            user.bc.sendToAll("pixelmon.status.wakesup", user.pokemon.getNickname());
            user.pokemon.removeStatus(this);
        }
        --this.effectTurns;
    }

    @Override
    public void writeToNBT(int i, NBTTagCompound nbt) throws Exception {
        super.writeToNBT(i, nbt);
        nbt.func_74768_a("StatusSleepTurns", this.effectTurns);
    }

    @Override
    public StatusBase restoreFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("StatusSleepTurns")) {
            return new Sleep(nbt.func_74762_e("StatusSleepTurns"));
        }
        return new Sleep();
    }
}

