/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;

public abstract class StatusBase {
    public StatusType type;

    public StatusBase(StatusType type) {
        this.type = type;
    }

    public boolean stopsSwitching() throws Exception {
        return false;
    }

    public boolean clearsOnBattleEnd() throws Exception {
        return true;
    }

    public void applyRepeatedEffect(PixelmonWrapper entityPixelmon) throws Exception {
    }

    public boolean canAttackThisTurn(PixelmonWrapper pixelmon1, Attack a) throws Exception {
        return true;
    }

    public boolean stopsIncomingAttack(PixelmonWrapper user) throws Exception {
        return false;
    }

    public double adjustDealtDamage(Attack attack, double damage, EntityPixelmon user, EntityPixelmon target, double crit) throws Exception {
        return damage;
    }

    public double adjustRecievedDamage(Attack a, double damage, EntityPixelmon user, EntityPixelmon target, double crit) throws Exception {
        return damage;
    }

    public boolean stopsStatusChange() throws Exception {
        return false;
    }

    public void turnTick(PixelmonWrapper pixelmon1) throws Exception {
    }

    public boolean cantMiss(PixelmonWrapper user) throws Exception {
        return false;
    }

    public boolean participantMovesFirst(EntityPixelmon user, EntityPixelmon target) throws Exception {
        return false;
    }

    public void onDamageRecieved(PixelmonWrapper user, EntityPixelmon pokemon, Attack a, int damage) {
    }

    public boolean hasPriorityEffect() {
        return false;
    }

    public boolean isTeamStatus() {
        return false;
    }

    public void applyEffectOnSwitch(PixelmonWrapper pokemon) {
    }

    public void applyAfterEffect(EntityPixelmon pokemon) {
    }

    public void applyBeforeEffect(EntityPixelmon user, EntityPixelmon target) {
    }

    public ArrayList<EnumType> getEffectiveTypes(EntityPixelmon pokemon) {
        return pokemon.type;
    }

    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        return stats;
    }

    public boolean allowsCriticalHit(PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return true;
    }
}

