/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.status.Burn;
import com.pixelmonmod.pixelmon.battles.status.Freeze;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.PoisonBadly;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import java.util.ArrayList;

public enum StatusType {
    Burn,
    Confusion,
    Cursed,
    Infatuated,
    Flee,
    Flinch,
    Flying,
    Freeze,
    Leech,
    LightScreen,
    Mist,
    Paralysis,
    Poison,
    PoisonBadly,
    Protect,
    SafeGuard,
    Sleep,
    SmackedDown,
    Substitute,
    Sunny,
    Wait,
    TrickRoom,
    Perish,
    Yawn,
    Disable,
    Immobilize,
    Recharge,
    AquaRing,
    UnderGround,
    Transformed,
    MeanLook,
    FutureSight,
    MagnetRise,
    Spikes,
    ToxicSpikes,
    StealthRock,
    PartialTrap,
    Reflect,
    Submerged,
    Raging,
    Telekinesis,
    Tailwind;

    static ArrayList<StatusPersist> restoreStatusList;

    public static StatusType getStatusEffect(String string) {
        for (StatusType t : StatusType.values()) {
            if (!t.toString().equalsIgnoreCase(string)) continue;
            return t;
        }
        return null;
    }

    public static boolean isStatusEffect(String string) {
        for (StatusType t : StatusType.values()) {
            if (!t.toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static StatusType getEffect(int integer) {
        for (StatusType t : StatusType.values()) {
            if (t.ordinal() != integer) continue;
            return t;
        }
        return null;
    }

    public static StatusPersist getEffectInstance(int integer) {
        StatusType type = null;
        for (StatusType t : StatusType.values()) {
            if (t.ordinal() != integer) continue;
            type = t;
        }
        if (type != null) {
            for (StatusPersist s : restoreStatusList) {
                if (s.type != type) continue;
                return s;
            }
        }
        return null;
    }

    public static boolean isPrimaryStatus(StatusType status) {
        return status.equals((Object)Poison) || status.equals((Object)Burn) || status.equals((Object)PoisonBadly) || status.equals((Object)Freeze) || status.equals((Object)Sleep) || status.equals((Object)Paralysis);
    }

    static {
        restoreStatusList = new ArrayList();
        restoreStatusList.add(new Burn());
        restoreStatusList.add(new Freeze());
        restoreStatusList.add(new Poison());
        restoreStatusList.add(new PoisonBadly());
        restoreStatusList.add(new Sleep());
    }
}

