/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.achievement.PixelmonAchievements;
import com.pixelmonmod.pixelmon.api.events.PokeLootClaimedEvent;
import com.pixelmonmod.pixelmon.blocks.TileEntityPokeChest;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.pokeloot.PokeLoot;
import com.pixelmonmod.pixelmon.pokeloot.client.CommonProxy;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BlockPokeChest
extends BlockContainer {
    private Class pokeChestTileEntityClass;
    protected TileEntityPokeChest.Type TYPE = TileEntityPokeChest.Type.POKEBALL;
    private IIcon blockIconHidden;
    protected Random rand = new Random();
    private String itemName = "pokeChest";
    protected int randomInt = 0;
    private int owner = 0;
    ItemStack[] drops = null;
    private double xVel = 0.1;
    private double yVel = 0.2;
    private double zVel = 0.1;

    public BlockPokeChest(Class tileEntityClass) {
        super(Material.field_151592_s);
        this.func_149647_a(PokeLoot.tabPokeLoot);
        this.pokeChestTileEntityClass = tileEntityClass;
        this.field_149758_A = true;
        this.field_149768_d = "pixelmon:pokeChestFront";
        this.func_149663_c("poke chest");
    }

    protected Item ChestDrop() {
        this.randomInt = this.rand.nextInt(3000) + 1;
        if (this.randomInt == 1975) {
            return PixelmonItemsPokeballs.masterBall;
        }
        this.randomInt = this.rand.nextInt(100) + 1;
        if (this.randomInt <= 35) {
            return PokeLoot.drops.get(this.rand.nextInt(PokeLoot.drops.size()));
        }
        if (this.randomInt <= 60) {
            return PokeLoot.PokeDrops.get(this.rand.nextInt(PokeLoot.PokeDrops.size()));
        }
        if (this.randomInt <= 75) {
            return PokeLoot.TMDrops.get(this.rand.nextInt(PokeLoot.TMDrops.size()));
        }
        if (this.randomInt <= 90) {
            return PokeLoot.StoneDrops.get(this.rand.nextInt(PokeLoot.StoneDrops.size()));
        }
        return PokeLoot.HeldDrops.get(this.rand.nextInt(PokeLoot.HeldDrops.size()));
    }

    private Item HiddenDrop() {
        this.randomInt = this.rand.nextInt(1000) + 1;
        if (this.randomInt == 669) {
            return PixelmonItemsPokeballs.masterBall;
        }
        this.randomInt = this.rand.nextInt(100) + 1;
        if (this.randomInt <= 30) {
            return PokeLoot.HeldDrops.get(this.rand.nextInt(PokeLoot.HeldDrops.size()));
        }
        if (this.randomInt <= 60) {
            return PokeLoot.StoneDrops.get(this.rand.nextInt(PokeLoot.StoneDrops.size()));
        }
        if (this.randomInt <= 80) {
            return PokeLoot.TMDrops.get(this.rand.nextInt(PokeLoot.TMDrops.size()));
        }
        if (this.randomInt <= 90) {
            return PokeLoot.PokeDrops.get(this.rand.nextInt(PokeLoot.PokeDrops.size()));
        }
        return PokeLoot.drops.get(this.rand.nextInt(PokeLoot.drops.size()));
    }

    private ItemStack[] getRandomDrops(int metadata) {
        this.rand.setSeed(System.nanoTime());
        if (metadata <= 4) {
            return new ItemStack[]{new ItemStack(this.ChestDrop())};
        }
        return new ItemStack[]{new ItemStack(this.HiddenDrop())};
    }

    public void registerIcons(IIconRegister iconReg) {
        this.field_149761_L = iconReg.func_94245_a("pixelmon:" + this.func_149739_a().substring(5) + "Front");
        this.blockIconHidden = iconReg.func_94245_a("pixelmon:hidden");
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (metadata > 4) {
            return this.blockIconHidden;
        }
        int frontFace = 4;
        if (metadata == 2) {
            frontFace = 4;
        } else if (metadata == 4) {
            frontFace = 5;
        } else if (metadata == 3) {
            frontFace = 2;
        } else if (metadata == 1) {
            frontFace = 3;
        }
        return this.field_149761_L;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityPokeChest tile = (TileEntityPokeChest)world.func_147438_o(x, y, z);
        UUID blockOwner = tile.getOwner();
        UUID playerID = ((EntityPlayerMP)player).func_110124_au();
        if (playerID != blockOwner) {
            int meta = world.func_72805_g(x, y, z);
            if (tile.canClaim(playerID)) {
                if (tile.shouldBreakBlock()) {
                    world.func_147468_f(x, y, z);
                }
                this.drops = tile.isCustomDrop() ? tile.getCustomDrops() : this.getRandomDrops(meta);
                if (tile.isGrotto()) {
                    player.func_71064_a((StatBase)PixelmonAchievements.grottoChieve, 1);
                }
                for (ItemStack drop : this.drops) {
                    if (drop.func_77973_b() == PixelmonItemsPokeballs.masterBall) {
                        player.func_71064_a((StatBase)PixelmonAchievements.masterBallChieve, 1);
                    }
                    DropItemHelper.giveItemStackToPlayer(player, drop);
                }
                this.itemName = this.drops.length == 0 ? "pokeChest" : this.drops[0].func_77973_b().func_77653_i(this.drops[0]);
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestfound", this.itemName);
                Pixelmon.EVENT_BUS.post((Event)new PokeLootClaimedEvent(player, tile));
                tile.removeClaimer(playerID);
                tile.addClaimer(playerID);
                world.func_72956_a((Entity)player, "pixelmon:pixelmon.block.PokelootObtained", 0.2f, 1.0f);
                if (meta > 4) {
                    player.func_71064_a((StatBase)PixelmonAchievements.hiddenLootChieve, 1);
                } else {
                    player.func_71064_a((StatBase)PixelmonAchievements.normalLootChieve, 1);
                }
            } else if (tile.isTimeEnabled()) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timedclaim", new Object[0]);
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.claimedloot", new Object[0]);
            }
        } else {
            boolean shiftClick = CommonProxy.isShiftClick(player);
            if (shiftClick) {
                tile.setOwner(null);
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.ownerchanged", new Object[0]);
            } else if (player.func_71045_bC() != null) {
                ItemStack itemStack = player.func_71045_bC();
                Item itemCustom = itemStack.func_77973_b();
                if (PokeLoot.drops.contains(itemCustom) || PokeLoot.HeldDrops.contains(itemCustom) || PokeLoot.TMDrops.contains(itemCustom) || PokeLoot.StoneDrops.contains(itemCustom) || PokeLoot.PokeDrops.contains(itemCustom)) {
                    tile.setCustomDrops(itemStack);
                    tile.setOwner(null);
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestset", StatCollector.func_74838_a((String)(itemStack.func_77977_a() + ".name")));
                }
            } else {
                int curMeta = world.func_72805_g(x, y, z);
                String metaMode = "";
                if (curMeta > 4) {
                    world.func_72921_c(x, y, z, curMeta - 10, 2);
                    metaMode = "Normal";
                } else {
                    world.func_72921_c(x, y, z, curMeta + 10, 2);
                    metaMode = "Hidden";
                }
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.visible", metaMode);
            }
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack par6ItemStack) {
        if (!world.field_72995_K) {
            UUID playerID = ((EntityPlayerMP)player).func_110124_au();
            TileEntityPokeChest tile = (TileEntityPokeChest)world.func_147438_o(x, y, z);
            tile.setOwner(playerID);
            int face = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
            world.func_72921_c(x, y, z, face + 1, 2);
        }
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntityPokeChest tile;
        UUID playerID;
        if (!world.field_72995_K && (playerID = ((EntityPlayerMP)player).func_110124_au()) == (tile = (TileEntityPokeChest)world.func_147438_o(x, y, z)).getOwner()) {
            String mode = "";
            if (!(tile.getChestMode() || tile.getDropMode() || tile.isTimeEnabled())) {
                tile.setChestOneTime(false);
                tile.setDropOneTime(true);
                tile.setTimeEnabled(false);
                mode = "Permanent, Limit 1 Drop";
            } else if (!tile.getChestMode() && tile.getDropMode() && !tile.isTimeEnabled()) {
                tile.setDropOneTime(true);
                tile.setChestOneTime(false);
                tile.setTimeEnabled(true);
                mode = "Timed Drops";
            } else if (tile.isTimeEnabled()) {
                tile.setTimeEnabled(false);
                tile.setDropOneTime(true);
                tile.setChestOneTime(true);
                mode = "First Come, First Served";
            } else if (tile.getChestMode() && tile.getDropMode() && !tile.isTimeEnabled()) {
                tile.setChestOneTime(false);
                tile.setDropOneTime(false);
                tile.setTimeEnabled(false);
                mode = "Permanent, Unlimited Drops";
            }
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestmode", mode);
        }
    }

    public TileEntity func_149915_a(World par1World, int var1) {
        try {
            TileEntityPokeChest tileP = (TileEntityPokeChest)((Object)this.pokeChestTileEntityClass.newInstance());
            tileP.setType(this.TYPE);
            return tileP;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (world.func_72805_g(x, y, z) > 4) {
            float rand = random.nextFloat() * 0.5f + 1.0f;
            world.func_72869_a("instantSpell", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.xVel * (double)rand, this.yVel * (double)rand, this.zVel * (double)rand);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        this.setBlockBounds();
        return super.func_149668_a(par1World, par2, par3, par4);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World par1World, int par2, int par3, int par4) {
        this.setBlockBounds();
        return super.func_149633_g(par1World, par2, par3, par4);
    }

    public void setBlockBounds() {
        this.func_149676_a(0.29f, 0.0f, 0.29f, 0.72f, 0.44f, 0.72f);
    }
}

