/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.blocks.BlockRotation;
import com.pixelmonmod.pixelmon.tools.Vector3f;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class MultiBlock
extends BlockContainer {
    public int width;
    public int height;
    public int length;

    protected MultiBlock(Material par2Material, int width, int height, int length) {
        super(par2Material);
        this.width = width;
        this.height = height;
        this.length = length;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        this.setBlockBounds(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4));
        return super.func_149668_a(par1World, par2, par3, par4);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World par1World, int par2, int par3, int par4) {
        this.setBlockBounds(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4));
        return super.func_149633_g(par1World, par2, par3, par4);
    }

    public void setBlockBounds(World world, int x, int y, int z, int meta) {
        if (meta < 4) {
            BlockRotation rot = BlockRotation.getRotationFromMetadata(meta);
            if (rot == BlockRotation.Normal) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, this.width, this.height, this.length);
            } else if (rot == BlockRotation.Rotate180) {
                this.func_149676_a(-this.width + 1, 0.0f, 0.0f, 1.0f, this.height, this.length);
            } else if (rot == BlockRotation.CCW) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, this.length, this.height, this.width);
            } else {
                this.func_149676_a(0.0f, 0.0f, (float)(-1 * this.width) + 1.0f, this.length, this.height, 1.0f);
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public abstract Item getDroppedItem(World var1, int var2, int var3, int var4);

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata > 4) {
            return null;
        }
        return super.createTileEntity(world, metadata);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        Item item;
        int meta = world.func_72805_g(x, y, z);
        Vector3f location = this.findBaseBlock(world, x, y, z, meta);
        if (location.x != (float)x || location.y != (float)y || location.z != (float)z) {
            meta = world.func_72805_g((int)location.x, (int)location.y, (int)location.z);
        }
        if (meta < 4 && (item = this.getDroppedItem(world, (int)location.x, (int)location.y, (int)location.z)) != null && !player.field_71075_bZ.field_75098_d) {
            this.func_149642_a(world, (int)location.x, (int)location.y, (int)location.z, new ItemStack(item));
        }
        this.setMultiBlocksWidth((int)location.x, (int)location.y, (int)location.z, BlockRotation.getRotationFromMetadata(meta), world, this);
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
    }

    public Vector3f findBaseBlock(World world, int x, int y, int z, int meta) {
        if (meta == 8) {
            --y;
        } else if (meta == 9) {
            --x;
        } else if (meta == 10) {
            ++x;
        } else if (meta == 11) {
            --z;
        } else if (meta == 12) {
            ++z;
        } else {
            return new Vector3f(x, y, z);
        }
        meta = world.func_72805_g(x, y, z);
        return this.findBaseBlock(world, x, y, z, meta);
    }

    private void setMultiBlocksWidth(int x, int y, int z, BlockRotation rot, World world, MultiBlock mb) {
        if (mb == null) {
            return;
        }
        if (rot == BlockRotation.Normal) {
            for (int l = 0; l < mb.length; ++l) {
                this.setMultiBlocksLength(x, y, z, 0, l, rot, world, mb);
            }
        } else if (rot == BlockRotation.CW) {
            for (int l = 0; l < mb.length; ++l) {
                this.setMultiBlocksLength(x, y, z, l, 0, rot, world, mb);
            }
        } else if (rot == BlockRotation.Rotate180) {
            for (int l = 0; l < mb.length; ++l) {
                this.setMultiBlocksLength(x, y, z, 0, -1 * l, rot, world, mb);
            }
        } else {
            for (int l = 0; l < mb.length; ++l) {
                this.setMultiBlocksLength(x, y, z, -1 * l, 0, rot, world, mb);
            }
        }
    }

    private void setMultiBlocksLength(int x, int y, int z, int xd, int zd, BlockRotation rot, World world, MultiBlock mb) {
        if (rot == BlockRotation.Normal) {
            for (int w = 0; w < mb.width; ++w) {
                this.setMultiBlocksHeight(x, y, z, xd + w, zd, rot, world, mb);
            }
        } else if (rot == BlockRotation.CW) {
            for (int w = 0; w < mb.width; ++w) {
                this.setMultiBlocksHeight(x, y, z, xd, zd - w, rot, world, mb);
            }
        } else if (rot == BlockRotation.Rotate180) {
            for (int w = 0; w < mb.width; ++w) {
                this.setMultiBlocksHeight(x, y, z, xd - w, zd, rot, world, mb);
            }
        } else {
            for (int w = 0; w < mb.width; ++w) {
                this.setMultiBlocksHeight(x, y, z, xd, zd + w, rot, world, mb);
            }
        }
    }

    private void setMultiBlocksHeight(int x, int y, int z, int xd, int zd, BlockRotation rot, World world, MultiBlock mb) {
        for (int h = 0; h < mb.height; ++h) {
            world.func_147465_d(x + xd, y + h, z + zd, Block.func_149729_e((int)0), 0, 2);
        }
    }
}

