/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.BlockRotation;
import com.pixelmonmod.pixelmon.blocks.decorative.TileEntityDecorativeBase;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.WorldServer;

public class TileEntityCloningMachine
extends TileEntityDecorativeBase {
    public static boolean enabled = true;
    public boolean hasMew = false;
    public boolean processingClone = false;
    public boolean growingPokemon = false;
    public boolean isBroken = false;
    public float xboost = 0.0f;
    public float zboost = 0.0f;
    public EntityPixelmon pixelmon;
    public String pokemonName = "";
    public boolean isShiny = false;
    public int boostLevel = 0;
    public int boostCount = 0;
    boolean boostSet = false;
    boolean travDown = true;
    public float lasPos = -2.0f;
    int baseCount = 0;
    public int pokemonProgress = 0;
    public boolean isFinished = false;

    @Override
    public boolean canUpdate() {
        return true;
    }

    private void resetMachine() {
        this.isFinished = false;
        this.growingPokemon = false;
        this.processingClone = false;
        this.isShiny = false;
        this.hasMew = false;
        this.pokemonProgress = 0;
        this.boostLevel = 0;
        this.boostCount = 0;
        this.baseCount = 0;
        this.pokemonName = "";
        ((WorldServer)this.field_145850_b).func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.boostSet) {
            BlockRotation rot = BlockRotation.getRotationFromMetadata(this.func_145832_p());
            if (rot == BlockRotation.Normal) {
                this.xboost = (float)((double)this.xboost + 3.35);
            } else if (rot == BlockRotation.Rotate180) {
                this.xboost = (float)((double)this.xboost - 3.35);
            } else {
                this.zboost = rot == BlockRotation.CW ? (float)((double)this.zboost - 3.35) : (float)((double)this.zboost + 3.35);
            }
            this.boostSet = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.processingClone && this.boostCount == 3 && this.hasMew) {
                if (this.baseCount < 30) {
                    ++this.baseCount;
                } else if (this.baseCount == 30) {
                    this.processingClone = true;
                    this.baseCount = 0;
                    ((WorldServer)this.field_145850_b).func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            if (this.processingClone) {
                ++this.baseCount;
                if (this.baseCount >= 280) {
                    boolean madeMewtwo = Math.random() < (double)((float)this.boostLevel / 40.0f);
                    this.pixelmon = madeMewtwo ? (EntityPixelmon)PixelmonEntityList.createEntityByName("Mewtwo", this.field_145850_b) : (EntityPixelmon)PixelmonEntityList.createEntityByName("Ditto", this.field_145850_b);
                    this.isShiny = this.pixelmon.getIsShiny();
                    this.pokemonName = this.pixelmon.getName();
                    this.growingPokemon = true;
                    this.processingClone = false;
                    ((WorldServer)this.field_145850_b).func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            if (this.growingPokemon) {
                if (this.pokemonProgress < 200) {
                    ++this.pokemonProgress;
                } else {
                    if (this.pokemonName.equals("Mewtwo")) {
                        this.isBroken = true;
                        this.releasePokemon();
                    } else {
                        this.isFinished = true;
                    }
                    this.growingPokemon = false;
                    ((WorldServer)this.field_145850_b).func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        } else {
            if (this.travDown) {
                this.lasPos -= 0.1f;
                if (this.lasPos < -15.0f) {
                    this.travDown = false;
                }
            } else {
                this.lasPos += 0.1f;
                if (this.lasPos >= -2.0f) {
                    this.travDown = true;
                }
            }
            if (this.growingPokemon && this.pokemonProgress < 200) {
                ++this.pokemonProgress;
            }
            if (this.processingClone) {
                ++this.baseCount;
                if (this.baseCount > 80 && this.baseCount < 280) {
                    int i = 0;
                    while ((float)i < 30.0f * ((float)this.baseCount - 80.0f) / 200.0f) {
                        this.field_145850_b.func_72869_a("reddust", (double)((float)this.field_145851_c + this.xboost + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)this.field_145848_d + 0.3f + this.field_145850_b.field_73012_v.nextFloat() + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)this.field_145849_e + this.zboost + this.field_145850_b.field_73012_v.nextFloat()), -255.0, 1.0, 255.0);
                        ++i;
                    }
                }
            }
        }
        if (this.pokemonName.equals("") && this.pixelmon != null) {
            this.pixelmon = null;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hasMew = nbt.func_74767_n("HasMew");
        this.boostCount = nbt.func_74765_d("BoostCount");
        this.boostLevel = nbt.func_74765_d("BoostLevel");
        this.isBroken = nbt.func_74767_n("IsBroken");
        this.isFinished = nbt.func_74767_n("IsFinished");
        this.processingClone = nbt.func_74767_n("ProcessingClone");
        this.growingPokemon = nbt.func_74767_n("GrowingPokemon");
        this.pokemonName = nbt.func_74779_i("PokemonName");
        this.baseCount = nbt.func_74762_e("BaseCount");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("HasMew", this.hasMew);
        nbt.func_74777_a("BoostCount", (short)this.boostCount);
        nbt.func_74777_a("BoostLevel", (short)this.boostLevel);
        nbt.func_74757_a("IsBroken", this.isBroken);
        nbt.func_74757_a("IsFinished", this.isFinished);
        nbt.func_74757_a("ProcessingClone", this.processingClone);
        nbt.func_74757_a("GrowingPokemon", this.growingPokemon);
        nbt.func_74778_a("PokemonName", this.pokemonName);
        nbt.func_74768_a("BaseCount", this.baseCount);
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void activate(EntityPlayer player) {
        if (!enabled) {
            ChatHandler.sendChat((Entity)player, "pixelmon.general.disabledblock", new Object[0]);
            return;
        }
        if (this.isFinished) {
            try {
                if (PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)player).countAblePokemon() == 0) {
                    this.releasePokemon();
                } else {
                    this.fightDitto((EntityPlayerMP)player);
                }
            }
            catch (PlayerNotLoadedException e) {
                e.printStackTrace();
            }
            this.resetMachine();
        } else if (!this.hasMew) {
            try {
                for (NBTTagCompound nbt : PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)player).getList()) {
                    if (nbt == null || !nbt.func_74779_i("Name").equals("Mew") || nbt.func_74765_d("NumCloned") >= 3) continue;
                    this.hasMew = true;
                    ((WorldServer)player.field_70170_p).func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    nbt.func_74777_a("NumCloned", (short)(nbt.func_74765_d("NumCloned") + 1));
                    break;
                }
                if (!this.hasMew) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.noclone", new Object[0]);
                }
            }
            catch (PlayerNotLoadedException e) {
                e.printStackTrace();
            }
        } else if (this.boostCount < 3 && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)player.func_71045_bC().func_77973_b()).field_150939_a;
            if (block == Blocks.field_150339_S) {
                ++this.boostCount;
                this.boostLevel += 2;
                ((WorldServer)player.field_70170_p).func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_71045_bC().field_77994_a;
                }
            } else if (block == Blocks.field_150340_R) {
                ++this.boostCount;
                this.boostLevel += 5;
                ((WorldServer)player.field_70170_p).func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_71045_bC().field_77994_a;
                }
            } else if (block == Blocks.field_150484_ah) {
                ++this.boostCount;
                this.boostLevel += 10;
                ((WorldServer)player.field_70170_p).func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_71045_bC().field_77994_a;
                }
            }
        }
    }

    private void fightDitto(EntityPlayerMP player) throws PlayerNotLoadedException {
        EntityPixelmon firstPokemon = PixelmonStorage.PokeballManager.getPlayerStorage(player).getFirstAblePokemon(player.field_70170_p);
        if (!PixelmonStorage.PokeballManager.getPlayerStorage(player).EntityAlreadyExists(firstPokemon)) {
            firstPokemon.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, 0.0f);
            firstPokemon.releaseFromPokeball();
        }
        WildPixelmonParticipant part = new WildPixelmonParticipant(this.pixelmon);
        this.pixelmon.StartBattle(new PlayerParticipant(player, firstPokemon), part);
    }

    public void releasePokemon() {
        int xplus = 0;
        int zplus = 0;
        if (this.xboost > 0.0f) {
            ++zplus;
        } else if (this.xboost < 0.0f) {
            --zplus;
        } else if (this.zboost > 0.0f) {
            --xplus;
        } else if (this.zboost < 0.0f) {
            ++xplus;
        }
        if (this.pixelmon != null && !this.pixelmon.isEgg) {
            this.pixelmon.func_70012_b((float)this.field_145851_c + this.xboost + (float)xplus, this.field_145848_d, (float)this.field_145849_e + this.zboost + (float)zplus, 0.0f, 0.0f);
            this.pixelmon.releaseFromPokeball();
        }
    }
}

