/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.events.PixelmonTradeEvent;
import com.pixelmonmod.pixelmon.blocks.TradingRegistry;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.RegisterTrader;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetSelectedStats;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetTradeTarget;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.TradeReady;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionType;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityTradeMachine
extends TileEntity {
    public int playerCount = 0;
    public EntityPlayer player1;
    public EntityPlayer player2;
    public boolean ready1;
    public boolean ready2;
    public int pos1 = -1;
    public int pos2 = -1;
    public int tradeIndex = -1;
    private boolean tradePushed = false;

    public TileEntityTradeMachine() {
        if (this.tradeIndex == -1) {
            TradingRegistry.registerTrade(this);
        }
    }

    public void registerPlayer(EntityPlayer player) {
        try {
            if (this.playerCount == 1 && player == this.player1) {
                return;
            }
            ++this.playerCount;
            if (this.playerCount == 1) {
                this.player1 = player;
            }
            if (this.playerCount == 2) {
                this.player2 = player;
            }
            player.openGui((Object)Pixelmon.instance, EnumGui.Trading.getIndex().intValue(), player.field_70170_p, this.tradeIndex, 0, 0);
            if (player == this.player2) {
                Pixelmon.network.sendTo((IMessage)new RegisterTrader(this.player1.getDisplayName()), (EntityPlayerMP)this.player2);
                Pixelmon.network.sendTo((IMessage)new RegisterTrader(this.player2.getDisplayName()), (EntityPlayerMP)this.player1);
                if (this.pos1 != -1) {
                    PlayerStorage s = PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player1);
                    NBTTagCompound n = s.getNBT(s.getIDFromPosition(this.pos1));
                    Pixelmon.network.sendTo((IMessage)new SetTradeTarget(new PixelmonData(n), new PixelmonStatsData(n)), (EntityPlayerMP)this.player2);
                    Pixelmon.network.sendTo((IMessage)new SetSelectedStats(new PixelmonStatsData(n)), (EntityPlayerMP)this.player1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean ready(EntityPlayer player, boolean ready) {
        if (this.player1 != null && this.player2 != null) {
            if (player.getDisplayName().equals(this.player1.getDisplayName())) {
                this.ready1 = ready;
                Pixelmon.network.sendTo((IMessage)new TradeReady(ready), (EntityPlayerMP)this.player2);
            }
            if (player.getDisplayName().equals(this.player2.getDisplayName())) {
                this.ready2 = ready;
                Pixelmon.network.sendTo((IMessage)new TradeReady(ready), (EntityPlayerMP)this.player1);
            }
        }
        this.tradePushed = false;
        return false;
    }

    public void setPos1(int pos) {
        try {
            this.ready1 = false;
            this.ready2 = false;
            PlayerStorage s = PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player1);
            this.pos1 = pos;
            NBTTagCompound n = s.getNBT(s.getIDFromPosition(pos));
            if (n != null && PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player1).EntityAlreadyExists(PixelmonMethods.getID(n), this.player1.field_70170_p)) {
                EntityPixelmon pixelmon = PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player1).getAlreadyExists(PixelmonMethods.getID(n), this.player1.field_70170_p);
                pixelmon.catchInPokeball();
            }
            Pixelmon.network.sendTo((IMessage)new SetSelectedStats(new PixelmonStatsData(n)), (EntityPlayerMP)this.player1);
            if (this.player2 == null) {
                return;
            }
            Pixelmon.network.sendTo((IMessage)new SetTradeTarget(new PixelmonData(n), new PixelmonStatsData(n)), (EntityPlayerMP)this.player2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPos2(int pos) {
        try {
            this.ready1 = false;
            this.ready2 = false;
            PlayerStorage s = PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player2);
            this.pos2 = pos;
            NBTTagCompound n = s.getNBT(s.getIDFromPosition(pos));
            if (n != null && PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player2).EntityAlreadyExists(PixelmonMethods.getID(n), this.player2.field_70170_p)) {
                EntityPixelmon pixelmon = PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player2).getAlreadyExists(PixelmonMethods.getID(n), this.player2.field_70170_p);
                pixelmon.catchInPokeball();
            }
            Pixelmon.network.sendTo((IMessage)new SetSelectedStats(new PixelmonStatsData(n)), (EntityPlayerMP)this.player2);
            if (this.player1 == null) {
                return;
            }
            Pixelmon.network.sendTo((IMessage)new SetTradeTarget(new PixelmonData(n), new PixelmonStatsData(n)), (EntityPlayerMP)this.player1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removePlayer(EntityPlayer player) {
        this.ready1 = false;
        this.ready2 = false;
        if (this.player1 == player) {
            this.player1 = this.player2;
            this.player2 = null;
            --this.playerCount;
            this.pos2 = -1;
        } else if (this.player2 == player) {
            this.player2 = null;
            --this.playerCount;
            this.pos2 = -1;
        }
        if (this.playerCount < 0) {
            this.playerCount = 0;
        }
        if (this.playerCount == 1) {
            Pixelmon.network.sendTo((IMessage)new RegisterTrader(""), (EntityPlayerMP)this.player1);
            Pixelmon.network.sendTo((IMessage)new SetTradeTarget(true), (EntityPlayerMP)this.player1);
        }
    }

    public void trade() {
        if (this.tradePushed || this.playerCount < 2 || !this.ready1 || !this.ready2) {
            return;
        }
        try {
            PlayerStorage storage1 = PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player1);
            PlayerStorage storage2 = PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.player2);
            this.tradePushed = true;
            NBTTagCompound pokemon1 = storage1.getNBT(storage1.getIDFromPosition(this.pos1));
            NBTTagCompound pokemon2 = storage2.getNBT(storage2.getIDFromPosition(this.pos2));
            storage1.changePokemonAndAssignID(this.pos1, pokemon2);
            storage2.changePokemonAndAssignID(this.pos2, pokemon1);
            storage1.pokedex.set(Pokedex.nameToID(pokemon2.func_74779_i("Name")), Pokedex.DexRegisterStatus.caught);
            storage1.pokedex.sendToPlayer((EntityPlayerMP)this.player1);
            storage2.pokedex.set(Pokedex.nameToID(pokemon1.func_74779_i("Name")), Pokedex.DexRegisterStatus.caught);
            storage2.pokedex.sendToPlayer((EntityPlayerMP)this.player2);
            ((EntityPlayerMP)this.player1).func_71053_j();
            ((EntityPlayerMP)this.player2).func_71053_j();
            this.playerCount = 0;
            EntityPixelmon pixelmon = storage1.sendOut(PixelmonMethods.getID(pokemon2), this.field_145850_b);
            pixelmon.friendship.setFriendship(70);
            pixelmon.checkEvolution(EvolutionType.Trade);
            pixelmon.unloadEntity();
            pixelmon = storage2.sendOut(PixelmonMethods.getID(pokemon1), this.field_145850_b);
            pixelmon.friendship.setFriendship(70);
            pixelmon.checkEvolution(EvolutionType.Trade);
            pixelmon.unloadEntity();
            Pixelmon.EVENT_BUS.post((Event)new PixelmonTradeEvent(this.player1, this.player2, pokemon1, pokemon2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        boolean playerRemoved = false;
        boolean count = false;
        if (this.player1 == null && this.playerCount > 0) {
            this.player1 = this.player2;
            this.player2 = null;
            --this.playerCount;
            this.pos2 = -1;
        } else if (this.player2 == null && this.playerCount > 1) {
            --this.playerCount;
            this.pos2 = -1;
        }
        if (this.playerCount == 1) {
            Pixelmon.network.sendTo((IMessage)new RegisterTrader(""), (EntityPlayerMP)this.player1);
        }
    }
}

