/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.decorative;

import com.pixelmonmod.pixelmon.blocks.decorative.TileEntityDecorativeBase;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockContainerPlus
extends BlockContainer {
    public static final int renderingID = RenderingRegistry.getNextAvailableRenderId();
    public DirectionType dir = DirectionType.NONE;
    protected String iconName = "quartzblock_bottom";
    public Class<? extends ModelBase> modelClass;
    protected int renderType;
    protected int amountDropped = 1;
    protected boolean opaqueCube = false;
    protected boolean renderNormalBlock = false;
    protected Class<? extends TileEntity> tileClass = TileEntityDecorativeBase.class;
    public float invScale = 1.0f;
    public float[] invOffsets = new float[]{0.0f, 0.0f, 0.0f};

    public BlockContainerPlus(Material mat) {
        super(mat);
    }

    public BlockContainerPlus setRenderOptions(int renderType, boolean opaqueCube, boolean renderNormal) {
        this.renderType = renderType;
        this.opaqueCube = opaqueCube;
        this.renderNormalBlock = renderNormal;
        return this;
    }

    public BlockContainerPlus setModelClass(Class<? extends ModelBase> modelClass) {
        this.modelClass = modelClass;
        return this;
    }

    public BlockContainerPlus setAmountDropped(int amount) {
        this.amountDropped = amount;
        return this;
    }

    public BlockContainerPlus setIconName(String name) {
        this.iconName = name;
        return this;
    }

    public BlockContainerPlus setInventoryScale(float scale) {
        this.invScale = scale;
        return this;
    }

    public BlockContainerPlus setInventoryOffsets(float x, float y, float z) {
        this.invOffsets = new float[]{x, y, z};
        return this;
    }

    public BlockContainerPlus setTileEntityClass(Class<? extends TileEntity> tileClass) {
        this.tileClass = tileClass;
        return this;
    }

    public BlockContainerPlus setDirectionalType(DirectionType type) {
        this.dir = type;
        return this;
    }

    public int func_149745_a(Random random) {
        return this.amountDropped;
    }

    public boolean func_149662_c() {
        return this.opaqueCube;
    }

    public boolean func_149686_d() {
        return this.renderNormalBlock;
    }

    public int func_149645_b() {
        return renderingID;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a(this.iconName);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        int newMeta = meta;
        switch (this.dir) {
            case NONE: {
                break;
            }
            case YAW: {
                break;
            }
            case STAIRS: {
                newMeta = this.doStairsDirectional(side, hitY, meta);
                break;
            }
            case WOODLOG: {
                newMeta = this.doWoodLogDirectional(side, meta);
                break;
            }
            case SIXAXIS: {
                newMeta = side;
            }
            case THREEAXIS: {
                newMeta = side;
            }
        }
        return newMeta;
    }

    public int doStairsDirectional(int side, float hitY, int meta) {
        int result = side != 0 && (side == 1 || (double)hitY <= 0.5) ? meta : meta | 4;
        return result;
    }

    public int doWoodLogDirectional(int side, int meta) {
        int j1 = meta & 3;
        int b0 = 0;
        switch (side) {
            case 0: 
            case 1: {
                b0 = 0;
                break;
            }
            case 2: 
            case 3: {
                b0 = 8;
                break;
            }
            case 4: 
            case 5: {
                b0 = 4;
            }
        }
        int result = j1 | b0;
        System.out.println("MetaData<woodLogDirectionType> = " + result);
        return result;
    }

    public boolean isAnotherWithSameOrientationOnSide(IBlockAccess world, int x, int y, int z, int metaData, ForgeDirection dir) {
        int[] coords = null;
        switch (dir) {
            case DOWN: {
                coords = new int[]{x, y - 1, z};
                break;
            }
            case EAST: {
                coords = new int[]{x + 1, y, z};
                break;
            }
            case NORTH: {
                coords = new int[]{x, y, z - 1};
                break;
            }
            case SOUTH: {
                coords = new int[]{x, y, z + 1};
                break;
            }
            case UP: {
                coords = new int[]{x, y + 1, z};
                break;
            }
            case WEST: {
                coords = new int[]{x - 1, y, z};
            }
        }
        Block block = world.func_147439_a((int)coords[0], (int)coords[1], (int)coords[2]);
        int metaData2 = world.func_72805_g((int)coords[0], coords[1], coords[2]);
        return block != Blocks.field_150350_a && this.isSameOrientationAndType(block.getClass(), metaData, metaData2);
    }

    public boolean isSameOrientationAndType(Class<? extends Block> blockClass, int thisMeta, int thatMeta) {
        boolean flag = false;
        switch (this.dir) {
            case SIXAXIS: {
                flag = (thisMeta & 7) / 2 == (thatMeta & 7) / 2;
                break;
            }
            case THREEAXIS: {
                flag = (thisMeta & 7) / 2 == (thatMeta & 7) / 2;
                break;
            }
            case NONE: {
                flag = true;
                break;
            }
            case STAIRS: {
                break;
            }
            case WOODLOG: {
                flag = true;
                break;
            }
            case YAW: {
                flag = true;
                break;
            }
        }
        return blockClass == ((Object)((Object)this)).getClass() && flag;
    }

    public TileEntity func_149915_a(World world, int var2) {
        try {
            return this.tileClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int rotate(int coordbaseMode, Block block, int meta) {
        return meta;
    }

    public static enum DirectionType {
        NONE,
        YAW,
        WOODLOG,
        STAIRS,
        SIXAXIS,
        THREEAXIS;

    }
}

