/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.ranch;

import com.pixelmonmod.pixelmon.blocks.ranch.BreedingConditions;
import com.pixelmonmod.pixelmon.blocks.ranch.TileEntityRanchBase;
import com.pixelmonmod.pixelmon.util.Bounds;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class RanchBounds
extends Bounds {
    TileEntityRanchBase ranch;
    private int originaltop;
    private int originalleft;
    private int originalbottom;
    private int originalright;

    public RanchBounds(TileEntityRanchBase tileEntityRanchBase) {
        this.ranch = tileEntityRanchBase;
    }

    public RanchBounds(TileEntityRanchBase ranch, int top, int left, int bottom, int right) {
        super(top, left, bottom, right);
        this.ranch = ranch;
        this.originaltop = top;
        this.originalleft = left;
        this.originalbottom = bottom;
        this.originalright = right;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("origTop", this.originaltop);
        nbt.func_74768_a("origLeft", this.originalleft);
        nbt.func_74768_a("origBot", this.originalbottom);
        nbt.func_74768_a("origRight", this.originalright);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.originaltop = nbt.func_74762_e("origTop");
        this.originalleft = nbt.func_74762_e("origLeft");
        this.originalbottom = nbt.func_74762_e("origBot");
        this.originalright = nbt.func_74762_e("origRight");
    }

    public BreedingConditions getContainingBreedingConditions(World world) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (int x = this.left; x <= this.right; ++x) {
            for (int z = this.bottom; z <= this.top; ++z) {
                int y;
                if (x == (this.left + this.right) / 2 && z == (this.top + this.bottom) / 2 || (y = world.func_72825_h(x, z)) <= -1) continue;
                blockList.add(world.func_147439_a(x, y - 1, z));
                if (world.func_147439_a(x, y, z).func_149688_o() == Material.field_151579_a) continue;
                blockList.add(world.func_147439_a(x, y, z));
            }
        }
        BreedingConditions conditions = new BreedingConditions(blockList);
        return conditions;
    }

    @Override
    public boolean canExtend(int top, int left, int bottom, int right) {
        if (this.top + top - this.originaltop >= 4) {
            return false;
        }
        if (this.left - left - this.originalleft <= -4) {
            return false;
        }
        if (this.bottom - bottom - this.originalbottom <= -4) {
            return false;
        }
        return this.right + right - this.originalright < 4;
    }

    @Override
    public void Extend(EntityPlayerMP player, int top, int left, int bottom, int right) {
        if (!this.canExtend(top, left, bottom, right)) {
            return;
        }
        this.top += top;
        this.left -= left;
        this.bottom -= bottom;
        this.right += right;
        player.field_71135_a.func_147359_a(this.ranch.func_145844_m());
    }

    @Override
    public boolean canExtend() {
        return this.canExtend(1, 0, 0, 0) || this.canExtend(0, 1, 0, 0) || this.canExtend(0, 0, 1, 0) || this.canExtend(0, 0, 0, 1);
    }

    public int[] getRandomLocation(Random rand) {
        int[] xz = new int[]{this.left + rand.nextInt(this.right - this.left + 1), this.bottom + rand.nextInt(this.top - this.bottom + 1)};
        return xz;
    }
}

