/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.ranch;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.blocks.IPokemonOwner;
import com.pixelmonmod.pixelmon.blocks.ranch.RanchBounds;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity7HasAI;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.util.Bounds;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileEntityRanchBase
extends TileEntity
implements IPokemonOwner {
    public static boolean enabled = PixelmonConfig.allowBreeding;
    private static final int refresh = 100;
    protected ArrayList<RanchPokemon> ids = new ArrayList();
    protected ArrayList<EntityPixelmon> entities = new ArrayList();
    protected RanchBounds ranchBounds = new RanchBounds(this);
    public int ranchWidth = 4;
    public int ranchLength = 4;
    int tick = 0;
    public boolean aboveGround = false;
    public int percentAbove = 0;
    long lastWorldTime = -1L;

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("idCount", this.ids.size());
        for (int i = 0; i < this.ids.size(); ++i) {
            nbt.func_74783_a("ID" + i, this.ids.get((int)i).pokemonID);
            nbt.func_74772_a("ownerLeast" + i, this.ids.get((int)i).ownerUUID.getLeastSignificantBits());
            nbt.func_74772_a("ownerMost" + i, this.ids.get((int)i).ownerUUID.getMostSignificantBits());
        }
        this.ranchBounds.writeToNBT(nbt);
        try {
            for (EntityPixelmon p : this.entities) {
                PlayerComputerStorage s = PixelmonStorage.ComputerManager.getPlayerStorage((EntityPlayerMP)p.func_70902_q());
                s.updatePokemonEntry(p);
                if (!s.hasChanges()) continue;
                PixelmonStorage.ComputerManager.savePlayer(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("idCount")) {
            int count = nbt.func_74762_e("idCount");
            this.ids.clear();
            for (int i = 0; i < count; ++i) {
                this.ids.add(new RanchPokemon(new UUID(nbt.func_74763_f("ownerMost" + i), nbt.func_74763_f("ownerLeast" + i)), nbt.func_74759_k("ID" + i)));
            }
        }
        this.ranchBounds.readFromNBT(nbt);
    }

    public boolean canUpdate() {
        return true;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public abstract void onActivate(EntityPlayer var1);

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.updateStatus();
    }

    @Override
    public void updateStatus() {
        this.func_145845_h();
    }

    public abstract boolean hasBreedingPartner(EntityPixelmon var1);

    public EntityPixelmon getFirstBreedingPartner(EntityPixelmon pixelmon) {
        ArrayList<EntityPixelmon> possiblePartners = new ArrayList<EntityPixelmon>();
        for (EntityPixelmon p : this.entities) {
            if (p == pixelmon || !EntityPixelmon.canBreed(pixelmon, p)) continue;
            possiblePartners.add(p);
        }
        if (possiblePartners.size() == 1) {
            return (EntityPixelmon)((Object)possiblePartners.get(0));
        }
        if (possiblePartners.size() > 1) {
            EntityPixelmon highestPartner = (EntityPixelmon)((Object)possiblePartners.get(0));
            for (int i = 1; i < possiblePartners.size(); ++i) {
                if (((EntityPixelmon)((Object)possiblePartners.get(i))).getNumBreedingLevels() <= highestPartner.getNumBreedingLevels()) continue;
                highestPartner = (EntityPixelmon)((Object)possiblePartners.get(i));
            }
            return highestPartner;
        }
        return null;
    }

    public abstract void claimEgg(EntityPlayerMP var1);

    public void removePokemon(EntityPlayerMP player, int[] id) {
        try {
            PlayerComputerStorage s = PixelmonStorage.ComputerManager.getPlayerStorage(player);
            NBTTagCompound tag = s.getPokemonNBT(id);
            tag.func_74757_a("isInRanch", false);
            tag.func_74777_a("BreedingInteractions", (short)-1);
            s.setChanged(id);
            EntityPixelmon pix = null;
            for (EntityPixelmon p : this.entities) {
                if (!PixelmonMethods.isIDSame(p, id)) continue;
                pix = p;
                break;
            }
            if (pix != null) {
                pix.unloadEntity();
                this.entities.remove((Object)pix);
            }
            for (int i = 0; i < this.ids.size(); ++i) {
                if (!PixelmonMethods.isIDSame(this.ids.get((int)i).pokemonID, id)) continue;
                this.ids.remove(i);
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateStatus();
    }

    public void addPokemon(EntityPlayerMP player, int[] id) {
        try {
            PlayerComputerStorage s = PixelmonStorage.ComputerManager.getPlayerStorage(player);
            this.ids.add(new RanchPokemon(player.func_110124_au(), id));
            NBTTagCompound tag = s.getPokemonNBT(id);
            tag.func_74757_a("isInRanch", true);
            tag.func_74772_a("lastBreedingTime", this.field_145850_b.func_82737_E());
            tag.func_74777_a("BreedingInteractions", (short)0);
            s.setChanged(id);
            this.tick = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateStatus();
    }

    public ArrayList<PixelmonData> getPokemonData() {
        ArrayList<PixelmonData> pokemonData = new ArrayList<PixelmonData>();
        try {
            for (RanchPokemon poke : this.ids) {
                try {
                    PlayerComputerStorage s = PixelmonStorage.ComputerManager.getPlayerStorageFromUUID(this.field_145850_b, poke.ownerUUID);
                    pokemonData.add(new PixelmonData(s.getPokemonNBT(poke.pokemonID)));
                }
                catch (Exception e) {
                    System.out.println("Player has a pokemon in a ranch block which isn't in their pc");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pokemonData;
    }

    @Override
    public int getEntityCount() {
        if (this.entities != null) {
            return this.entities.size();
        }
        return 0;
    }

    public void onDestroy() {
        if (!this.field_145850_b.field_72995_K) {
            for (EntityPixelmon p : this.entities) {
                p.unloadEntity();
            }
            try {
                for (RanchPokemon poke : this.ids) {
                    PlayerComputerStorage s = PixelmonStorage.ComputerManager.getPlayerStorageFromUUID(this.field_145850_b, poke.ownerUUID);
                    NBTTagCompound tag = s.getPokemonNBT(poke.pokemonID);
                    tag.func_74757_a("isInRanch", false);
                    s.setChanged(poke.pokemonID);
                    PixelmonStorage.ComputerManager.savePlayer(s);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private EntityPixelmon createEntity(RanchPokemon poke) {
        EntityPixelmon pixelmon = null;
        try {
            PlayerComputerStorage s = PixelmonStorage.ComputerManager.getPlayerStorageFromUUID(this.field_145850_b, poke.ownerUUID);
            pixelmon = s.getPokemonEntity(poke.pokemonID);
            if (pixelmon == null) {
                for (int i = 0; i < this.ids.size(); ++i) {
                    if (!PixelmonMethods.isIDSame(this.ids.get((int)i).pokemonID, poke.pokemonID)) continue;
                    this.ids.remove(i);
                    --i;
                }
                return null;
            }
            pixelmon.aggression = Entity7HasAI.Aggression.passive;
            pixelmon.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(4.0);
            pixelmon.setSpawnLocation(SpawnLocation.Land);
            pixelmon.resetAI();
            if (this.setLocationForEntity(pixelmon)) {
                pixelmon.releaseFromPokeball();
            }
            pixelmon.setRanchBlockOwner(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pixelmon;
    }

    private boolean setLocationForEntity(EntityPixelmon pixelmon) {
        for (int i = 0; i < 5; ++i) {
            int[] xz = this.ranchBounds.getRandomLocation(this.field_145850_b.field_73012_v);
            int y = this.field_145850_b.func_72825_h(xz[0], xz[1]);
            if (Math.abs(y - this.field_145848_d) >= 3 || !this.field_145850_b.func_147439_a(xz[0], y - 1, xz[1]).func_149688_o().func_76220_a()) continue;
            pixelmon.func_70012_b(xz[0], y, xz[1], 0.0f, 0.0f);
            if (!pixelmon.func_70601_bi()) continue;
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tick <= 0) {
                if (this.field_145850_b != null) {
                    for (int i = 0; i < this.ids.size(); ++i) {
                        EntityPixelmon p;
                        RanchPokemon poke = this.ids.get(i);
                        if (this.entityExists(poke) || !this.ownerInGame(poke) || (p = this.createEntity(poke)) == null) continue;
                        this.entities.add(p);
                    }
                    for (EntityPixelmon p : this.entities) {
                        if (p == null || p.isLoaded() || !this.setLocationForEntity(p)) continue;
                        p.releaseFromPokeball();
                    }
                } else if (this.entities.size() > 0) {
                    try {
                        while (this.entities.size() > 0) {
                            EntityPixelmon p = this.entities.get(0);
                            PlayerComputerStorage s = PixelmonStorage.ComputerManager.getPlayerStorage((EntityPlayerMP)p.func_70902_q());
                            s.updatePokemonEntry(p);
                            p.unloadEntity();
                            this.entities.remove(0);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.tick = 100;
            }
            --this.tick;
        } else {
            this.checkAboveGround();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.doBreedingChecks();
        }
    }

    private boolean ownerInGame(RanchPokemon poke) {
        return this.field_145850_b.func_152378_a(poke.ownerUUID) != null;
    }

    protected abstract void checkAboveGround();

    private void doBreedingChecks() {
        if (this.lastWorldTime == -1L) {
            this.lastWorldTime = this.field_145850_b.func_82737_E();
        }
        if (this.entities.size() == 0) {
            return;
        }
        for (EntityPixelmon e : this.entities) {
            e.updateBreeding();
        }
        this.lastWorldTime = this.field_145850_b.func_82737_E();
    }

    private boolean entityExists(RanchPokemon poke) {
        for (EntityPixelmon p : this.entities) {
            if (!PixelmonMethods.isIDSame(p, poke.pokemonID)) continue;
            return true;
        }
        return false;
    }

    public void setInitBounds() {
        this.ranchBounds = new RanchBounds(this, this.field_145849_e + this.ranchWidth, this.field_145851_c - this.ranchLength, this.field_145849_e - this.ranchWidth, this.field_145851_c + this.ranchLength);
    }

    @Override
    public Bounds getBounds() {
        return this.ranchBounds;
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.ranchBounds.setWorldObj(world);
    }

    public boolean applyHourglass() {
        boolean hourglassused = false;
        for (EntityPixelmon e : this.entities) {
            if (!(e.breedingStrength > 0.0f) || e.getNumBreedingLevels() >= PixelmonConfig.numBreedingLevels) continue;
            hourglassused = true;
            e.setNumBreedingLevels(e.getNumBreedingLevels() + 1);
        }
        return hourglassused;
    }

    public class RanchPokemon {
        UUID ownerUUID;
        int[] pokemonID;

        public RanchPokemon(UUID ownerUUID, int[] pokemonID) {
            this.ownerUUID = ownerUUID;
            this.pokemonID = pokemonID;
        }
    }
}

