/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.ranch;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.blocks.ranch.TileEntityRanchBase;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ranch.RanchBlockClientPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PCServer;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldServer;

public class TileEntityRanchBlock
extends TileEntityRanchBase {
    private UUID ownerUUID = null;
    private String playerName = "";
    private NBTTagCompound egg = null;

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.egg != null) {
            nbt.func_74782_a("egg", (NBTBase)this.egg);
        }
        if (this.ownerUUID != null) {
            nbt.func_74772_a("UUIDMost", this.ownerUUID.getMostSignificantBits());
            nbt.func_74772_a("UUIDLeast", this.ownerUUID.getLeastSignificantBits());
        }
        if (!this.playerName.equals("")) {
            nbt.func_74778_a("playerName", this.playerName);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.egg = nbt.func_74764_b("egg") ? (NBTTagCompound)nbt.func_74781_a("egg") : null;
        if (nbt.func_74764_b("playerName")) {
            this.playerName = nbt.func_74779_i("playerName");
        }
        this.ownerUUID = nbt.func_150297_b("UUIDMost", 4) && nbt.func_150297_b("UUIDLeast", 4) ? new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")) : null;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public boolean hasEgg() {
        return this.egg != null;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    @Override
    public void onActivate(EntityPlayer player) {
        if (!enabled) {
            ChatHandler.sendChat((Entity)player, "pixelmon.general.disabledblock", new Object[0]);
            return;
        }
        this.updateStatus();
        PCServer.sendContentsToPlayer((EntityPlayerMP)player);
        RanchBlockClientPacket vrb = new RanchBlockClientPacket(this, RanchBlockClientPacket.PacketMode.ViewBlock);
        Pixelmon.network.sendTo((IMessage)vrb, (EntityPlayerMP)player);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.updateStatus();
    }

    @Override
    public void updateStatus() {
        super.updateStatus();
        for (EntityPixelmon p : this.entities) {
            if (this.hasBreedingPartner(p)) {
                EntityPixelmon q = this.getFirstBreedingPartner(p);
                if (q == null || this.egg != null || !p.readyToMakeEgg() || !q.readyToMakeEgg()) continue;
                EntityPixelmon pokemon = (EntityPixelmon)PixelmonEntityList.createEntityByName(p.getName(), p.field_70170_p);
                pokemon.makeEntityIntoEgg(p, q);
                this.egg = new NBTTagCompound();
                if (!p.originalTrainer.equals(q.originalTrainer) && pokemon.func_70681_au().nextFloat() < 2.0f / PixelmonConfig.shinyRate) {
                    pokemon.func_70096_w().func_75692_b(25, (Object)1);
                }
                pokemon.func_70109_d(this.egg);
                p.resetBreedingLevel();
                q.resetBreedingLevel();
                ((WorldServer)this.field_145850_b).func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                continue;
            }
            p.resetBreedingLevel();
        }
    }

    @Override
    public boolean hasBreedingPartner(EntityPixelmon pixelmon) {
        for (EntityPixelmon p : this.entities) {
            if (p == pixelmon || !EntityPixelmon.canBreed(pixelmon, p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EntityPixelmon getFirstBreedingPartner(EntityPixelmon pixelmon) {
        ArrayList<EntityPixelmon> possiblePartners = new ArrayList<EntityPixelmon>();
        for (EntityPixelmon p : this.entities) {
            if (p == pixelmon || !EntityPixelmon.canBreed(pixelmon, p)) continue;
            possiblePartners.add(p);
        }
        if (possiblePartners.size() == 1) {
            return (EntityPixelmon)((Object)possiblePartners.get(0));
        }
        if (possiblePartners.size() > 1) {
            EntityPixelmon highestPartner = (EntityPixelmon)((Object)possiblePartners.get(0));
            for (int i = 1; i < possiblePartners.size(); ++i) {
                if (((EntityPixelmon)((Object)possiblePartners.get(i))).getNumBreedingLevels() <= highestPartner.getNumBreedingLevels()) continue;
                highestPartner = (EntityPixelmon)((Object)possiblePartners.get(i));
            }
            return highestPartner;
        }
        return null;
    }

    public void setOwner(EntityPlayerMP entity) {
        this.ownerUUID = entity.func_110124_au();
        this.playerName = entity.getDisplayName();
    }

    @Override
    public void claimEgg(EntityPlayerMP player) {
        try {
            if (this.egg != null) {
                PixelmonStorage.PokeballManager.getPlayerStorageFromUUID(this.ownerUUID).addToParty((EntityPixelmon)PixelmonEntityList.createEntityFromNBT(this.egg, this.field_145850_b));
                this.egg = null;
                this.updateStatus();
                ((WorldServer)this.field_145850_b).func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getEntityCount() {
        if (this.entities != null) {
            return this.entities.size();
        }
        return 0;
    }

    public PixelmonData getPokemonEggData() {
        if (this.egg != null) {
            try {
                PlayerComputerStorage s = PixelmonStorage.ComputerManager.getPlayerStorageFromUUID(this.field_145850_b, this.ownerUUID);
                PixelmonData d = new PixelmonData(this.egg);
                return d;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    protected void checkAboveGround() {
        if (this.egg != null) {
            this.aboveGround = true;
            this.percentAbove = 100;
        } else {
            if (this.aboveGround && this.percentAbove < 100) {
                this.percentAbove += 5;
            } else if (!this.aboveGround && this.percentAbove > 0) {
                this.percentAbove -= 5;
            }
            if (this.tick <= 0) {
                List closePlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 5), (double)(this.field_145848_d - 5), (double)(this.field_145849_e - 5), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 5)));
                this.aboveGround = false;
                for (EntityPlayer player : closePlayers) {
                    if (!player.getDisplayName().equalsIgnoreCase(this.playerName)) continue;
                    this.aboveGround = true;
                }
                this.tick = 20;
            }
            --this.tick;
        }
    }

    @Override
    public void onDestroy() {
        if (!this.field_145850_b.field_72995_K) {
            try {
                if (this.egg != null) {
                    PlayerComputerStorage s = PixelmonStorage.ComputerManager.getPlayerStorageFromUUID(this.field_145850_b, this.ownerUUID);
                    s.addToComputer((EntityPixelmon)PixelmonEntityList.createEntityFromNBT(this.egg, this.field_145850_b));
                    PixelmonStorage.ComputerManager.savePlayer(s);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.onDestroy();
    }
}

