/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonUpdateData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.BossDropPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SelectPokemonListPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.StarterListPacket;
import io.netty.buffer.ByteBuf;

public class ServerStorageDisplay {
    public static StarterListPacket starterListPacket;
    public static SelectPokemonListPacket selectPokemonListPacket;
    public static BossDropPacket bossDrops;
    public static PixelmonData[] pokemon;

    public static void add(PixelmonData data) {
        ServerStorageDisplay.pokemon[data.order] = data;
    }

    public static int count() {
        int count = 0;
        for (int i = 0; i < pokemon.length; ++i) {
            if (pokemon[i] == null) continue;
            ++count;
        }
        return count;
    }

    public static int countNonEgg() {
        int count = 0;
        for (int i = 0; i < pokemon.length; ++i) {
            if (pokemon[i] == null || ServerStorageDisplay.pokemon[i].isEgg) continue;
            ++count;
        }
        return count;
    }

    public static void update(ByteBuf dataStream) {
        PixelmonData packet = new PixelmonData();
        packet.decodeInto(dataStream);
        ServerStorageDisplay.pokemon[packet.order] = packet;
    }

    public static void clear() {
        for (int i = 0; i < pokemon.length; ++i) {
            ServerStorageDisplay.pokemon[i] = null;
        }
    }

    public static boolean contains(int[] pokemonId) {
        for (int i = 0; i < pokemon.length; ++i) {
            if (pokemon[i] == null || !PixelmonMethods.isIDSame(ServerStorageDisplay.pokemon[i].pokemonID, pokemonId)) continue;
            return true;
        }
        return false;
    }

    public static PixelmonData get(int[] id) {
        for (PixelmonData p : pokemon) {
            if (p == null || !PixelmonMethods.isIDSame(p.pokemonID, id)) continue;
            return p;
        }
        return null;
    }

    public static void remove(int[] id) {
        for (int i = 0; i < pokemon.length; ++i) {
            if (pokemon[i] == null || !PixelmonMethods.isIDSame(ServerStorageDisplay.pokemon[i].pokemonID, id)) continue;
            ServerStorageDisplay.pokemon[i] = null;
        }
    }

    public static PixelmonData getNextFromPos(int pos) {
        if (++pos >= 6) {
            pos = 0;
        }
        while (pokemon[pos] == null) {
            if (++pos < 6) continue;
            pos = 0;
        }
        return pokemon[pos];
    }

    public static PixelmonData getPrevFromPos(int pos) {
        if (--pos < 0) {
            pos = 5;
        }
        while (pokemon[pos] == null) {
            if (--pos >= 0) continue;
            pos = 5;
        }
        return pokemon[pos];
    }

    public static void update(PixelmonUpdateData p) {
        for (int i = 0; i < pokemon.length; ++i) {
            if (pokemon[i] == null || !PixelmonMethods.isIDSame(ServerStorageDisplay.pokemon[i].pokemonID, p.pokemonID)) continue;
            pokemon[i].update(p);
        }
    }

    public static void changePokemon(int pos, PixelmonData pkt) {
        ServerStorageDisplay.pokemon[pos] = pkt;
    }

    public static boolean has(int[] id) {
        for (PixelmonData p : pokemon) {
            if (p == null || !PixelmonMethods.isIDSame(p.pokemonID, id)) continue;
            return true;
        }
        return false;
    }

    static {
        pokemon = new PixelmonData[6];
    }
}

