/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.overlay.GuiPlayerList;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;

public class SkinLoader
implements Runnable {
    private Mode mode;
    private final String username;

    public SkinLoader(String username, Mode mode) {
        this.mode = mode;
        this.username = username;
    }

    @Override
    public void run() {
        try {
            BufferedImage skinImage = ImageIO.read(new URL("http://skins.minecraft.net/MinecraftSkins/" + this.username + ".png"));
            if (this.mode == Mode.Head) {
                GuiPlayerList.addCachedHead(this.username, this.faceFromSkin(skinImage));
                GuiPlayerList.delFetching(this.username);
            } else {
                ClientProxy.storePlayerTexture(this.username, skinImage);
            }
        }
        catch (IOException ioException) {
            try {
                BufferedImage skinImage = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(AbstractClientPlayer.field_110314_b).func_110527_b());
                GuiPlayerList.addCachedHead(this.username, this.faceFromSkin(skinImage));
                GuiPlayerList.delFetching(this.username);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private BufferedImage faceFromSkin(BufferedImage skinImage) {
        BufferedImage merged = new BufferedImage(8, 8, 2);
        BufferedImage face = skinImage.getSubimage(8, 8, 8, 8);
        BufferedImage overlay = skinImage.getSubimage(40, 8, 8, 8);
        Graphics g = merged.getGraphics();
        g.drawImage(face, 0, 0, null);
        g.drawImage(overlay, 8, 8, null);
        return merged;
    }

    public static enum Mode {
        Head,
        Full;

    }
}

