/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    public static void drawImageQuad(double x, double y, double w, float h, double us, double vs, double ue, double ve, float zLevel) {
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a(x, y + (double)h, (double)zLevel, us, ve);
        var9.func_78374_a(x + w, y + (double)h, (double)zLevel, ue, ve);
        var9.func_78374_a(x + w, y, (double)zLevel, ue, vs);
        var9.func_78374_a(x, y, (double)zLevel, us, vs);
        var9.func_78381_a();
    }

    public static void bindPokemonSprite(PixelmonData pkt, Minecraft mc) {
        if (pkt.isEgg) {
            if (pkt.name.equalsIgnoreCase("Togepi")) {
                if (pkt.eggCycles > 10) {
                    mc.field_71446_o.func_110577_a(GuiResources.eggTogepi1);
                } else if (pkt.eggCycles > 5) {
                    mc.field_71446_o.func_110577_a(GuiResources.eggTogepi2);
                } else {
                    mc.field_71446_o.func_110577_a(GuiResources.eggTogepi3);
                }
            } else if (pkt.name.equalsIgnoreCase("Manaphy")) {
                if (pkt.eggCycles > 10) {
                    mc.field_71446_o.func_110577_a(GuiResources.eggManaphy1);
                } else if (pkt.eggCycles > 5) {
                    mc.field_71446_o.func_110577_a(GuiResources.eggManaphy2);
                } else {
                    mc.field_71446_o.func_110577_a(GuiResources.eggManaphy3);
                }
            } else if (pkt.eggCycles > 10) {
                mc.field_71446_o.func_110577_a(GuiResources.eggNormal1);
            } else if (pkt.eggCycles > 5) {
                mc.field_71446_o.func_110577_a(GuiResources.eggNormal2);
            } else {
                mc.field_71446_o.func_110577_a(GuiResources.eggNormal3);
            }
        } else {
            GuiHelper.bindPokemonSprite(pkt.getNationalPokedexNumber(), pkt.isShiny, mc);
        }
    }

    static void bindPokemonSprite(int npn, boolean isShiny, Minecraft mc) {
        String numString = "";
        numString = npn < 10 ? "00" + npn : (npn < 100 ? "0" + npn : "" + npn);
        if (isShiny) {
            mc.field_71446_o.func_110577_a(GuiResources.shinySprite(numString));
        } else {
            mc.field_71446_o.func_110577_a(GuiResources.sprite(numString));
        }
    }

    public static void renderTooltip(int x, int y, List<String> tooltipData, int color, int color2) {
        boolean lighting = GL11.glGetBoolean((int)2896);
        if (lighting) {
            RenderHelper.func_74518_a();
        }
        if (!tooltipData.isEmpty()) {
            int var7;
            int var6;
            int var5 = 0;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (var6 = 0; var6 < tooltipData.size(); ++var6) {
                var7 = fontRenderer.func_78256_a(tooltipData.get(var6));
                if (var7 <= var5) continue;
                var5 = var7;
            }
            var6 = x + 12;
            var7 = y - 12;
            int var9 = 8;
            if (tooltipData.size() > 1) {
                var9 += 2 + (tooltipData.size() - 1) * 10;
            }
            float z = 300.0f;
            GuiHelper.drawGradientRect(var6 - 3, var7 - 4, z, var6 + var5 + 3, var7 - 3, color2, color2);
            GuiHelper.drawGradientRect(var6 - 3, var7 + var9 + 3, z, var6 + var5 + 3, var7 + var9 + 4, color2, color2);
            GuiHelper.drawGradientRect(var6 - 3, var7 - 3, z, var6 + var5 + 3, var7 + var9 + 3, color2, color2);
            GuiHelper.drawGradientRect(var6 - 4, var7 - 3, z, var6 - 3, var7 + var9 + 3, color2, color2);
            GuiHelper.drawGradientRect(var6 + var5 + 3, var7 - 3, z, var6 + var5 + 4, var7 + var9 + 3, color2, color2);
            int var12 = (color & 0xFFFFFF) >> 1 | color & 0xFF000000;
            GuiHelper.drawGradientRect(var6 - 3, var7 - 3 + 1, z, var6 - 3 + 1, var7 + var9 + 3 - 1, color, var12);
            GuiHelper.drawGradientRect(var6 + var5 + 2, var7 - 3 + 1, z, var6 + var5 + 3, var7 + var9 + 3 - 1, color, var12);
            GuiHelper.drawGradientRect(var6 - 3, var7 - 3, z, var6 + var5 + 3, var7 - 3 + 1, color, color);
            GuiHelper.drawGradientRect(var6 - 3, var7 + var9 + 2, z, var6 + var5 + 3, var7 + var9 + 3, var12, var12);
            GL11.glDisable((int)2929);
            for (int var13 = 0; var13 < tooltipData.size(); ++var13) {
                String var14 = tooltipData.get(var13);
                fontRenderer.func_78261_a(var14, var6, var7, -1);
                if (var13 == 0) {
                    var7 += 2;
                }
                var7 += 10;
            }
            GL11.glEnable((int)2929);
        }
        if (!lighting) {
            RenderHelper.func_74518_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawGradientRect(int par1, int par2, float z, int par3, int par4, int par5, int par6) {
        float var7 = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(par5 & 0xFF) / 255.0f;
        float var11 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator var15 = Tessellator.field_78398_a;
        var15.func_78382_b();
        var15.func_78369_a(var8, var9, var10, var7);
        var15.func_78377_a((double)par3, (double)par2, (double)z);
        var15.func_78377_a((double)par1, (double)par2, (double)z);
        var15.func_78369_a(var12, var13, var14, var11);
        var15.func_78377_a((double)par1, (double)par4, (double)z);
        var15.func_78377_a((double)par3, (double)par4, (double)z);
        var15.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawEntity(int x, int y, float scale, float rotationYaw, float rotationPitch, EntityLivingBase entity) {
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)50.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(rotationPitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70761_aq = (float)Math.atan(rotationYaw / 40.0f) * 20.0f;
        entity.field_70177_z = (float)Math.atan(rotationYaw / 40.0f) * 40.0f;
        entity.field_70125_A = -((float)Math.atan(rotationPitch / 40.0f)) * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        GL11.glTranslatef((float)0.0f, (float)entity.field_70129_M, (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }
}

