/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiItemDrops;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.EntityTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiPixelmonOverlay
extends Gui {
    public static ResourceLocation available = new ResourceLocation("pixelmon:gui/overlay/available.png");
    public static ResourceLocation dock = new ResourceLocation("pixelmon:gui/overlay/dock.png");
    public static ResourceLocation fainted = new ResourceLocation("pixelmon:gui/overlay/fainted.png");
    public static ResourceLocation normal = new ResourceLocation("pixelmon:gui/overlay/normal.png");
    public static ResourceLocation released = new ResourceLocation("pixelmon:gui/overlay/released.png");
    public static ResourceLocation releasedSelected = new ResourceLocation("pixelmon:gui/overlay/selected-released.png");
    public static ResourceLocation selected = new ResourceLocation("pixelmon:gui/overlay/selected.png");
    public static ResourceLocation textbox = new ResourceLocation("pixelmon:gui/overlay/ui.png");
    public static ResourceLocation cherish = new ResourceLocation("pixelmon:gui/overlay/cherish.png");
    public static ResourceLocation dive = new ResourceLocation("pixelmon:gui/overlay/dive.png");
    public static ResourceLocation dusk = new ResourceLocation("pixelmon:gui/overlay/dusk.png");
    public static ResourceLocation fast = new ResourceLocation("pixelmon:gui/overlay/fast.png");
    public static ResourceLocation friend = new ResourceLocation("pixelmon:gui/overlay/friend.png");
    public static ResourceLocation great = new ResourceLocation("pixelmon:gui/overlay/great.png");
    public static ResourceLocation gs = new ResourceLocation("pixelmon:gui/overlay/gs.png");
    public static ResourceLocation heal = new ResourceLocation("pixelmon:gui/overlay/heal.png");
    public static ResourceLocation heavy = new ResourceLocation("pixelmon:gui/overlay/heavy.png");
    public static ResourceLocation level = new ResourceLocation("pixelmon:gui/overlay/level.png");
    public static ResourceLocation love = new ResourceLocation("pixelmon:gui/overlay/love.png");
    public static ResourceLocation lure = new ResourceLocation("pixelmon:gui/overlay/lure.png");
    public static ResourceLocation luxury = new ResourceLocation("pixelmon:gui/overlay/luxury.png");
    public static ResourceLocation master = new ResourceLocation("pixelmon:gui/overlay/master.png");
    public static ResourceLocation moon = new ResourceLocation("pixelmon:gui/overlay/moon.png");
    public static ResourceLocation nest = new ResourceLocation("pixelmon:gui/overlay/nest.png");
    public static ResourceLocation net = new ResourceLocation("pixelmon:gui/overlay/net.png");
    public static ResourceLocation park = new ResourceLocation("pixelmon:gui/overlay/park.png");
    public static ResourceLocation poke = new ResourceLocation("pixelmon:gui/overlay/poke.png");
    public static ResourceLocation premier = new ResourceLocation("pixelmon:gui/overlay/premier.png");
    public static ResourceLocation quick = new ResourceLocation("pixelmon:gui/overlay/quick.png");
    public static ResourceLocation repeat = new ResourceLocation("pixelmon:gui/overlay/repeat.png");
    public static ResourceLocation safari = new ResourceLocation("pixelmon:gui/overlay/safari.png");
    public static ResourceLocation sport = new ResourceLocation("pixelmon:gui/overlay/sport.png");
    public static ResourceLocation timer = new ResourceLocation("pixelmon:gui/overlay/timer.png");
    public static ResourceLocation ultra = new ResourceLocation("pixelmon:gui/overlay/ultra.png");
    public static ResourceLocation targetArea = new ResourceLocation("pixelmon:gui/overlay/targetArea.png");
    public static ResourceLocation targetBox = new ResourceLocation("pixelmon:gui/overlay/targetBox.png");
    public static ResourceLocation testButtonMain = new ResourceLocation("pixelmon:gui/button/GBB.png");
    public static ResourceLocation testButtonTLCorner = new ResourceLocation("pixelmon:gui/button/GBC-TL.png");
    public static ResourceLocation testButtonTRCorner = new ResourceLocation("pixelmon:gui/button/GBC-TR.png");
    public static ResourceLocation testButtonBLCorner = new ResourceLocation("pixelmon:gui/button/GBC-BL.png");
    public static ResourceLocation testButtonBRCorner = new ResourceLocation("pixelmon:gui/button/GBC-BR.png");
    public static boolean isGuiMinimized = false;
    public FontRenderer fontRenderer;
    public static int selectedPixelmon;
    public static boolean isVisible;
    private static int sideBarHeight;
    static int count;

    public GuiPixelmonOverlay() {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        ExternalMoveBase[] moves;
        if (count++ >= 100) {
            count = 0;
            this.checkEntitysInWorld((World)Minecraft.func_71410_x().field_71441_e);
        }
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r == null) {
            isVisible = true;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiInventory && event != null || !isVisible || Minecraft.func_71410_x().field_71474_y.field_74319_N || Minecraft.func_71410_x().field_71462_r instanceof GuiItemDrops) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution var5 = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        int var6 = var5.func_78326_a();
        int var7 = var5.func_78328_b();
        mc.field_71460_t.func_78478_c();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        int topSideBar = var7 / 2 - sideBarHeight / 2;
        int topOffset = topSideBar + 5;
        float slotHeight = 30.0f;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(dock);
        this.field_73735_i = -90.0f;
        GuiHelper.drawImageQuad(0.0, topSideBar, 22.0, 203.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        int leftText = 30;
        this.fontRenderer.func_78264_a(true);
        int i = 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiPixelmonOverlay.checkSelection();
        for (PixelmonData p : ServerStorageDisplay.pokemon) {
            int offset = 0;
            int yPos = topOffset + (int)((float)i * slotHeight) + 9 + offset;
            if (p != null) {
                String displayName;
                if (!isGuiMinimized) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(textbox);
                    GuiHelper.drawImageQuad(leftText - 28, yPos - 10, 123.0, 34.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                }
                if (!p.isEgg) {
                    displayName = EntityPixelmon.getLocalizedName(p.name);
                    if (!p.nickname.equals("")) {
                        displayName = p.nickname;
                    }
                } else {
                    displayName = EntityPixelmon.getLocalizedName("Egg");
                }
                i = p.order;
                if (!isGuiMinimized) {
                    this.fontRenderer.func_78276_b(displayName, leftText, yPos, 0xFFFFFF);
                    if (p.gender == Gender.Male && !p.isEgg) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.male);
                        GuiHelper.drawImageQuad(this.fontRenderer.func_78256_a(displayName) + leftText + 3, yPos, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    } else if (p.gender == Gender.Female && !p.isEgg) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.female);
                        GuiHelper.drawImageQuad(this.fontRenderer.func_78256_a(displayName) + leftText + 3, yPos, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    }
                }
                this.bindPokeballTexture(p.pokeball);
                GuiHelper.drawImageQuad(-3.0, yPos - 7, 32.0, 32.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                if (p.outside && i == selectedPixelmon) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(releasedSelected);
                } else if (p.isFainted) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(fainted);
                } else if (p.outside) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(released);
                } else if (i == selectedPixelmon) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(selected);
                } else {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(normal);
                }
                GuiHelper.drawImageQuad(-3.0, yPos - 7, 32.0, 32.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                GuiHelper.bindPokemonSprite(p, mc);
                GuiHelper.drawImageQuad(1.0, yPos - 6, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                if (p.heldItem != null) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.heldItem);
                    GuiHelper.drawImageQuad(18.0, yPos + 13, 6.0, 6.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                }
                if (!isGuiMinimized && !p.isEgg) {
                    this.fontRenderer.func_78276_b("Lvl " + p.lvl, leftText - 2, yPos + 1 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                    if (p.health <= 0) {
                        this.fontRenderer.func_78276_b("Fainted", leftText + 1 + this.fontRenderer.func_78256_a("Lvl " + p.lvl), yPos + 1 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                    } else {
                        this.fontRenderer.func_78276_b("HP " + p.health + "/" + p.hp, leftText + 4 + this.fontRenderer.func_78256_a("Lvl " + p.lvl), yPos + 1 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                    }
                }
            } else {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(available);
                GuiHelper.drawImageQuad(5.0, yPos + 1, 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            ++i;
        }
        if (PixelmonConfig.showTarget && ServerStorageDisplay.pokemon[selectedPixelmon] != null && ServerStorageDisplay.pokemon[GuiPixelmonOverlay.selectedPixelmon].outside) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(targetArea);
            GuiHelper.drawImageQuad(event.resolution.func_78326_a() - 76, 0.0, 32.0, 32.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            this.fontRenderer.func_78276_b(GameSettings.func_74298_c((int)ClientProxy.actionKeyBind.func_151463_i()), event.resolution.func_78326_a() - 53, 20, 0xFFFFFF);
            if (ServerStorageDisplay.pokemon[GuiPixelmonOverlay.selectedPixelmon].targetId != -1) {
                EntityLivingBase entity = (EntityLivingBase)Minecraft.func_71410_x().field_71441_e.func_73045_a(ServerStorageDisplay.pokemon[GuiPixelmonOverlay.selectedPixelmon].targetId);
                if (entity instanceof EntityPixelmon) {
                    int npn = ((EntityPixelmon)entity).baseStats.nationalPokedexNumber;
                    boolean isShiny = ((EntityPixelmon)entity).getIsShiny();
                    GuiHelper.bindPokemonSprite(npn, isShiny, mc);
                    GuiHelper.drawImageQuad(event.resolution.func_78326_a() - 72, 0.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                } else if (entity instanceof EntityPlayer) {
                    if (((AbstractClientPlayer)entity).func_110306_p() == null) {
                        AbstractClientPlayer cfr_ignored_0 = (AbstractClientPlayer)entity;
                        RenderManager.field_78727_a.field_78724_e.func_110577_a(AbstractClientPlayer.field_110314_b);
                    } else {
                        RenderManager.field_78727_a.field_78724_e.func_110577_a(((AbstractClientPlayer)entity).func_110306_p());
                    }
                    GuiHelper.drawImageQuad(event.resolution.func_78326_a() - 67, 9.0, 14.0, 14.0f, 0.11f, 0.26f, 0.26f, 0.49f, this.field_73735_i);
                } else if (entity instanceof EntityTrainer) {
                    RenderManager.field_78727_a.field_78724_e.func_110577_a(AbstractClientPlayer.field_110314_b);
                    GuiHelper.drawImageQuad(event.resolution.func_78326_a() - 67, 9.0, 14.0, 14.0f, 0.11f, 0.26f, 0.26f, 0.49f, this.field_73735_i);
                }
            }
        }
        if (ServerStorageDisplay.pokemon[selectedPixelmon] != null && ServerStorageDisplay.pokemon[GuiPixelmonOverlay.selectedPixelmon].outside && PixelmonConfig.allowExternalMoves && (moves = ServerStorageDisplay.pokemon[selectedPixelmon].getExternalMoves()) != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(targetArea);
            GuiHelper.drawImageQuad(event.resolution.func_78326_a() - 42, 0.0, 32.0, 32.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            this.fontRenderer.func_78276_b(GameSettings.func_74298_c((int)ClientProxy.externalKeyBind.func_151463_i()), event.resolution.func_78326_a() - 19, 20, 0xFFFFFF);
        }
        this.fontRenderer.func_78264_a(false);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }

    private void renderButton(int x, int y, int w, int h) {
        int cornerW = 6;
        int cornerH = 6;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(testButtonTLCorner);
        GuiHelper.drawImageQuad(x, y, cornerW, cornerH, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(testButtonTRCorner);
        GuiHelper.drawImageQuad(x + w - cornerW, y, cornerW, cornerH, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(testButtonBLCorner);
        GuiHelper.drawImageQuad(x, y + h - cornerH, cornerW, cornerH, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(testButtonBRCorner);
        GuiHelper.drawImageQuad(x + w - cornerW, y + h - cornerH, cornerW, cornerH, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(testButtonMain);
        GuiHelper.drawImageQuad(x + cornerW, y, w - cornerW * 2, h, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        GuiHelper.drawImageQuad(x, y + cornerH, w, h - cornerH * 2, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
    }

    private void bindOverlayTexture() {
        if (isGuiMinimized) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.overlaySimple);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.overlayExtended);
        }
    }

    public boolean checkEntitysInWorld(World world) {
        for (PixelmonData p : ServerStorageDisplay.pokemon) {
            if (p == null) continue;
            p.outside = false;
        }
        List EntityList = world.field_72996_f;
        for (int i = 0; i < EntityList.size(); ++i) {
            int[] existingId;
            Entity e = (Entity)EntityList.get(i);
            if (!(e instanceof EntityPixelmon) || (existingId = ((EntityPixelmon)e).getPokemonId())[0] == -1) continue;
            for (PixelmonData p : ServerStorageDisplay.pokemon) {
                if (p == null || !PixelmonMethods.isIDSame((EntityPixelmon)e, p.pokemonID)) continue;
                p.outside = true;
            }
        }
        return false;
    }

    public static void selectNextPixelmon() {
        if (ServerStorageDisplay.count() == 0 || ServerStorageDisplay.countNonEgg() == 0) {
            return;
        }
        if (++selectedPixelmon >= 6) {
            selectedPixelmon = 0;
        }
        while (ServerStorageDisplay.pokemon[selectedPixelmon] == null || ServerStorageDisplay.pokemon[GuiPixelmonOverlay.selectedPixelmon].isEgg) {
            if (++selectedPixelmon < 6) continue;
            selectedPixelmon = 0;
        }
    }

    public static void selectPreviousPixelmon() {
        if (ServerStorageDisplay.count() == 0 || ServerStorageDisplay.countNonEgg() == 0) {
            return;
        }
        if (--selectedPixelmon < 0) {
            selectedPixelmon = 5;
        }
        while (ServerStorageDisplay.pokemon[selectedPixelmon] == null || ServerStorageDisplay.pokemon[GuiPixelmonOverlay.selectedPixelmon].isEgg) {
            if (--selectedPixelmon >= 0) continue;
            selectedPixelmon = 5;
        }
    }

    public static void checkSelection() {
        if (ServerStorageDisplay.pokemon[selectedPixelmon] == null || ServerStorageDisplay.pokemon[GuiPixelmonOverlay.selectedPixelmon].isEgg) {
            GuiPixelmonOverlay.selectPreviousPixelmon();
        }
    }

    private void bindPokeballTexture(EnumPokeballs ball) {
        ResourceLocation tex = null;
        switch (ball) {
            case DiveBall: {
                tex = dive;
                break;
            }
            case FastBall: {
                tex = fast;
                break;
            }
            case DuskBall: {
                tex = dusk;
                break;
            }
            case FriendBall: {
                tex = friend;
                break;
            }
            case GreatBall: {
                tex = great;
                break;
            }
            case HealBall: {
                tex = heal;
                break;
            }
            case HeavyBall: {
                tex = heavy;
                break;
            }
            case LevelBall: {
                tex = level;
                break;
            }
            case LoveBall: {
                tex = love;
                break;
            }
            case LuxuryBall: {
                tex = luxury;
                break;
            }
            case MasterBall: {
                tex = master;
                break;
            }
            case MoonBall: {
                tex = moon;
                break;
            }
            case NestBall: {
                tex = nest;
                break;
            }
            case NetBall: {
                tex = net;
                break;
            }
            case PokeBall: {
                tex = poke;
                break;
            }
            case PremierBall: {
                tex = premier;
                break;
            }
            case RepeatBall: {
                tex = repeat;
                break;
            }
            case SafariBall: {
                tex = safari;
                break;
            }
            case TimerBall: {
                tex = timer;
                break;
            }
            case UltraBall: {
                tex = ultra;
                break;
            }
            case CherishBall: {
                tex = cherish;
                break;
            }
            case GSBall: {
                tex = gs;
                break;
            }
            case LureBall: {
                tex = lure;
                break;
            }
            case ParkBall: {
                tex = park;
                break;
            }
            case QuickBall: {
                tex = quick;
                break;
            }
            case SportBall: {
                tex = sport;
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(tex);
    }

    static {
        isVisible = true;
        sideBarHeight = 200;
        count = 100;
    }
}

