/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiItemDrops;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.EntityTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class NewGuiPixelmonOverlay
extends Gui {
    public static ResourceLocation base = new ResourceLocation("pixelmon:gui/overlay/Base.png");
    public static ResourceLocation base2 = new ResourceLocation("pixelmon:gui/overlay/Base2.png");
    public static ResourceLocation empty = new ResourceLocation("pixelmon:gui/overlay/Empty.png");
    public static ResourceLocation fainted = new ResourceLocation("pixelmon:gui/overlay/Fainted.png");
    public static ResourceLocation released = new ResourceLocation("pixelmon:gui/overlay/Released.png");
    public static ResourceLocation releasedSelected = new ResourceLocation("pixelmon:gui/overlay/ReleasedSelected.png");
    public static ResourceLocation regular = new ResourceLocation("pixelmon:gui/overlay/Regular.png");
    public static ResourceLocation selected = new ResourceLocation("pixelmon:gui/overlay/Selected.png");
    public static ResourceLocation targetArea = new ResourceLocation("pixelmon:gui/overlay/targetArea.png");
    public static ResourceLocation targetBox = new ResourceLocation("pixelmon:gui/overlay/targetBox.png");
    public static ResourceLocation testButtonMain = new ResourceLocation("pixelmon:gui/button/GBB.png");
    public static ResourceLocation testButtonTLCorner = new ResourceLocation("pixelmon:gui/button/GBC-TL.png");
    public static ResourceLocation testButtonTRCorner = new ResourceLocation("pixelmon:gui/button/GBC-TR.png");
    public static ResourceLocation testButtonBLCorner = new ResourceLocation("pixelmon:gui/button/GBC-BL.png");
    public static ResourceLocation testButtonBRCorner = new ResourceLocation("pixelmon:gui/button/GBC-BR.png");
    public static boolean isGuiMinimized = false;
    public FontRenderer fontRenderer;
    public static int selectedPixelmon;
    public static boolean isVisible;
    private static int sideBarHeight;
    static int count;

    public NewGuiPixelmonOverlay() {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (count++ >= 100) {
            count = 0;
            this.checkEntitysInWorld((World)Minecraft.func_71410_x().field_71441_e);
        }
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r == null) {
            isVisible = true;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiInventory && event != null || !isVisible || Minecraft.func_71410_x().field_71474_y.field_74319_N || Minecraft.func_71410_x().field_71462_r instanceof GuiItemDrops) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution var5 = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        int var6 = var5.func_78326_a();
        int var7 = var5.func_78328_b();
        mc.field_71460_t.func_78478_c();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        int topSideBar = var7 / 2 - sideBarHeight / 2;
        int topOffset = topSideBar + 5;
        float slotHeight = 30.0f;
        this.field_73735_i = -90.0f;
        int leftText = 30;
        this.fontRenderer.func_78264_a(true);
        int i = 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        NewGuiPixelmonOverlay.checkSelection();
        for (PixelmonData p : ServerStorageDisplay.pokemon) {
            int offset = 0;
            int yPos = topOffset + (int)((float)i * slotHeight) + 9 + offset;
            if (p != null) {
                String displayName;
                if (!isGuiMinimized) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(base2);
                    GuiHelper.drawImageQuad(leftText - 5, yPos - 3, 64.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                }
                if (!p.isEgg) {
                    displayName = EntityPixelmon.getLocalizedName(p.name);
                    if (!p.nickname.equals("")) {
                        displayName = p.nickname;
                    }
                } else {
                    displayName = EntityPixelmon.getLocalizedName("Egg");
                }
                i = p.order;
                if (!isGuiMinimized) {
                    this.fontRenderer.func_78276_b(displayName, leftText, yPos - 2, 0xFFFFFF);
                    if (p.gender == Gender.Male && !p.isEgg) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.male);
                        GuiHelper.drawImageQuad(this.fontRenderer.func_78256_a(displayName) + leftText + 3, yPos - 1, 3.0, 5.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    } else if (p.gender == Gender.Female && !p.isEgg) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.female);
                        GuiHelper.drawImageQuad(this.fontRenderer.func_78256_a(displayName) + leftText + 3, yPos - 1, 3.0, 5.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    }
                }
                this.drawHealthBar(30, yPos + 7, 60, 8, p);
                this.drawExpBar(27, yPos + 16, 63, 4, p);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(base);
                GuiHelper.drawImageQuad(leftText - 28, yPos - 5, 29.0, 29.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                if (p.outside && i == selectedPixelmon) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(releasedSelected);
                } else if (p.isFainted) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(fainted);
                } else if (p.outside) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(released);
                } else if (i == selectedPixelmon) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(selected);
                } else {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(regular);
                }
                GuiHelper.drawImageQuad(2.0, yPos - 5, 29.0, 29.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                GuiHelper.bindPokemonSprite(p, mc);
                GuiHelper.drawImageQuad(4.0, yPos - 5, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                if (p.heldItem != null) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.heldItem);
                    GuiHelper.drawImageQuad(18.0, yPos + 13, 6.0, 6.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                }
                if (!isGuiMinimized && !p.isEgg) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                    this.fontRenderer.func_78276_b("Lvl " + p.lvl, leftText + 10, yPos + 18 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                    GL11.glPopMatrix();
                    if (p.health <= 0) {
                        this.fontRenderer.func_78276_b("Fainted", leftText + 1, yPos + 1 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                    } else {
                        this.fontRenderer.func_78276_b(p.health + "/" + p.hp + " hp", leftText + 4, yPos - 2 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                    }
                }
            } else {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(empty);
                GuiHelper.drawImageQuad(5.0, yPos + 1, 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            ++i;
        }
        if (PixelmonConfig.showTarget && ServerStorageDisplay.pokemon[selectedPixelmon] != null && ServerStorageDisplay.pokemon[NewGuiPixelmonOverlay.selectedPixelmon].outside) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(targetArea);
            GuiHelper.drawImageQuad(event.resolution.func_78326_a() - 42, 0.0, 32.0, 32.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            this.fontRenderer.func_78276_b(GameSettings.func_74298_c((int)ClientProxy.actionKeyBind.func_151463_i()), event.resolution.func_78326_a() - 19, 20, 0xFFFFFF);
            if (ServerStorageDisplay.pokemon[NewGuiPixelmonOverlay.selectedPixelmon].targetId != -1) {
                EntityLivingBase entity = (EntityLivingBase)Minecraft.func_71410_x().field_71441_e.func_73045_a(ServerStorageDisplay.pokemon[NewGuiPixelmonOverlay.selectedPixelmon].targetId);
                if (entity instanceof EntityPixelmon) {
                    int npn = ((EntityPixelmon)entity).baseStats.nationalPokedexNumber;
                    boolean isShiny = ((EntityPixelmon)entity).getIsShiny();
                    GuiHelper.bindPokemonSprite(npn, isShiny, mc);
                    GuiHelper.drawImageQuad(event.resolution.func_78326_a() - 38, 0.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                } else if (entity instanceof EntityPlayer) {
                    if (((AbstractClientPlayer)entity).func_110306_p() == null) {
                        AbstractClientPlayer cfr_ignored_0 = (AbstractClientPlayer)entity;
                        RenderManager.field_78727_a.field_78724_e.func_110577_a(AbstractClientPlayer.field_110314_b);
                    } else {
                        RenderManager.field_78727_a.field_78724_e.func_110577_a(((AbstractClientPlayer)entity).func_110306_p());
                    }
                    GuiHelper.drawImageQuad(event.resolution.func_78326_a() - 33, 9.0, 14.0, 14.0f, 0.11f, 0.26f, 0.26f, 0.49f, this.field_73735_i);
                } else if (entity instanceof EntityTrainer) {
                    RenderManager.field_78727_a.field_78724_e.func_110577_a(AbstractClientPlayer.field_110314_b);
                    GuiHelper.drawImageQuad(event.resolution.func_78326_a() - 33, 9.0, 14.0, 14.0f, 0.11f, 0.26f, 0.26f, 0.49f, this.field_73735_i);
                }
            }
        }
        this.fontRenderer.func_78264_a(false);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }

    protected void drawExpBar(int x, int y, int width, int height, PixelmonData p) {
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        int barWidth = (int)((float)p.xp / (float)p.nextLvlXP * ((float)width - 6.0f));
        tessellator.func_78369_a(0.18431373f, 0.5019608f, 0.7254902f, 1.0f);
        tessellator.func_78377_a((double)x, (double)y, (double)this.field_73735_i);
        tessellator.func_78377_a((double)x, (double)(y + height), (double)this.field_73735_i);
        tessellator.func_78377_a((double)(x + width - 6), (double)(y + height), (double)this.field_73735_i);
        tessellator.func_78377_a((double)(x + width - 6), (double)y, (double)this.field_73735_i);
        tessellator.func_78369_a(0.27450982f, 0.67058825f, 0.8901961f, 1.0f);
        tessellator.func_78377_a((double)x, (double)y, (double)this.field_73735_i);
        tessellator.func_78377_a((double)x, (double)(y + height), (double)this.field_73735_i);
        tessellator.func_78377_a((double)(x + barWidth), (double)(y + height), (double)this.field_73735_i);
        tessellator.func_78377_a((double)(x + barWidth), (double)y, (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2903);
    }

    public void drawHealthBar(int x, int y, int width, int height, PixelmonData p) {
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        int barWidth = width - 6;
        if (p.health <= p.hp / 5) {
            tessellator.func_78369_a(0.7019608f, 0.1254902f, 0.14509805f, 1.0f);
        } else if (p.health <= p.hp / 2) {
            tessellator.func_78369_a(0.83137256f, 0.41568628f, 0.15294118f, 1.0f);
        } else {
            tessellator.func_78369_a(0.28627452f, 0.5764706f, 0.2784314f, 1.0f);
        }
        tessellator.func_78377_a((double)x, (double)y, (double)this.field_73735_i);
        tessellator.func_78377_a((double)x, (double)(y + height), (double)this.field_73735_i);
        tessellator.func_78377_a((double)(x + barWidth), (double)(y + height), (double)this.field_73735_i);
        tessellator.func_78377_a((double)(x + barWidth), (double)y, (double)this.field_73735_i);
        float Percent = (float)p.health / (float)p.hp;
        float CurWidth = Percent * (float)barWidth;
        if (p.health <= p.hp / 5) {
            tessellator.func_78369_a(0.9372549f, 0.21960784f, 0.18431373f, 1.0f);
        } else if (p.health <= p.hp / 2) {
            tessellator.func_78369_a(0.9843137f, 0.6627451f, 0.09803922f, 1.0f);
        } else {
            tessellator.func_78369_a(0.3647059f, 0.7137255f, 0.29411766f, 1.0f);
        }
        tessellator.func_78377_a((double)x, (double)y, (double)this.field_73735_i);
        tessellator.func_78377_a((double)x, (double)(y + height), (double)this.field_73735_i);
        tessellator.func_78377_a((double)((float)x + CurWidth), (double)(y + height), (double)this.field_73735_i);
        tessellator.func_78377_a((double)((float)x + CurWidth), (double)y, (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2903);
    }

    private void renderButton(int x, int y, int w, int h) {
        int cornerW = 6;
        int cornerH = 6;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(testButtonTLCorner);
        GuiHelper.drawImageQuad(x, y, cornerW, cornerH, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(testButtonTRCorner);
        GuiHelper.drawImageQuad(x + w - cornerW, y, cornerW, cornerH, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(testButtonBLCorner);
        GuiHelper.drawImageQuad(x, y + h - cornerH, cornerW, cornerH, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(testButtonBRCorner);
        GuiHelper.drawImageQuad(x + w - cornerW, y + h - cornerH, cornerW, cornerH, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(testButtonMain);
        GuiHelper.drawImageQuad(x + cornerW, y, w - cornerW * 2, h, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        GuiHelper.drawImageQuad(x, y + cornerH, w, h - cornerH * 2, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
    }

    private void bindOverlayTexture() {
        if (isGuiMinimized) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.overlaySimple);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.overlayExtended);
        }
    }

    public boolean checkEntitysInWorld(World world) {
        for (PixelmonData p : ServerStorageDisplay.pokemon) {
            if (p == null) continue;
            p.outside = false;
        }
        List EntityList = world.field_72996_f;
        for (int i = 0; i < EntityList.size(); ++i) {
            int[] existingId;
            Entity e = (Entity)EntityList.get(i);
            if (!(e instanceof EntityPixelmon) || (existingId = ((EntityPixelmon)e).getPokemonId())[0] == -1) continue;
            for (PixelmonData p : ServerStorageDisplay.pokemon) {
                if (p == null || !PixelmonMethods.isIDSame((EntityPixelmon)e, p.pokemonID)) continue;
                p.outside = true;
            }
        }
        return false;
    }

    public static void selectNextPixelmon() {
        if (ServerStorageDisplay.count() == 0 || ServerStorageDisplay.countNonEgg() == 0) {
            return;
        }
        if (++selectedPixelmon >= 6) {
            selectedPixelmon = 0;
        }
        while (ServerStorageDisplay.pokemon[selectedPixelmon] == null || ServerStorageDisplay.pokemon[NewGuiPixelmonOverlay.selectedPixelmon].isEgg) {
            if (++selectedPixelmon < 6) continue;
            selectedPixelmon = 0;
        }
    }

    public static void selectPreviousPixelmon() {
        if (ServerStorageDisplay.count() == 0 || ServerStorageDisplay.countNonEgg() == 0) {
            return;
        }
        if (--selectedPixelmon < 0) {
            selectedPixelmon = 5;
        }
        while (ServerStorageDisplay.pokemon[selectedPixelmon] == null || ServerStorageDisplay.pokemon[NewGuiPixelmonOverlay.selectedPixelmon].isEgg) {
            if (--selectedPixelmon >= 0) continue;
            selectedPixelmon = 5;
        }
    }

    public static void checkSelection() {
        if (ServerStorageDisplay.pokemon[selectedPixelmon] == null || ServerStorageDisplay.pokemon[NewGuiPixelmonOverlay.selectedPixelmon].isEgg) {
            NewGuiPixelmonOverlay.selectPreviousPixelmon();
        }
    }

    static {
        isVisible = true;
        sideBarHeight = 200;
        count = 100;
    }
}

