/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.IBattleMessage;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.battles.AttackData;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleMode;
import com.pixelmonmod.pixelmon.client.gui.battles.EvoInfo;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUp;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.BagSection;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.items.ItemData;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;

public class ClientBattleManager {
    public boolean mustUseLastMove = false;
    public boolean inBattle = false;
    public int battleControllerIndex = -1;
    public BattleMode mode;
    public BagSection bagSection;
    public boolean battleEnded = true;
    private ArrayList<String> messageList = new ArrayList();
    public int[][] teamPokemon;
    public ArrayList<ItemData> bagStore = new ArrayList();
    public ArrayList<LevelUp> levelUpList = new ArrayList();
    public ArrayList<AttackData> newAttackList = new ArrayList();
    public boolean goBackToMainMenu;
    public int startIndex = 0;
    public ItemData itemToUse = null;
    public IMessage sendPacket;
    public BattleMode oldMode;
    public BattleMode yesNoOrgin;
    public List<EvoInfo> evolveList = new ArrayList<EvoInfo>();
    public boolean isHealing = false;
    public int healAmount = 0;
    public PixelmonData pixelmonToHeal = null;
    public int selectedAttack = -1;
    public Attack[] attacks = new Attack[4];
    public int currentPokemon = -1;
    public boolean[][] targetted;
    public PixelmonData[] otherTeamData;
    public boolean isTM = false;
    public boolean canSwitch = true;
    public PixelmonData[] opponents;
    public ParticipantType[][] battleSetup;
    public boolean healFinished = false;
    public ArrayList<int[]> pokemonToChoose;

    public void addMessage(String s) {
        this.messageList.add(s);
    }

    public String getNextMessage() {
        return this.messageList.get(0);
    }

    public void removeMessage() {
        this.messageList.remove(0);
    }

    public boolean hasMoreMessages() {
        return this.messageList.size() > 0;
    }

    public PixelmonData getUserPokemonPacket() {
        if (this.currentPokemon != -1) {
            return ServerStorageDisplay.get(this.teamPokemon[this.currentPokemon]);
        }
        return null;
    }

    public EntityPixelmon getUserPokemon() {
        if (this.currentPokemon != -1) {
            for (Object e : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
                if (!(e instanceof EntityPixelmon) || !PixelmonMethods.isIDSame((EntityPixelmon)((Object)e), this.teamPokemon[this.currentPokemon])) continue;
                return (EntityPixelmon)((Object)e);
            }
        }
        return null;
    }

    public void clearMessages() {
        this.messageList.clear();
    }

    public boolean hasLevelUps() {
        return this.levelUpList.size() > 0;
    }

    public boolean hasNewAttacks() {
        return this.newAttackList.size() > 0;
    }

    public void setMustUseLastMove() {
        this.mustUseLastMove = true;
    }

    public void StartBattle(int battleControllerIndex, ParticipantType[][] battleSetup) {
        this.battleControllerIndex = battleControllerIndex;
        this.battleSetup = battleSetup;
        this.targetted = new boolean[2][];
        this.mode = BattleMode.Waiting;
        this.clearMessages();
        this.canSwitch = true;
        this.battleEnded = false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.inBattle) {
            this.tick();
        }
    }

    private void tick() {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiBattle)) {
            Minecraft.func_71410_x().field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.Battle.ordinal(), (World)Minecraft.func_71410_x().field_71441_e, 0, 0, 0);
        }
    }

    public void restoreSettingsAndClose() {
        this.battleEnded = true;
    }

    public boolean canCatchOpponent() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t != ParticipantType.WildPokemon || this.opponents[i].bossMode != EnumBossMode.NotBoss) continue;
            return true;
        }
        return false;
    }

    public boolean canRunFromBattle() {
        if (this.opponents.length > 1) {
            return false;
        }
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t == ParticipantType.WildPokemon && this.opponents[i].bossMode == EnumBossMode.NotBoss) continue;
            return false;
        }
        return true;
    }

    public void startPicking(boolean canSwitch, ArrayList<int[]> pokemonToChoose) {
        this.canSwitch = canSwitch;
        this.oldMode = BattleMode.MainMenu;
        this.mode = BattleMode.MainMenu;
        this.pokemonToChoose = pokemonToChoose;
        for (int i = 0; i < this.teamPokemon.length; ++i) {
            int[] id = this.teamPokemon[i];
            if (!ServerStorageDisplay.has(id) || !this.hasTurn(id)) continue;
            this.currentPokemon = i;
            break;
        }
    }

    private boolean hasTurn(int[] id) {
        for (int[] pid : this.pokemonToChoose) {
            if (!PixelmonMethods.isIDSame(pid, id)) continue;
            return true;
        }
        return false;
    }

    public void selectedMove() {
        if (this.teamPokemon.length > this.currentPokemon + 1) {
            for (int i = this.currentPokemon + 1; i < this.teamPokemon.length; ++i) {
                int[] id = this.teamPokemon[i];
                if (ServerStorageDisplay.has(id)) {
                    if (!this.hasTurn(id)) continue;
                    this.currentPokemon = i;
                    break;
                }
                this.mode = BattleMode.Waiting;
                return;
            }
            this.mode = BattleMode.MainMenu;
        } else {
            this.mode = BattleMode.Waiting;
        }
    }

    public void setTeamPokemon(int[][] pokemon) {
        this.teamPokemon = pokemon;
        this.targetted[0] = new boolean[pokemon.length];
    }

    public void setOpponents(PixelmonData[] data) {
        this.opponents = data;
        this.targetted[1] = new boolean[this.opponents.length];
    }

    public void setTeamData(PixelmonData[] data) {
        this.otherTeamData = data;
    }

    public PixelmonData getUncontrolledTeamPokemon(int[] id) {
        for (PixelmonData data : this.otherTeamData) {
            if (!PixelmonMethods.isIDSame(id, data.pokemonID)) continue;
            return data;
        }
        return null;
    }

    public void addBattleMessage(IBattleMessage message) {
    }

    public void setCameraPos(double x, double y, double z) {
        GuiBattle.setCameraToPos(x, y, z);
    }
}

