/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.TargettingInfo;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.camera.CMSmartPos;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetEntity;
import com.pixelmonmod.pixelmon.client.camera.GuiChattableCamera;
import com.pixelmonmod.pixelmon.client.camera.ICameraTarget;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiPixelmonOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleMode;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ApplyToPokemon;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ChooseAttackScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ChooseBag;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ChoosePokemon;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ChooseTargets;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.EnforcedSwitch;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.LevelUpScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.MainMenu;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ReplaceAttack;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.UseBag;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.YesNoDialog;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.Overlay1v1;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.Overlay2v2;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OverlayBase;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleGuiClosed;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiBattle
extends GuiChattableCamera {
    private int guiWidth = 300;
    private int guiHeight = 60;
    ClientBattleManager bm;
    ArrayList<BattleScreen> screenList = new ArrayList();
    BattleScreen currentScreen = null;
    public OverlayBase pokemonOverlay = null;
    boolean first = true;
    int flashCount = 0;
    public int mouseOverButton = 0;

    public GuiBattle() {
        GuiPixelmonOverlay.isVisible = false;
        this.bm = ClientProxy.battleManager;
        this.screenList.add(new ApplyToPokemon(this));
        this.screenList.add(new ChooseAttackScreen(this));
        this.screenList.add(new ChooseBag(this));
        this.screenList.add(new ChoosePokemon(this));
        this.screenList.add(new ChooseTargets(this));
        this.screenList.add(new EnforcedSwitch(this));
        this.screenList.add(new LevelUpScreen(this));
        this.screenList.add(new MainMenu(this));
        this.screenList.add(new ReplaceAttack(this));
        this.screenList.add(new UseBag(this));
        this.screenList.add(new YesNoDialog(this));
        if (this.bm.teamPokemon != null) {
            if (this.bm.teamPokemon.length == 1 && this.bm.opponents.length == 1) {
                this.pokemonOverlay = new Overlay1v1(this);
            }
            if (this.bm.teamPokemon.length == 2 && this.bm.opponents.length == 2) {
                this.pokemonOverlay = new Overlay2v2(this);
            }
        }
    }

    public void restoreSettingsAndClose() {
        this.bm.restoreSettingsAndClose();
        this.field_146297_k.field_71439_g.func_71053_j();
        GuiPixelmonOverlay.isVisible = true;
        if (ServerStorageDisplay.bossDrops != null) {
            Minecraft.func_71410_x().field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.ItemDrops.getIndex().intValue(), (World)Minecraft.func_71410_x().field_71441_e, 0, 0, 0);
        } else if (this.bm.evolveList.size() > 0) {
            Minecraft.func_71410_x().field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.Evolution.getIndex().intValue(), (World)Minecraft.func_71410_x().field_71441_e, 0, 0, 0);
        } else {
            Pixelmon.network.sendToServer((IMessage)new BattleGuiClosed());
        }
    }

    private void selectScreen() {
        for (BattleScreen bs : this.screenList) {
            if (!bs.isScreen()) continue;
            this.currentScreen = bs;
        }
    }

    private void drawPokemonOverlays() {
        if (this.pokemonOverlay != null) {
            this.pokemonOverlay.draw(this.field_146294_l, this.field_146295_m, this.guiWidth, this.guiHeight);
        }
    }

    private void drawMessageScreen() {
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.battleGui3);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - this.getGuiWidth() / 2, this.field_146295_m - this.guiHeight, this.getGuiWidth(), this.guiHeight, 0.0, 0.0, 1.0, 0.30416667461395264, this.field_73735_i);
        if (this.bm.mode != BattleMode.Waiting || this.bm.hasMoreMessages()) {
            String message = this.bm.getNextMessage();
            if (this.field_146297_k.field_71466_p.func_78256_a(message) > 280) {
                int index = message.indexOf(" ", message.length() / 3);
                if (index != -1) {
                    String message2 = message.substring(index + 1, message.length());
                    message = message.substring(0, index);
                    this.func_73732_a(this.field_146297_k.field_71466_p, message, this.field_146294_l / 2, this.field_146295_m - 40, 0xFFFFFF);
                    this.func_73732_a(this.field_146297_k.field_71466_p, message2, this.field_146294_l / 2, this.field_146295_m - 28, 0xFFFFFF);
                }
            } else {
                this.func_73732_a(this.field_146297_k.field_71466_p, message, this.field_146294_l / 2, this.field_146295_m - 35, 0xFFFFFF);
            }
            ++this.flashCount;
            if (this.flashCount > 30) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.battleGui3);
                GuiHelper.drawImageQuad(this.field_146294_l / 2 + 130, this.field_146295_m - 15, 10.0, 6.0f, 0.9546874761581421, 0.31041666865348816, 0.98125f, 0.33125f, this.field_73735_i);
                if (this.flashCount > 60) {
                    this.flashCount = 0;
                }
            }
        } else {
            ++this.flashCount;
            if (this.flashCount >= 160) {
                this.flashCount = 0;
            }
            if (this.flashCount < 40) {
                this.func_73732_a(this.field_146297_k.field_71466_p, StatCollector.func_74838_a((String)"gui.guiDoctor.waiting"), this.field_146294_l / 2, this.field_146295_m - 35, 0xFFFFFF);
            } else if (this.flashCount < 80) {
                this.func_73732_a(this.field_146297_k.field_71466_p, StatCollector.func_74838_a((String)"gui.guiDoctor.waiting") + ".", this.field_146294_l / 2, this.field_146295_m - 35, 0xFFFFFF);
            } else if (this.flashCount < 120) {
                this.func_73732_a(this.field_146297_k.field_71466_p, StatCollector.func_74838_a((String)"gui.guiDoctor.waiting") + "..", this.field_146294_l / 2, this.field_146295_m - 35, 0xFFFFFF);
            } else if (this.flashCount < 160) {
                this.func_73732_a(this.field_146297_k.field_71466_p, StatCollector.func_74838_a((String)"gui.guiDoctor.waiting") + "...", this.field_146294_l / 2, this.field_146295_m - 35, 0xFFFFFF);
            }
        }
    }

    public void drawHealthBar(int x, int y, int width, int height, PixelmonData p) {
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        int barWidth = width - 6;
        tessellator.func_78369_a(0.4f, 0.4f, 0.4f, 1.0f);
        tessellator.func_78377_a((double)x, (double)y, 0.0);
        tessellator.func_78377_a((double)x, (double)(y + height), 0.0);
        tessellator.func_78377_a((double)(x + barWidth), (double)(y + height), 0.0);
        tessellator.func_78377_a((double)(x + barWidth), (double)y, 0.0);
        float Percent = (float)p.health / (float)p.hp;
        float CurWidth = Percent * (float)barWidth;
        if (p.health <= p.hp / 5) {
            tessellator.func_78369_a(0.8f, 0.0f, 0.0f, 1.0f);
        } else if (p.health <= p.hp / 2) {
            tessellator.func_78369_a(1.0f, 1.0f, 0.4f, 1.0f);
        } else {
            tessellator.func_78369_a(0.2f, 1.0f, 0.2f, 1.0f);
        }
        tessellator.func_78377_a((double)x, (double)y, 0.0);
        tessellator.func_78377_a((double)x, (double)(y + height), 0.0);
        tessellator.func_78377_a((double)((float)x + CurWidth), (double)(y + height), 0.0);
        tessellator.func_78377_a((double)((float)x + CurWidth), (double)y, 0.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2903);
    }

    public void drawButton(BattleMode mode, int x, int y, int buttonWidth, int buttonHeight, String string, int mouseX, int mouseY, int ind) {
        if (mode == BattleMode.MainMenu) {
            if (mouseX > x && mouseX < x + buttonWidth && mouseY > y && mouseY < y + buttonHeight) {
                GuiHelper.drawImageQuad(x, y, buttonWidth, buttonHeight, 0.604687511920929, 0.3291666805744171, 0.7640625238418579, 0.40833333134651184, this.field_73735_i);
            }
            this.func_73732_a(this.field_146297_k.field_71466_p, string, x + buttonWidth / 2, y + buttonHeight / 2 - 3, 0xFFFFFF);
        } else if (mode == BattleMode.ChooseAttack) {
            GuiHelper.drawImageQuad(x, y, buttonWidth, buttonHeight, 0.321875f, 0.3166666626930237, 0.614062488079071, 0.4208333194255829, this.field_73735_i);
            if (mouseX > x && mouseX < x + buttonWidth && mouseY > y && mouseY < y + buttonHeight && (this.bm.getUserPokemonPacket().choiceMove == -1 || this.bm.getUserPokemonPacket().choiceMove == ind)) {
                GuiHelper.drawImageQuad(x + 2, y + 2, buttonWidth - 5, buttonHeight - 4, 0.0359375f, 0.3229166567325592, 0.3125, 0.40625, this.field_73735_i);
                this.mouseOverButton = ind;
            }
            if (this.bm.getUserPokemonPacket().choiceMove == -1 || this.bm.getUserPokemonPacket().choiceMove == ind) {
                this.func_73732_a(this.field_146297_k.field_71466_p, string, x + buttonWidth / 2, y + buttonHeight / 2 - 3, 0xFFFFFF);
            } else {
                this.field_146297_k.field_71466_p.func_78276_b(string, x + buttonWidth / 2 - this.field_146297_k.field_71466_p.func_78256_a(string) / 2, y + buttonHeight / 2 - 3, 0xCCCCCC);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @Override
    public void func_146282_l() {
        if (Keyboard.getEventKeyState()) {
            int i = Keyboard.getEventKey();
            char c0 = Keyboard.getEventCharacter();
            this.func_73869_a(c0, i);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.bm.hasMoreMessages()) {
            this.bm.removeMessage();
            return;
        }
        if (this.bm.mode == BattleMode.Waiting) {
            return;
        }
        if (this.currentScreen != null) {
            this.currentScreen.click(this.field_146294_l, this.field_146295_m, mouseX, mouseY);
        }
    }

    @Override
    public void func_146278_c(int par1) {
    }

    @Override
    public void func_146276_q_() {
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.func_73863_a(mouseX, mouseY, par3);
        this.func_146276_q_();
        if (this.bm.mode != BattleMode.YesNo) {
            if (this.bm.hasLevelUps()) {
                if (this.bm.mode != BattleMode.LevelUp) {
                    this.bm.oldMode = this.bm.mode;
                    this.bm.mode = BattleMode.LevelUp;
                }
            } else if (this.bm.hasNewAttacks() && this.bm.mode != BattleMode.ReplaceAttack) {
                this.bm.oldMode = this.bm.mode;
                this.bm.mode = BattleMode.ReplaceAttack;
            }
        }
        this.selectScreen();
        if (this.first) {
            this.first = false;
            if (ClientProxy.camera != null) {
                this.setCameraToPlayer();
            }
        }
        if (!this.bm.hasMoreMessages() && this.bm.battleEnded && !this.bm.hasLevelUps() && !this.bm.hasNewAttacks()) {
            this.restoreSettingsAndClose();
            return;
        }
        RenderHelper.func_74518_a();
        if (!(this.bm.hasLevelUps() || this.bm.hasNewAttacks() || this.bm.mode != BattleMode.Waiting && this.bm.mode != BattleMode.MainMenu && this.bm.mode != BattleMode.ChooseAttack && this.bm.mode != BattleMode.ChooseTargets)) {
            this.drawPokemonOverlays();
        }
        if (this.bm.hasMoreMessages() || this.bm.mode == BattleMode.Waiting) {
            this.drawMessageScreen();
        } else {
            this.currentScreen.drawScreen(this.field_146294_l, this.field_146295_m, mouseX, mouseY);
        }
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public void setCameraToPlayer() {
        if (ClientProxy.camera != null) {
            ICameraTarget tar = ClientProxy.camera.getTarget();
            if (tar != null) {
                if (tar.getTargetData() != this.field_146297_k.field_71439_g) {
                    if (tar instanceof CameraTargetEntity) {
                        tar.setTargetData(this.field_146297_k.field_71439_g);
                    } else {
                        ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)this.field_146297_k.field_71439_g));
                    }
                }
            } else {
                ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)this.field_146297_k.field_71439_g));
            }
        }
    }

    public void setCameraToPixelmon() {
        if (ClientProxy.camera != null) {
            ICameraTarget tar = ClientProxy.camera.getTarget();
            if (tar != null) {
                if (tar.getTargetData() != this.bm.getUserPokemon()) {
                    if (tar instanceof CameraTargetEntity) {
                        tar.setTargetData((Object)this.bm.getUserPokemon());
                    } else {
                        ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)this.bm.getUserPokemon()));
                    }
                }
            } else {
                ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)this.field_146297_k.field_71439_g));
            }
        }
    }

    public static void setCameraToPos(double x, double y, double z) {
        if (ClientProxy.camera != null) {
            ClientProxy.camera.setMovement(new CMSmartPos(x, y, z));
        }
    }

    public int getGuiWidth() {
        return this.guiWidth;
    }

    public int getGuiHeight() {
        return this.guiHeight;
    }

    public void setTargetting(Attack attack, int opponentTarget, int userTarget) {
        for (int i = 0; i < this.bm.targetted.length; ++i) {
            for (int j = 0; j < this.bm.targetted[i].length; ++j) {
                this.bm.targetted[i][j] = false;
            }
        }
        TargettingInfo info = attack.baseAttack.targettingInfo;
        if (info.hitsAll) {
            if (info.hitsOppositeFoe) {
                this.bm.targetted[1][this.bm.currentPokemon] = true;
            }
            if (info.hitsAdjacentFoe) {
                if (this.bm.currentPokemon - 1 >= 0) {
                    this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
                }
                if (this.bm.currentPokemon + 1 < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
                }
            }
            if (info.hitsExtendedFoe) {
                if (this.bm.currentPokemon - 2 >= 0) {
                    this.bm.targetted[1][this.bm.currentPokemon - 2] = true;
                }
                if (this.bm.currentPokemon + 2 < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon + 2] = true;
                }
            }
            if (info.hitsSelf) {
                this.bm.targetted[0][this.bm.currentPokemon] = true;
            }
            if (info.hitsAdjacentAlly) {
                if (this.bm.currentPokemon - 1 >= 0) {
                    this.bm.targetted[0][this.bm.currentPokemon - 1] = true;
                }
                if (this.bm.currentPokemon + 1 < this.bm.targetted[0].length) {
                    this.bm.targetted[0][this.bm.currentPokemon + 1] = true;
                }
            }
            if (info.hitsExtendedAlly) {
                if (this.bm.currentPokemon - 2 >= 0) {
                    this.bm.targetted[0][this.bm.currentPokemon - 2] = true;
                }
                if (this.bm.currentPokemon + 2 < this.bm.targetted[0].length) {
                    this.bm.targetted[0][this.bm.currentPokemon + 2] = true;
                }
            }
        } else {
            if (userTarget != -1) {
                if (userTarget == this.bm.currentPokemon && info.hitsSelf) {
                    this.bm.targetted[0][this.bm.currentPokemon] = true;
                }
                if (info.hitsAdjacentAlly) {
                    if (userTarget == this.bm.currentPokemon + 1) {
                        this.bm.targetted[0][this.bm.currentPokemon + 1] = true;
                    }
                    if (userTarget == this.bm.currentPokemon - 1) {
                        this.bm.targetted[0][this.bm.currentPokemon - 1] = true;
                    }
                }
                if (info.hitsExtendedAlly) {
                    if (userTarget == this.bm.currentPokemon + 2) {
                        this.bm.targetted[0][this.bm.currentPokemon + 2] = true;
                    }
                    if (userTarget == this.bm.currentPokemon - 2) {
                        this.bm.targetted[0][this.bm.currentPokemon - 2] = true;
                    }
                }
            }
            if (opponentTarget != -1) {
                if (info.hitsOppositeFoe && opponentTarget == this.bm.currentPokemon) {
                    this.bm.targetted[1][this.bm.currentPokemon] = true;
                }
                if (info.hitsAdjacentFoe) {
                    if (opponentTarget == this.bm.currentPokemon + 1) {
                        this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
                    }
                    if (opponentTarget == this.bm.currentPokemon - 1) {
                        this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
                    }
                }
                if (info.hitsExtendedFoe) {
                    if (opponentTarget == this.bm.currentPokemon + 2) {
                        this.bm.targetted[1][this.bm.currentPokemon + 2] = true;
                    }
                    if (opponentTarget == this.bm.currentPokemon - 2) {
                        this.bm.targetted[1][this.bm.currentPokemon - 2] = true;
                    }
                }
            }
            if (userTarget == -1 && opponentTarget == -1) {
                if (info.hitsSelf) {
                    this.bm.targetted[0][this.bm.currentPokemon] = true;
                } else if (info.hitsOppositeFoe) {
                    this.bm.targetted[1][this.bm.currentPokemon] = true;
                }
            }
        }
    }
}

