/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.mail;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.mail.MailPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMail
extends GuiScreen {
    private boolean editable = true;
    private ResourceLocation backgroundTexture;
    private final ResourceLocation sealButtonTexture = new ResourceLocation("pixelmon", "gui/mail/sealButton.png");
    private final ResourceLocation abandonButtonTexture = new ResourceLocation("pixelmon", "gui/mail/closeButton.png");
    private final int guiWidth = 252;
    private final int guiHeight = 188;
    private GuiButton sealButton;
    private final int sealX = 60;
    private final int sealY = 185;
    private GuiButton exitButton;
    private final int exitX = 100;
    private final int exitY = 185;
    private String bookContents = "";
    private String author = "";
    private EntityPlayer player;

    public GuiMail(EntityPlayer player, ItemStack item) {
        this.player = player;
        String mailType = item.func_77977_a().split("-")[1];
        this.backgroundTexture = new ResourceLocation("pixelmon", "gui/mail/" + mailType + "mail.png");
        if (item.func_77942_o()) {
            NBTTagCompound nbtdata = item.func_77978_p();
            this.editable = nbtdata.func_74767_n("editable");
            this.author = nbtdata.func_74779_i("author");
            this.bookContents = nbtdata.func_74779_i("contents");
        }
    }

    private void writeLetterData(boolean shouldSeal) {
        MailPacket packetMail = new MailPacket(shouldSeal, this.player.getDisplayName(), this.bookContents, this.player);
        Pixelmon.network.sendToServer((IMessage)packetMail);
        Minecraft.func_71410_x().func_147108_a(null);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        int buttonID = 0;
        int xOffset = (this.field_146294_l - 252) / 2;
        int yOffset = 2;
        this.sealButton = new GuiButton(buttonID++, xOffset + 60, yOffset + 185, 30, 20, "Seal");
        this.exitButton = new GuiButton(buttonID, xOffset + 100, yOffset + 185, 30, 20, "Exit");
        if (!this.editable) {
            this.sealButton.field_146124_l = false;
        }
        this.field_146292_n.add(this.sealButton);
        this.field_146292_n.add(this.exitButton);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.writeLetterData(true);
                break;
            }
            case 1: {
                if (this.editable) {
                    this.writeLetterData(false);
                    break;
                }
                Minecraft.func_71410_x().func_147108_a(null);
            }
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        if (!this.editable) {
            return;
        }
        block0 : switch (keyChar) {
            case '\u0016': {
                break;
            }
            default: {
                switch (keyCode) {
                    case 14: {
                        if (this.bookContents.isEmpty()) break block0;
                        this.bookContents = this.bookContents.substring(0, this.bookContents.length() - 1);
                        break block0;
                    }
                    case 28: 
                    case 156: {
                        String[] strings2 = this.bookContents.split("\n");
                        if (strings2.length == 14) break block0;
                        this.bookContents = this.bookContents + "\n";
                        break block0;
                    }
                    default: {
                        int widthInPixels;
                        if (!ChatAllowedCharacters.func_71566_a((char)keyChar)) break block0;
                        String[] strings = this.bookContents.split("\n");
                        if (strings.length > 0 && (widthInPixels = this.field_146289_q.func_78256_a(strings[strings.length - 1])) >= 200) {
                            if (strings.length == 14) break block0;
                            this.bookContents = this.bookContents + "\n";
                        }
                        this.bookContents = this.bookContents + keyChar;
                    }
                }
            }
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float wut) {
        this.drawButtonTooltips(mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(this.backgroundTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = (this.field_146294_l - 252) / 2;
        int yOffset = 2;
        Gui.func_146110_a((int)xOffset, (int)yOffset, (float)0.0f, (float)0.0f, (int)252, (int)188, (float)252.0f, (float)188.0f);
        int buttonWidth = 32;
        int buttonHeight = 32;
        if (this.editable) {
            this.field_146297_k.field_71446_o.func_110577_a(this.sealButtonTexture);
            Gui.func_146110_a((int)(xOffset + 60), (int)(yOffset + 185), (float)0.0f, (float)0.0f, (int)buttonWidth, (int)buttonHeight, (float)buttonWidth, (float)buttonHeight);
        }
        this.field_146297_k.field_71446_o.func_110577_a(this.abandonButtonTexture);
        Gui.func_146110_a((int)(xOffset + 100), (int)(yOffset + 185), (float)0.0f, (float)0.0f, (int)buttonWidth, (int)buttonHeight, (float)buttonWidth, (float)buttonHeight);
        String[] lines = this.bookContents.split("\n");
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            this.field_146289_q.func_78276_b(lines[lineNumber], xOffset + 27, yOffset + 32 + lineNumber * 9 - this.field_146289_q.field_78288_b, 0);
        }
        this.field_146289_q.func_78276_b(this.author, xOffset + 164, yOffset + 175 - this.field_146289_q.field_78288_b, 0);
    }

    private void drawButtonTooltips(int mouseX, int mouseY) {
        if (this.mouseOverButton(mouseX, mouseY, this.sealButton)) {
            ArrayList<String> tooltipData = new ArrayList<String>();
            tooltipData.add("Seal letter");
            GuiHelper.renderTooltip(mouseX, mouseY, tooltipData, Color.BLUE.getRGB(), Color.BLACK.getRGB());
        } else if (this.mouseOverButton(mouseX, mouseY, this.exitButton)) {
            ArrayList<String> tooltipData = new ArrayList<String>();
            tooltipData.add("Close letter");
            GuiHelper.renderTooltip(mouseX, mouseY, tooltipData, Color.BLUE.getRGB(), Color.BLACK.getRGB());
        }
    }

    private boolean mouseOverButton(int mouseX, int mouseY, GuiButton button) {
        return button.field_146124_l && mouseX >= button.field_146128_h && mouseX <= button.field_146128_h + button.field_146120_f && mouseY >= button.field_146129_i && mouseY <= button.field_146129_i + button.field_146120_f;
    }

    public boolean func_73868_f() {
        return false;
    }
}

