/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.overlay;

import com.pixelmonmod.pixelmon.client.SkinLoader;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiPlayerList
extends GuiScreen {
    static ConcurrentHashMap<String, BufferedImage> cachedImages = new ConcurrentHashMap();
    static ConcurrentHashMap<String, DynamicTexture> cachedTextures = new ConcurrentHashMap();
    static List<String> fetchingSkins = Collections.synchronizedList(new ArrayList());
    int buttonID = 0;
    GuiButton previousButton;
    GuiButton nextButton;
    int currentPage = 0;

    public void setResolution(int width, int height) {
        this.field_146294_l = width;
        this.field_146295_m = height;
    }

    public void func_73866_w_() {
        this.previousButton = new GuiButton(this.buttonID++, (this.field_146294_l - 60) / 2 - 110, 180, 60, 20, "Previous");
        this.nextButton = new GuiButton(this.buttonID++, (this.field_146294_l - 60) / 2 + 110, 180, 60, 20, "Next");
        this.field_146292_n.add(this.previousButton);
        this.field_146292_n.add(this.nextButton);
        this.previousButton.field_146124_l = false;
        this.nextButton.field_146124_l = false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        for (DynamicTexture texture : cachedTextures.values()) {
            texture.func_147631_c();
        }
        cachedTextures.clear();
    }

    public void func_73863_a(int mouseX, int mouseY, float random) {
        if (!Keyboard.isKeyDown((int)Minecraft.func_71410_x().field_71474_y.field_74321_H.func_151463_i())) {
            this.field_146297_k.func_147108_a(null);
        }
        NetHandlerPlayClient handler = this.field_146297_k.field_71439_g.field_71174_a;
        this.field_146297_k.field_71424_I.func_76320_a("playerList");
        List players = handler.field_147303_b;
        int rows = (int)Math.ceil((double)players.size() / 3.0);
        if (rows > 9) {
            rows = 9;
        }
        int columns = 3;
        int playersPerPage = 27;
        int columnWidth = 300 / columns;
        int columnHeight = 18;
        if (columnWidth > 150) {
            columnWidth = 150;
        }
        int left = (this.field_146294_l - columns * columnWidth) / 2;
        int border = 10;
        int extraRows = 0;
        if (players.size() > playersPerPage) {
            extraRows = 2;
        } else {
            this.currentPage = 0;
        }
        GuiPlayerList.func_73734_a((int)(left - 1), (int)(border - 1), (int)(left + columnWidth * columns), (int)(border + columnHeight * (rows + extraRows)), (int)Integer.MIN_VALUE);
        int pages = players.size() / playersPerPage + 1;
        for (int i = this.currentPage * playersPerPage; i < this.currentPage * playersPerPage + playersPerPage; ++i) {
            int cellPtr = i - this.currentPage * playersPerPage;
            int xPos = left + cellPtr % columns * columnWidth;
            int yPos = border + cellPtr / columns * columnHeight;
            if (i >= players.size()) continue;
            GuiPlayerList.func_73734_a((int)xPos, (int)yPos, (int)(xPos + columnWidth - 1), (int)(yPos + columnHeight - 1), (int)new Color(158, 152, 152, 100).getRGB());
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3008);
            GuiPlayerInfo player = (GuiPlayerInfo)players.get(i);
            ScorePlayerTeam team = this.field_146297_k.field_71441_e.func_96441_U().func_96509_i(player.field_78831_a);
            String displayName = ScorePlayerTeam.func_96667_a((Team)team, (String)player.field_78831_a);
            this.field_146297_k.field_71466_p.func_78261_a(displayName, xPos, yPos, 0xFFFFFF);
            EnumChatFormatting pingColour = EnumChatFormatting.DARK_RED;
            if (player.field_78829_b < 151) {
                pingColour = EnumChatFormatting.GREEN;
            } else if (player.field_78829_b < 300) {
                pingColour = EnumChatFormatting.GOLD;
            }
            this.field_146297_k.field_71466_p.func_78261_a("Ping: " + pingColour + player.field_78829_b, xPos, yPos + 9, 0xFFFFFF);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.bindFace(StringUtils.func_76338_a((String)player.field_78831_a))) continue;
            GuiHelper.drawImageQuad(xPos + columnWidth - 20, yPos, 17.0, 17.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        }
        if (players.size() > playersPerPage) {
            this.previousButton.field_146124_l = this.currentPage > 0;
            this.nextButton.field_146124_l = this.currentPage != pages - 1;
            this.previousButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
            this.nextButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
            String pageCount = this.currentPage + 1 + "/" + (players.size() / 27 + 1);
            int strWidth = this.field_146297_k.field_71466_p.func_78256_a(pageCount);
            this.field_146297_k.field_71466_p.func_78261_a(pageCount, (this.field_146294_l - strWidth) / 2, 185, 0xFFFFFF);
        } else {
            this.previousButton.field_146124_l = false;
            this.nextButton.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.equals(this.previousButton)) {
            --this.currentPage;
        } else if (button.equals(this.nextButton)) {
            ++this.currentPage;
        }
    }

    public boolean bindFace(String username) {
        if (fetchingSkins.contains(username)) {
            if (cachedImages.containsKey(username)) {
                DynamicTexture faceTex = new DynamicTexture(cachedImages.get(username));
                cachedTextures.put(username, faceTex);
                cachedImages.remove(username);
            }
            return false;
        }
        if (!cachedTextures.containsKey(username)) {
            fetchingSkins.add(username);
            new Thread(new SkinLoader(username, SkinLoader.Mode.Head)).start();
            return false;
        }
        GL11.glBindTexture((int)3553, (int)cachedTextures.get(username).func_110552_b());
        return true;
    }

    public static void addCachedHead(String username, BufferedImage skinImage) {
        cachedImages.put(username, skinImage);
    }

    public static void delFetching(String username) {
        fetchingSkins.remove(username);
    }
}

