/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiPixelmonOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiPokeCheckerTabs;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.gui.ContainerEmpty;
import com.pixelmonmod.pixelmon.storage.PCClient;
import com.pixelmonmod.pixelmon.storage.PCPos;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiPC
extends GuiContainer {
    private int boxNumber = 0;
    private int trashX;
    private int trashY;
    private int checkX;
    private int checkY;
    private int pcLeft;
    private int pcRight;
    private int pcTop;
    private int pcBottom;
    private int partyLeft;
    private int partyRight;
    private int partyTop;
    private int partyBottom;
    private int slotWidth = 30;
    private int slotHeight = 28;
    private int pcNumWidth = 6;
    private int partyNumWidth = 6;
    private int pcNumHeight = 5;
    PCClient pcClient = new PCClient();
    GuiButton pMenuButtonSumm;
    GuiButton pMenuButtonMove;
    GuiButton pMenuButtonStat;
    Rectangle buttonBounds;
    Rectangle buttonBoundsMoves;
    Rectangle buttonBoundsStat;
    boolean pixelmonMenuOpen = false;
    public static PixelmonData selected = null;
    int menuX;
    int menuY;
    public PixelmonData mouseHeldPokemon = null;
    private boolean goingToPokeChecker = false;

    public GuiPC() {
        super((Container)new ContainerEmpty());
        this.pcClient.unselectAll();
    }

    public GuiPC(PixelmonData targetPacket, int box) {
        this();
        this.mouseHeldPokemon = targetPacket;
        this.boxNumber = box;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 131, this.field_146295_m / 6 + 60, 20, 20, "<-"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 91 + 205, this.field_146295_m / 6 + 60, 20, 20, "->"));
        this.trashX = this.field_146294_l / 2 - 91 + 202;
        this.checkY = this.trashY = this.field_146295_m / 6 + 150;
        this.checkX = this.field_146294_l / 2 - 140;
        this.pcLeft = this.field_146294_l / 2 - 90;
        this.pcRight = this.pcLeft + this.pcNumWidth * this.slotWidth;
        this.pcTop = this.field_146295_m / 6 - 5;
        this.pcBottom = this.pcTop + this.pcNumHeight * this.slotHeight;
        this.partyLeft = this.field_146294_l / 2 - 90;
        this.partyRight = this.partyLeft + this.partyNumWidth * this.slotWidth;
        this.partyTop = this.field_146295_m / 6 + 147;
        this.partyBottom = this.partyTop + this.slotHeight;
    }

    public PixelmonData getSlotAt(int x, int y) {
        PixelmonData pkt = null;
        pkt = this.getPCAt(x, y);
        if (pkt != null) {
            return pkt;
        }
        return this.getPartyAt(x, y);
    }

    public PCPos getPosAt(int x, int y) {
        PCPos pos = null;
        pos = this.getPCPosAt(x, y);
        if (pos != null) {
            return pos;
        }
        return this.getPartyPosAt(x, y);
    }

    private PCPos getPartyPosAt(int x, int y) {
        if (x >= this.partyLeft && x <= this.partyRight && y >= this.partyTop + 3 && y <= this.partyBottom + 3) {
            double xInd = ((double)x - (double)this.partyLeft) / (double)this.slotWidth;
            return new PCPos(-1, (int)Math.floor(xInd));
        }
        return null;
    }

    private PCPos getPCPosAt(int x, int y) {
        if (x >= this.pcLeft && x <= this.pcRight && y >= this.pcTop + 5 && y <= this.pcBottom + 5) {
            double xInd = ((double)x - (double)this.pcLeft) / (double)this.slotWidth;
            double yInd = ((double)y - ((double)this.pcTop + 5.0)) / (double)this.slotHeight;
            int ind = (int)Math.floor(yInd) * 6 + (int)Math.floor(xInd);
            return new PCPos(this.boxNumber, ind > 29 ? 29 : ind);
        }
        return null;
    }

    private PixelmonData getPartyAt(int x, int y) {
        if (x >= this.partyLeft && x <= this.partyRight && y >= this.partyTop + 3 && y <= this.partyBottom + 3) {
            double xInd = ((double)x - (double)this.partyLeft) / (double)this.slotWidth;
            return this.pcClient.getPokemonAtPos(-1, (int)Math.floor(xInd));
        }
        return null;
    }

    private PixelmonData getPCAt(int x, int y) {
        if (x >= this.pcLeft && x <= this.pcRight && y >= this.pcTop + 5 && y <= this.pcBottom + 5) {
            double xInd = ((double)x - (double)this.pcLeft) / (double)this.slotWidth;
            double yInd = ((double)y - ((double)this.pcTop + 5.0)) / (double)this.slotHeight;
            int ind = (int)Math.floor(yInd) * 6 + (int)Math.floor(xInd);
            if (ind > 29) {
                return null;
            }
            return this.pcClient.getPokemonAtPos(this.boxNumber, ind);
        }
        return null;
    }

    public boolean checkIfLast() {
        return this.pcClient.hasOneInParty();
    }

    public int numSelected() {
        return this.pcClient.numSelected();
    }

    protected void func_73864_a(int x, int y, int par3) {
        PixelmonData p;
        super.func_73864_a(x, y, par3);
        if (par3 == 0) {
            if (this.pixelmonMenuOpen && this.buttonBounds.contains(x, y)) {
                this.field_146297_k.field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.PokeChecker.getIndex().intValue(), (World)this.field_146297_k.field_71441_e, -1, this.boxNumber, 0);
            }
            if (this.pixelmonMenuOpen && this.buttonBoundsMoves.contains(x, y)) {
                this.field_146297_k.field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.PokeCheckerMoves.getIndex().intValue(), (World)this.field_146297_k.field_71441_e, -1, this.boxNumber, 0);
            }
            if (this.pixelmonMenuOpen && this.buttonBoundsStat.contains(x, y)) {
                this.field_146297_k.field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.PokeCheckerStats.getIndex().intValue(), (World)this.field_146297_k.field_71441_e, -1, this.boxNumber, 0);
            }
            if (this.pixelmonMenuOpen) {
                this.field_146292_n.remove(this.pMenuButtonSumm);
                this.field_146292_n.remove(this.pMenuButtonMove);
                this.field_146292_n.remove(this.pMenuButtonStat);
                this.pMenuButtonSumm = null;
                this.pMenuButtonMove = null;
                this.pMenuButtonStat = null;
                this.pixelmonMenuOpen = false;
                selected = null;
            }
        }
        if ((p = this.getSlotAt(x, y)) != null && par3 == 1) {
            if (this.pixelmonMenuOpen) {
                this.field_146292_n.remove(this.pMenuButtonSumm);
                this.field_146292_n.remove(this.pMenuButtonMove);
                this.field_146292_n.remove(this.pMenuButtonStat);
                this.pMenuButtonSumm = null;
                this.pMenuButtonMove = null;
                this.pMenuButtonStat = null;
                this.pixelmonMenuOpen = false;
                selected = null;
            }
            this.menuX = x;
            this.menuY = y;
            if (y >= this.partyTop && y <= this.partyBottom) {
                this.menuY -= 50;
            }
            this.pMenuButtonSumm = new GuiPokeCheckerTabs(6, 3, x - 63, this.menuY + 5, 47, 13, "Summary");
            this.pMenuButtonMove = new GuiPokeCheckerTabs(6, 4, x - 63, this.menuY + 24, 47, 13, "Moves");
            this.pMenuButtonStat = new GuiPokeCheckerTabs(6, 5, x - 63, this.menuY + 43, 47, 13, "Stats");
            this.buttonBounds = new Rectangle(x - 63, this.menuY + 5, 47, 13);
            this.buttonBoundsMoves = new Rectangle(x - 63, this.menuY + 24, 47, 13);
            this.buttonBoundsStat = new Rectangle(x - 63, this.menuY + 43, 47, 13);
            this.field_146292_n.add(this.pMenuButtonSumm);
            this.field_146292_n.add(this.pMenuButtonMove);
            this.field_146292_n.add(this.pMenuButtonStat);
            this.pixelmonMenuOpen = true;
            selected = p;
            return;
        }
        if (par3 == 0 && this.getPosAt(x, y) != null) {
            if (p != null && p.selected) {
                p.selected = !p.selected;
            } else if (p != null && this.numSelected() < 1 && !p.isInRanch) {
                p.selected = true;
            } else if (p != null && !p.isInRanch) {
                this.pcClient.swapPokemonWithSelected(p);
            } else if (p == null && this.pcClient.getSelected() != null && (ServerStorageDisplay.count() > 1 || this.pcClient.getPos((PixelmonData)this.pcClient.getSelected()).box >= 0)) {
                this.pcClient.swapPositionWithSelected(this.getPosAt(x, y));
            }
        }
        if (new Rectangle(this.trashX, this.trashY, 32, 32).contains(x, y) && this.numSelected() == 1 && (ServerStorageDisplay.count() > 1 || this.pcClient.getPos((PixelmonData)this.pcClient.getSelected()).box >= 0)) {
            this.pcClient.deletePokemon();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.goingToPokeChecker) {
            return;
        }
        GuiPixelmonOverlay.checkSelection();
    }

    public void func_146284_a(GuiButton button) {
        int b = button.field_146127_k;
        if (b == 0) {
            this.boxNumber = this.boxNumber == 0 ? 15 : --this.boxNumber;
        }
        if (b == 1) {
            this.boxNumber = this.boxNumber == 15 ? 0 : ++this.boxNumber;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        int x;
        int w = this.field_146294_l;
        int h = this.field_146295_m;
        RenderHelper.func_74518_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pcPartyBox);
        this.func_73729_b(this.field_146294_l / 2 - 91, this.field_146295_m / 6 + 151, 0, 0, 182, 29);
        boolean i = false;
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pcBox);
        this.func_73729_b(this.field_146294_l / 2 - 91, this.field_146295_m / 6, 0, 0, 182, 141);
        this.func_73729_b(this.trashX, this.trashY, 0, 224, 32, 32);
        for (x = 0; x < this.pcNumWidth; ++x) {
            for (int y = 0; y < this.pcNumHeight; ++y) {
                int pos = y * this.pcNumWidth + x;
                PixelmonData pkt = this.pcClient.getPokemonAtPos(this.boxNumber, pos);
                if (pkt == null) continue;
                GuiHelper.bindPokemonSprite(pkt, this.field_146297_k);
                int xPos = this.pcLeft + x * this.slotWidth;
                int yPos = this.pcTop + y * this.slotHeight;
                GuiHelper.drawImageQuad(xPos + 2, yPos + 3, 26.0, 26.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                if (pkt.heldItem != null) {
                    this.field_146297_k.field_71446_o.func_110577_a(GuiResources.heldItem);
                    GuiHelper.drawImageQuad(xPos + 22, yPos + 22, 8.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                }
                if (pkt.selected) {
                    this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pcBox);
                    GuiHelper.drawImageQuad(xPos, yPos + 4, this.slotWidth, this.slotHeight + 1, 0.0, 0.55859375, 0.12109375, 0.68359375, 0.0f);
                }
                if (!pkt.isInRanch) continue;
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.padlock);
                GuiHelper.drawImageQuad(xPos + 2, yPos + 22, 8.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            }
        }
        for (x = 0; x < this.partyNumWidth; ++x) {
            PixelmonData pkt = this.pcClient.getPokemonAtPos(-1, x);
            if (pkt == null) continue;
            int xPos = this.partyLeft + x * this.slotWidth;
            int yPos = this.partyTop;
            GuiHelper.bindPokemonSprite(pkt, this.field_146297_k);
            GuiHelper.drawImageQuad(xPos + 2, yPos + 3, 26.0, 26.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            if (pkt.heldItem != null) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.heldItem);
                GuiHelper.drawImageQuad(xPos + 18, yPos + 22, 8.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            }
            if (!pkt.selected) continue;
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pcBox);
            GuiHelper.drawImageQuad(xPos, yPos + 3, this.slotWidth, this.slotHeight + 1, 0.0, 0.55859375, 0.12109375, 0.68359375, 0.0f);
        }
        PixelmonData slot = this.getSlotAt(var2, var3);
        this.drawPokemonInfo(var2, var3, slot);
        this.field_146297_k.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"gui.pc.box") + (this.boxNumber + 1), this.field_146294_l / 2 - 18, this.field_146295_m / 6 - 20, 0xFFFFFF);
        if (this.pixelmonMenuOpen) {
            this.drawButtonContainer();
        }
    }

    private void drawPokemonInfo(int x, int y, PixelmonData p) {
        if (p == null) {
            return;
        }
        this.func_73733_a(x - 104, y - 2, x - 14, y + 20, -13158600, -13158600);
        String displayName = EntityPixelmon.getLocalizedName(p.name);
        if (!p.nickname.equals("")) {
            displayName = p.nickname;
        }
        if (p.isEgg) {
            displayName = StatCollector.func_74838_a((String)"pixelmon.egg.name");
        }
        this.field_146297_k.field_71466_p.func_78276_b(displayName, x - 102, y, 0xFFFFFF);
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonOverlay);
        if (!p.isEgg) {
            if (p.gender == Gender.Male) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.male);
                GuiHelper.drawImageQuad(this.field_146297_k.field_71466_p.func_78256_a(displayName) + x - 101, y, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            } else if (p.gender == Gender.Female) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.female);
                GuiHelper.drawImageQuad(this.field_146297_k.field_71466_p.func_78256_a(displayName) + x - 101, y, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            }
            this.field_146297_k.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"gui.screenpokechecker.lvl") + p.lvl, x + -101, y + this.field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
            if (p.health <= 0) {
                this.field_146297_k.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"gui.creativeinv.fainted"), x - 97 + this.field_146297_k.field_71466_p.func_78256_a("Lvl " + p.lvl), y + this.field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
            } else {
                this.field_146297_k.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"gui.creativeinv.hp") + p.health + "/" + p.hp, x - 97 + this.field_146297_k.field_71466_p.func_78256_a("Lvl " + p.lvl), y + this.field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
            }
        }
    }

    public void drawButtonContainer() {
        if (this.pixelmonMenuOpen) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokecheckerPopup);
            GuiHelper.drawImageQuad(this.menuX - 73, this.menuY - 10, 256.0, 73.0f, 0.0, 0.0, 1.0, 0.29f, 1.0f);
        }
    }
}

