/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokedex;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiPokedexSlotBase {
    private final int width;
    private final int height;
    protected final int top;
    protected final int bottom;
    private final int right;
    private final int left;
    protected final int slotHeight;
    private int scrollUpButtonID;
    private int scrollDownButtonID;
    protected int mouseX;
    protected int mouseY;
    private float initialClickY = -2.0f;
    private float scrollMultiplier;
    public float amountScrolled;
    private int selectedElement = -1;
    private long lastClicked = 0L;
    private boolean field_25123_p = true;
    private boolean field_27262_q;
    private int field_27261_r;

    public GuiPokedexSlotBase(int top, int left, int height) {
        this.width = 80;
        this.height = 175;
        this.top = top;
        this.bottom = this.top + this.height;
        this.slotHeight = 10;
        this.left = left;
        this.right = this.width + this.left;
    }

    public void func_27258_a(boolean par1) {
        this.field_25123_p = par1;
    }

    protected void func_27259_a(boolean par1, int par2) {
        this.field_27262_q = par1;
        this.field_27261_r = par2;
        if (!par1) {
            this.field_27261_r = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * 4 + this.field_27261_r;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5);

    protected void func_27260_a(int par1, int par2, Tessellator par3Tessellator) {
    }

    protected void func_27255_a(int par1, int par2) {
    }

    protected void func_27257_b(int par1, int par2) {
    }

    public int func_27256_c(int par1, int par2) {
        int var3 = this.left;
        int var4 = this.left + this.width;
        int var5 = par2 - this.top - this.field_27261_r + (int)this.amountScrolled - 4;
        int var6 = var5 / this.slotHeight;
        return par1 >= var3 && par1 <= var4 && var6 >= 0 && var5 >= 0 && var6 < this.getSize() ? var6 : -1;
    }

    public boolean isMouseOver(int element, int par1, int par2) {
        return this.func_27256_c(par1, par2) == element;
    }

    public boolean isElementVisible(int i) {
        return this.getElementPosition(i) == 0;
    }

    public int getElementPosition(int i) {
        int top = (int)this.amountScrolled;
        int ti = top / this.slotHeight + 1;
        int bi = ti + 16;
        if (ti > i) {
            return -1;
        }
        if (bi < i) {
            return 1;
        }
        return 0;
    }

    public void scrollTo(int i) {
        int pos = this.getElementPosition(i);
        while (pos > 0) {
            this.amountScrolled += (float)this.slotHeight;
            this.bindAmountScrolled();
            pos = this.getElementPosition(i);
        }
        while (pos < 0) {
            this.amountScrolled -= (float)this.slotHeight;
            this.bindAmountScrolled();
            pos = this.getElementPosition(i);
        }
    }

    public void registerScrollButtons(List par1List, int par2, int par3) {
        this.scrollUpButtonID = par2;
        this.scrollDownButtonID = par3;
    }

    public void bindAmountScrolled() {
        int var1 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (var1 < 0) {
            var1 /= 2;
        }
        if (this.amountScrolled < 0.0f) {
            this.amountScrolled = 0.0f;
        }
        if (this.amountScrolled > (float)var1) {
            this.amountScrolled = var1;
        }
    }

    public void actionPerformed(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            if (par1GuiButton.field_146127_k == this.scrollUpButtonID) {
                this.amountScrolled -= (float)(this.slotHeight * 2 / 3);
                this.initialClickY = -2.0f;
                this.bindAmountScrolled();
            } else if (par1GuiButton.field_146127_k == this.scrollDownButtonID) {
                this.amountScrolled += (float)(this.slotHeight * 2 / 3);
                this.initialClickY = -2.0f;
                this.bindAmountScrolled();
            }
        }
    }

    public void drawScreen(int mousePosX, int mousePosY, float par3) {
        int leftish;
        int middleOfSelect;
        int topLeftOfSelect;
        int index;
        int var10;
        int var9;
        GL11.glPushMatrix();
        this.mouseX = mousePosX;
        this.mouseY = mousePosY;
        int length = this.getSize();
        int posScrollBar = this.left + this.width;
        int posScrollBar2 = posScrollBar + 6;
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        Minecraft.func_71410_x().field_71460_t.func_78478_c();
        RenderHelper.func_74520_c();
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialClickY == -1.0f) {
                boolean flag = true;
                if (mousePosY >= this.top && mousePosY <= this.bottom) {
                    int var8 = this.left;
                    var9 = this.right;
                    var10 = mousePosY - this.top - this.field_27261_r + (int)this.amountScrolled - 4;
                    index = var10 / this.slotHeight;
                    if (mousePosX >= this.left && mousePosX <= this.right && index >= 0 && var10 >= 0 && index < length) {
                        boolean var12 = index == this.selectedElement && System.currentTimeMillis() - this.lastClicked < 250L;
                        this.elementClicked(index, var12);
                        this.selectedElement = index;
                        this.lastClicked = System.currentTimeMillis();
                    } else if (mousePosX >= var8 && mousePosX <= var9 && var10 < 0) {
                        this.func_27255_a(mousePosX - var8, mousePosY - this.top + (int)this.amountScrolled - 4);
                        flag = false;
                    }
                    if (mousePosX >= posScrollBar && mousePosX <= posScrollBar2) {
                        this.scrollMultiplier = -1.0f;
                        topLeftOfSelect = this.getContentHeight() - (this.bottom - this.top - 4);
                        if (topLeftOfSelect < 1) {
                            topLeftOfSelect = 1;
                        }
                        if ((middleOfSelect = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                            middleOfSelect = 32;
                        }
                        if (middleOfSelect > this.bottom - this.top - 8) {
                            middleOfSelect = this.bottom - this.top - 8;
                        }
                        this.scrollMultiplier /= (float)(this.bottom - this.top - middleOfSelect) / (float)topLeftOfSelect;
                    } else {
                        this.scrollMultiplier = 1.0f;
                    }
                    this.initialClickY = flag ? (float)mousePosY : -2.0f;
                } else {
                    this.initialClickY = -2.0f;
                }
            } else if (this.initialClickY >= 0.0f) {
                this.amountScrolled -= ((float)mousePosY - this.initialClickY) * this.scrollMultiplier;
                this.initialClickY = mousePosY;
            }
        } else {
            while (Mouse.next()) {
                int scroll = Mouse.getEventDWheel();
                if (scroll == 0) continue;
                if (scroll > 0) {
                    scroll = -1;
                } else if (scroll < 0) {
                    scroll = 1;
                }
                this.amountScrolled += (float)(scroll * this.slotHeight / 2);
            }
            this.initialClickY = -1.0f;
        }
        this.bindAmountScrolled();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        var9 = this.left;
        var10 = this.top + 4 - (int)this.amountScrolled;
        if (this.field_27262_q) {
            this.func_27260_a(var9, var10, tessellator);
        }
        for (index = 0; index < length; ++index) {
            topLeftOfSelect = var10 + index * this.slotHeight + this.field_27261_r;
            middleOfSelect = this.slotHeight - 4;
            if (topLeftOfSelect + 6 > this.bottom || topLeftOfSelect + middleOfSelect - 8 < this.top) continue;
            if (this.field_25123_p && (this.isSelected(index) || this.isMouseOver(index, mousePosX, mousePosY))) {
                leftish = this.left;
                int rightish = this.left + this.width;
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                tessellator.func_78378_d(0x808080);
                tessellator.func_78374_a(80.0, (double)(topLeftOfSelect + middleOfSelect + 2), 0.0, 0.0, 1.0);
                tessellator.func_78374_a(80.0, (double)(topLeftOfSelect + middleOfSelect + 2), 0.0, 1.0, 1.0);
                tessellator.func_78374_a(80.0, (double)(topLeftOfSelect - 2), 0.0, 1.0, 0.0);
                tessellator.func_78374_a(80.0, (double)(topLeftOfSelect - 2), 0.0, 0.0, 0.0);
                tessellator.func_78378_d(0);
                tessellator.func_78374_a((double)(leftish + 1), (double)(topLeftOfSelect + middleOfSelect + 1), 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)(rightish - 1), (double)(topLeftOfSelect + middleOfSelect + 1), 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)(rightish - 1), (double)(topLeftOfSelect - 1), 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)(leftish + 1), (double)(topLeftOfSelect - 1), 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            this.drawSlot(index, var9, topLeftOfSelect, middleOfSelect, tessellator);
        }
        GL11.glDisable((int)2929);
        int var20 = 4;
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.height, 255, 255);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        tessellator.func_78370_a(255, 0, 0, 0);
        tessellator.func_78374_a((double)this.left, (double)(this.top + var20), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)this.right, (double)(this.top + var20), 0.0, 1.0, 1.0);
        tessellator.func_78370_a(255, 0, 0, 255);
        tessellator.func_78374_a((double)this.right, (double)this.top, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)this.left, (double)this.top, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78370_a(255, 0, 0, 255);
        tessellator.func_78374_a((double)this.left, (double)this.bottom + 2.0, 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)this.right, (double)this.bottom + 2.0, 0.0, 1.0, 1.0);
        tessellator.func_78370_a(255, 0, 0, 0);
        tessellator.func_78374_a((double)this.right, (double)(this.bottom + 2 - var20), 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)this.left, (double)(this.bottom + 2 - var20), 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        topLeftOfSelect = this.getContentHeight() - (this.bottom - this.top - 4);
        if (topLeftOfSelect > 0) {
            middleOfSelect = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (middleOfSelect < 32) {
                middleOfSelect = 32;
            }
            if (middleOfSelect > this.bottom - this.top - 8) {
                middleOfSelect = this.bottom - this.top - 8;
            }
            if ((leftish = (int)this.amountScrolled * (this.bottom - this.top - middleOfSelect) / topLeftOfSelect + this.top) < this.top) {
                leftish = this.top;
            }
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 255);
            tessellator.func_78374_a((double)posScrollBar, (double)this.bottom + 2.0, 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)posScrollBar2, (double)this.bottom + 2.0, 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)posScrollBar2, (double)this.top + 2.0, 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)posScrollBar, (double)this.top + 2.0, 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78384_a(0x808080, 255);
            tessellator.func_78374_a((double)posScrollBar, (double)(leftish + middleOfSelect + 2), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)posScrollBar2, (double)(leftish + middleOfSelect + 2), 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)posScrollBar2, (double)leftish + 2.0, 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)posScrollBar, (double)leftish + 2.0, 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78384_a(0xC0C0C0, 255);
            tessellator.func_78374_a((double)posScrollBar, (double)(leftish + middleOfSelect - 1 + 2), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(posScrollBar2 - 1), (double)(leftish + middleOfSelect - 1 + 2), 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)(posScrollBar2 - 1), (double)leftish + 2.0, 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)posScrollBar, (double)leftish + 2.0, 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
        }
        this.func_27257_b(mousePosX, mousePosY);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void overlayBackground(int par1, int par2, int par3, int par4) {
    }
}

