/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.selectPokemon;

import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.selectPokemon.GuiSelectPokemon;
import com.pixelmonmod.pixelmon.client.gui.starter.EnumShadow;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class Shadow {
    private static ResourceLocation shadow = new ResourceLocation("pixelmon:gui/starter/ShadowLarge.png");
    EnumShadow shadowType;
    MoveDirection moveDirection;
    GuiSelectPokemon parent;
    float position;
    float yPos;
    float moveSpeed;

    public Shadow(EnumShadow shadowType, GuiSelectPokemon parent) {
        this.shadowType = shadowType;
        this.parent = parent;
        Random r = new Random();
        this.moveDirection = r.nextFloat() < 0.5f ? MoveDirection.Left : MoveDirection.Right;
        this.position = this.moveDirection == MoveDirection.Left ? 1.0f : 0.0f;
        this.moveSpeed = r.nextFloat() * shadowType.moveSpeedModifier * 0.01f + 0.001f;
        this.yPos = r.nextFloat();
    }

    public Shadow(EnumShadow shadowType, GuiSelectPokemon parent, float startPos) {
        this(shadowType, parent);
        this.position = startPos;
    }

    public void update() {
        if (this.moveDirection == MoveDirection.Left) {
            this.position -= this.moveSpeed;
            if (this.position <= 0.0f) {
                this.parent.removeShadow(this);
            }
        } else {
            this.position += this.moveSpeed;
            if (this.position >= 1.0f) {
                this.parent.removeShadow(this);
            }
        }
    }

    public void draw(Minecraft mc, int screenWidth, int screenHeight) {
        mc.field_71446_o.func_110577_a(shadow);
        float totWidth = screenWidth + this.shadowType.width * 2;
        float x = totWidth * this.position - (float)this.shadowType.width;
        float totHeight = screenHeight - 50;
        float y = this.yPos * totHeight - (float)this.shadowType.height + 50.0f;
        GL11.glEnable((int)3042);
        GuiHelper.drawImageQuad((int)x, (int)y, this.shadowType.width, this.shadowType.height, 0.0, 0.0, 1.0, 1.0, 0.0f);
    }

    static enum MoveDirection {
        Left,
        Right;

    }
}

