/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.trainerEditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.trainerEditor.GuiTrainerEditorMore;
import com.pixelmonmod.pixelmon.client.gui.trainerEditor.GuiTrainerEditorPartyScreen;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.TrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SpawnTraderFromTrainerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerEditor.DeleteTrainer;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerEditor.TrainerServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.EntityTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumSteveTextures;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.enums.EnumTrainerModel;
import com.pixelmonmod.pixelmon.gui.ContainerEmpty;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiTrainerEditor
extends GuiContainer {
    public static ArrayList<PixelmonData> pokemonList = new ArrayList();
    public static int currentTrainerID;
    public static TrainerData trainerData;
    EntityTrainer trainer;
    GuiTextField nameBox;
    GuiTextField customTextureBox;
    GuiButton steveTextureButton;
    EnumTrainerModel model;
    String oldName;

    public GuiTrainerEditor(int trainerId) {
        super((Container)new ContainerEmpty());
        this.trainer = EntityTrainer.locateTrainer((World)Minecraft.func_71410_x().field_71441_e, trainerId);
        currentTrainerID = trainerId;
        if (this.trainer == null) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.model = EnumTrainerModel.getFromInt(this.trainer.getModelIndex());
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 155, this.field_146295_m / 2 + 90, 30, 20, StatCollector.func_74838_a((String)"gui.guiItemDrops.ok")));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 70, 180, 20, this.model.toString()));
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 - 80, this.field_146295_m / 2 + 90, 100, 20, StatCollector.func_74838_a((String)"gui.trainereditor.edit")));
        if (this.model == EnumTrainerModel.Steve) {
            this.steveTextureButton = new GuiButton(4, this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 48, 180, 20, this.trainer.getSteveTexture());
            this.field_146292_n.add(this.steveTextureButton);
        }
        this.customTextureBox = new GuiTextField(this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 26, 180, 20);
        this.customTextureBox.func_146180_a(this.trainer.getCustomSteveTexture());
        this.field_146292_n.add(new GuiButton(5, this.field_146294_l / 2 + 40, this.field_146295_m / 2 + 20, 100, 20, StatCollector.func_74838_a((String)("enum.trainerBoss." + this.trainer.getBossMode().toString().toLowerCase()))));
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l / 2 + 40, this.field_146295_m / 2 + 53, 100, 20, StatCollector.func_74838_a((String)("enum.trainerAI." + this.trainer.getAIMode().toString().toLowerCase()))));
        this.field_146292_n.add(new GuiButton(9, this.field_146294_l / 2 + 40, this.field_146295_m / 2 + 86, 100, 20, StatCollector.func_74838_a((String)("enum.trainerEncounter." + this.trainer.getEncounterMode().toString().toLowerCase()))));
        this.field_146292_n.add(new GuiButton(7, this.field_146294_l / 2 - 190, this.field_146295_m / 2 + 90, 100, 20, StatCollector.func_74838_a((String)"gui.trainereditor.more")));
        this.field_146292_n.add(new GuiButton(8, this.field_146294_l / 2 + 100, this.field_146295_m / 2 - 120, 80, 20, StatCollector.func_74838_a((String)"gui.trainereditor.delete")));
        this.field_146292_n.add(new GuiButton(10, this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 120, 100, 20, StatCollector.func_74838_a((String)"gui.trainereditor.changeTrader")));
        this.nameBox = new GuiTextField(this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 96, 180, 20);
        this.nameBox.func_146180_a(this.trainer.getNickName());
        this.oldName = this.trainer.getNickName();
    }

    protected void func_146976_a(float f, int i, int j) {
        if (!this.trainer.getNickName().equals(this.oldName)) {
            this.oldName = this.trainer.getNickName();
            this.nameBox.func_146180_a(this.oldName);
        }
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 200, this.field_146295_m / 2 - 120, 400.0, 240.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        RenderHelper.func_74518_a();
        this.drawEntity((EntityLivingBase)this.trainer, this.field_146294_l / 2 - 140, this.field_146295_m / 2 + 50, 60, 0.0f, 0.0f);
        this.field_146297_k.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"gui.trainereditor.bosstype"), this.field_146294_l / 2 + 62, this.field_146295_m / 2 + 10, 0);
        this.field_146297_k.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"gui.trainereditor.aimode"), this.field_146294_l / 2 + 69, this.field_146295_m / 2 + 43, 0);
        this.field_146297_k.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"gui.trainereditor.encountermode"), this.field_146294_l / 2 + 52, this.field_146295_m / 2 + 76, 0);
        this.field_146297_k.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"gui.trainereditor.name"), this.field_146294_l / 2 - 60, this.field_146295_m / 2 - 90, 0);
        this.field_146297_k.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"gui.trainereditor.model"), this.field_146294_l / 2 - 60, this.field_146295_m / 2 - 63, 0);
        this.nameBox.func_146194_f();
        if (EnumSteveTextures.parse(this.trainer.getSteveTexture()) == EnumSteveTextures.Custom_PN || EnumSteveTextures.parse(this.trainer.getSteveTexture()) == EnumSteveTextures.Custom_RP) {
            this.customTextureBox.func_146194_f();
        }
        this.drawPokemonList();
    }

    private void drawPokemonList() {
        int top = this.field_146295_m / 2 + 20;
        int ySize = 68;
        int left = this.field_146294_l / 2 - 82;
        int xSize = 104;
        GuiTrainerEditor.func_73734_a((int)(left - 1), (int)(top - 1), (int)(left + xSize), (int)(top + ySize), (int)-16777215);
        GuiTrainerEditor.func_73734_a((int)left, (int)top, (int)(left + xSize), (int)(top + ySize), (int)-6777215);
        this.field_146297_k.field_71466_p.func_78276_b("Party Pokemon", left + 1, top - 11, 0);
        for (int n = 0; n < pokemonList.size(); ++n) {
            PixelmonData p = pokemonList.get(n);
            this.field_146297_k.field_71466_p.func_78276_b(EntityPixelmon.getLocalizedName(StatCollector.func_74838_a((String)p.name.toLowerCase())), left + 4, top + 4 + n * 10, 0);
            this.field_146297_k.field_71466_p.func_78276_b(StatCollector.func_74838_a((String)"gui.trainereditor.lvl") + p.lvl, left + 70, top + 4 + n * 10, 0);
        }
    }

    protected void func_73869_a(char key, int par2) {
        this.nameBox.func_146201_a(key, par2);
        this.customTextureBox.func_146201_a(key, par2);
        if (!this.oldName.equals(this.nameBox.func_146179_b())) {
            this.oldName = this.nameBox.func_146179_b();
            this.trainer.setNickName(this.nameBox.func_146179_b());
        }
    }

    protected void func_73864_a(int x, int y, int z) {
        super.func_73864_a(x, y, z);
        this.nameBox.func_146192_a(x, y, z);
        this.customTextureBox.func_146192_a(x, y, z);
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                if (this.checkFields()) {
                    this.field_146297_k.field_71439_g.func_71053_j();
                }
            } else if (button.field_146127_k == 2) {
                this.model = EnumTrainerModel.getNextModel(this.model);
                button.field_146126_j = this.model.toString();
                this.trainer.func_70096_w().func_75692_b(4, (Object)((short)this.model.ordinal()));
                Pixelmon.network.sendToServer((IMessage)new TrainerServerPacket(currentTrainerID, this.model.ordinal()));
                if (this.model == EnumTrainerModel.Steve) {
                    this.trainer.func_70096_w().func_75692_b(20, (Object)EnumTrainerModel.getFromInt(0).toString());
                    this.steveTextureButton = new GuiButton(4, this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 48, 180, 20, this.trainer.getSteveTexture());
                    this.field_146292_n.add(this.steveTextureButton);
                } else if (this.field_146292_n.contains(this.steveTextureButton)) {
                    this.field_146292_n.remove(this.steveTextureButton);
                }
            } else if (button.field_146127_k == 3) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiTrainerEditorPartyScreen());
            } else if (button.field_146127_k == 4) {
                EnumSteveTextures tex = EnumSteveTextures.parse(button.field_146126_j);
                tex = EnumSteveTextures.getNextTexture(tex);
                button.field_146126_j = tex.toString();
                Pixelmon.network.sendToServer((IMessage)new TrainerServerPacket(currentTrainerID, tex));
            } else if (button.field_146127_k == 5) {
                EnumBossMode bossMode = EnumBossMode.getNextMode(this.trainer.getBossMode());
                button.field_146126_j = StatCollector.func_74838_a((String)("enum.trainerBoss." + bossMode.toString().toLowerCase()));
                this.trainer.setBossMode(bossMode);
                Pixelmon.network.sendToServer((IMessage)new TrainerServerPacket(currentTrainerID, bossMode));
            } else if (button.field_146127_k == 6) {
                EnumTrainerAI mode = EnumTrainerAI.getNextMode(this.trainer.getAIMode());
                button.field_146126_j = mode.toString();
                this.trainer.setAIMode(mode);
            } else if (button.field_146127_k == 7) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiTrainerEditorMore());
            } else if (button.field_146127_k == 8) {
                Pixelmon.network.sendToServer((IMessage)new DeleteTrainer(currentTrainerID));
                this.field_146297_k.field_71439_g.func_71053_j();
            } else if (button.field_146127_k == 9) {
                EnumEncounterMode encounterMode = EnumEncounterMode.getNextMode(this.trainer.getEncounterMode());
                button.field_146126_j = StatCollector.func_74838_a((String)("enum.trainerEncounter." + encounterMode.toString().toLowerCase()));
                this.trainer.setEncounterMode(encounterMode);
                Pixelmon.network.sendToServer((IMessage)new TrainerServerPacket(currentTrainerID, encounterMode));
            } else if (button.field_146127_k == 10) {
                Pixelmon.network.sendToServer((IMessage)new SpawnTraderFromTrainerPacket(currentTrainerID));
            }
        }
    }

    private boolean checkFields() {
        if (this.nameBox.func_146179_b().equals("")) {
            return false;
        }
        if (currentTrainerID <= 0) {
            currentTrainerID = this.trainer.getId();
        }
        Pixelmon.network.sendToServer((IMessage)new TrainerServerPacket(currentTrainerID, TrainerServerPacket.PacketType.Name, this.nameBox.func_146179_b()));
        Pixelmon.network.sendToServer((IMessage)new TrainerServerPacket(currentTrainerID, this.trainer.getAIMode()));
        if (EnumSteveTextures.parse(this.trainer.getSteveTexture()) == EnumSteveTextures.Custom_RP || EnumSteveTextures.parse(this.trainer.getSteveTexture()) == EnumSteveTextures.Custom_PN) {
            Pixelmon.network.sendToServer((IMessage)new TrainerServerPacket(currentTrainerID, TrainerServerPacket.PacketType.CustomSteveTexture, this.customTextureBox.func_146179_b()));
        }
        return true;
    }

    protected void drawEntity(EntityLivingBase entity, int par1, int par2, int par3, float par4, float par5) {
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)par1, (float)par2, (float)50.0f);
        GL11.glScalef((float)(-par3), (float)par3, (float)par3);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float var6 = entity.field_70761_aq;
        float var7 = entity.field_70177_z;
        float var8 = entity.field_70125_A;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(par5 / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70761_aq = (float)Math.atan(par4 / 40.0f) * 20.0f;
        entity.field_70177_z = (float)Math.atan(par4 / 40.0f) * 40.0f;
        entity.field_70125_A = -((float)Math.atan(par5 / 40.0f)) * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        GL11.glTranslatef((float)0.0f, (float)entity.field_70129_M, (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        entity.field_70761_aq = var6;
        entity.field_70177_z = var7;
        entity.field_70125_A = var8;
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }
}

