/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.materials;

import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public enum EnumMaterialOption {
    NO_LIGHTING{

        @Override
        public void begin(Object ... params) {
            FS.start_unlit();
        }

        @Override
        public void end(Object ... params) {
            FS.end_unlit();
        }
    }
    ,
    WIREFRAME{

        @Override
        public void begin(Object ... params) {
            FS.start_wire();
        }

        @Override
        public void end(Object ... params) {
            GL11.glPopAttrib();
        }
    }
    ,
    TRANSPARENCY{

        @Override
        public void begin(Object ... params) {
            FS.start_transparency(params);
        }

        @Override
        public void end(Object ... params) {
            FS.end_transparency();
        }
    }
    ,
    NOCULL{

        @Override
        public void begin(Object ... params) {
            FS.enable_nocull();
        }

        @Override
        public void end(Object ... params) {
            FS.disable_nocull();
        }
    };

    public static int cubemapID;

    public abstract void begin(Object ... var1);

    public abstract void end(Object ... var1);

    static {
        cubemapID = 33986;
    }

    private static final class FS {
        private FS() {
        }

        public static void start_wire() {
            GL11.glPushAttrib((int)2880);
            GL11.glPolygonMode((int)1032, (int)6913);
        }

        public static void start_unlit() {
            GL11.glDisable((int)2896);
            Minecraft.func_71410_x().field_71460_t.func_78483_a(Double.NaN);
        }

        public static void end_unlit() {
            GL11.glEnable((int)2896);
            Minecraft.func_71410_x().field_71460_t.func_78463_b(Double.NaN);
        }

        public static void start_transparency(Object[] actuallyAFloat) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (actuallyAFloat != null && actuallyAFloat.length > 0 && actuallyAFloat[0] instanceof Float) {
                float alpha = ((Float)actuallyAFloat[0]).floatValue();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            }
        }

        public static void end_transparency() {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
        }

        public static void enable_nocull() {
            GL11.glEnable((int)2884);
        }

        public static void disable_nocull() {
            GL11.glDisable((int)2884);
        }
    }
}

