/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.animations;

import com.pixelmonmod.pixelmon.client.models.animations.AbstractEntityLink;
import com.pixelmonmod.pixelmon.client.models.animations.IModulized;
import com.pixelmonmod.pixelmon.client.models.animations.ModuleDeltaRelation;
import com.pixelmonmod.pixelmon.entities.DeltaListener;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;

public class DeltaLinkEntitySlider
extends AbstractEntityLink {
    public final IModulized.EnumGeomData targetDimension;
    public final double srcA;
    public final double srcB;
    public final float targetA;
    public final float targetB;

    public DeltaLinkEntitySlider(ModuleDeltaRelation target, DeltaListener.EnumEntityValue srcAxis, IModulized.EnumGeomData targetDimension, double floorValidSpeed, double ceilingValidSpeed, double srcA, double srcB, float targetA, float targetB) {
        super(target, srcAxis, floorValidSpeed, ceilingValidSpeed);
        this.targetDimension = targetDimension;
        this.srcA = srcA;
        this.srcB = srcB;
        this.targetA = targetDimension.isRotation() ? targetA * ((float)Math.PI / 180) : targetA;
        this.targetB = targetDimension.isRotation() ? targetB * ((float)Math.PI / 180) : targetB;
    }

    @Override
    protected double deltaImpl(EntityPixelmon entity) {
        return entity.deltas.getDelta(this.srcAxis);
    }

    @Override
    public void applyImpl(double delta) {
        if (this.isInRange(delta)) {
            float change = (float)GeometryHelper.lineSlider(delta, this.srcA, this.srcB, this.targetA, this.targetB);
            this.target.addDelta(change, this.targetDimension);
        }
    }
}

