/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.animations;

import com.pixelmonmod.pixelmon.client.models.animations.AbstractModuleLink;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.models.animations.Module;
import com.pixelmonmod.pixelmon.client.models.animations.ModuleDeltaRelation;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;

public class DeltaLinkModuleCompound
extends AbstractModuleLink {
    public final float floorValidRad;
    public final float ceilingValidRad;
    public final float srcMin;
    public final float srcMax;
    public final float xA;
    public final float xB;
    public final float yA;
    public final float yB;
    public final float zA;
    public final float zB;

    public DeltaLinkModuleCompound(Module src, ModuleDeltaRelation target, EnumRotation srcAxis, float floorIgnoreDeg, float ceilingIgnoreDeg, float srcMin, float srcMax, float xDelta, float yDelta, float zDelta) {
        this(src, target, srcAxis, floorIgnoreDeg, ceilingIgnoreDeg, srcMin, srcMax, 0.0f, xDelta, 0.0f, yDelta, 0.0f, zDelta);
    }

    public DeltaLinkModuleCompound(Module src, ModuleDeltaRelation target, EnumRotation srcAxis, float floorValidDeg, float ceilingValidDeg, float srcA, float srcB, float xA, float xB, float yA, float yB, float zA, float zB) {
        super(src, target, srcAxis);
        this.floorValidRad = floorValidDeg * ((float)Math.PI / 180);
        this.ceilingValidRad = ceilingValidDeg * ((float)Math.PI / 180);
        this.srcMin = srcA * ((float)Math.PI / 180);
        this.srcMax = srcB * ((float)Math.PI / 180);
        this.xA = xA * ((float)Math.PI / 180);
        this.xB = xB * ((float)Math.PI / 180);
        this.yA = yA * ((float)Math.PI / 180);
        this.yB = yB * ((float)Math.PI / 180);
        this.zA = zA * ((float)Math.PI / 180);
        this.zB = zB * ((float)Math.PI / 180);
    }

    @Override
    public void apply(EntityPixelmon entity) {
        float srcDelta = this.src.getDelta(this.srcAxis);
        if (this.isInRange(srcDelta)) {
            this.target.addDelta((float)GeometryHelper.lineSlider(srcDelta, this.srcMin, this.srcMax, this.xA, this.xB), (float)GeometryHelper.lineSlider(srcDelta, this.srcMin, this.srcMax, this.yA, this.yB), (float)GeometryHelper.lineSlider(srcDelta, this.srcMin, this.srcMax, this.zA, this.zB));
        }
    }

    private boolean isInRange(float radians) {
        return this.floorValidRad <= radians && radians <= this.ceilingValidRad;
    }
}

