/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.animations;

import com.pixelmonmod.pixelmon.client.models.animations.AbstractModuleLink;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.models.animations.Module;
import com.pixelmonmod.pixelmon.client.models.animations.ModuleDeltaRelation;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;

public class DeltaLinkModuleSimple
extends AbstractModuleLink {
    public float factor;
    public float floorValidRad;
    public float ceilingValidRad;
    public float zero;
    public final EnumRotation targetAxis;

    public DeltaLinkModuleSimple(Module src, ModuleDeltaRelation target, EnumRotation srcAxis, EnumRotation targetAxis, float factor, float floorValidDeg, float ceilingValidDeg) {
        this(src, target, srcAxis, targetAxis, factor, floorValidDeg, ceilingValidDeg, 0.0f);
    }

    public DeltaLinkModuleSimple(Module src, ModuleDeltaRelation target, EnumRotation srcAxis, EnumRotation targetAxis, float factor, float floorValidDeg, float ceilingValidDeg, float zero) {
        super(src, target, srcAxis);
        this.targetAxis = targetAxis;
        this.factor = factor;
        this.floorValidRad = floorValidDeg * ((float)Math.PI / 180);
        this.ceilingValidRad = ceilingValidDeg * ((float)Math.PI / 180);
        this.zero = zero * ((float)Math.PI / 180);
    }

    @Override
    public void apply(EntityPixelmon entity) {
        float delta = this.src.getDelta(this.srcAxis);
        delta = this.isInRange(delta) ? (delta - this.zero) * this.factor : 0.0f;
        this.target.addDelta(delta, this.targetAxis);
    }

    private boolean isInRange(float radians) {
        return this.floorValidRad <= radians && radians <= this.ceilingValidRad;
    }
}

