/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.animations;

import com.pixelmonmod.pixelmon.client.models.animations.AbstractModuleLink;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.models.animations.Module;
import com.pixelmonmod.pixelmon.client.models.animations.ModuleDeltaRelation;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;

public class DeltaLinkModuleSlider
extends AbstractModuleLink {
    protected final EnumRotation targetAxis;
    protected final float floorValidRad;
    protected final float ceilingValidRad;
    protected final float srcMin;
    protected final float srcMax;
    protected final float targetMin;
    protected final float targetMax;
    protected boolean halt = true;

    public DeltaLinkModuleSlider(Module src, ModuleDeltaRelation target, EnumRotation srcAxis, EnumRotation targetAxis, float floorValidDeg, float ceilingValidDeg, float srcMin, float srcMax, float targetMin, float targetMax) {
        super(src, target, srcAxis);
        this.targetAxis = targetAxis;
        this.floorValidRad = floorValidDeg * ((float)Math.PI / 180);
        this.ceilingValidRad = ceilingValidDeg * ((float)Math.PI / 180);
        this.srcMin = srcMin * ((float)Math.PI / 180);
        this.srcMax = srcMax * ((float)Math.PI / 180);
        this.targetMin = targetMin * ((float)Math.PI / 180);
        this.targetMax = targetMax * ((float)Math.PI / 180);
    }

    @Override
    public void apply(EntityPixelmon entity) {
        float delta = this.src.getDelta(this.srcAxis);
        delta = (float)(this.isInRange(delta) ? GeometryHelper.inverseSlider(GeometryHelper.slider(delta, this.srcMin, this.srcMax), this.targetMin, this.targetMax) : 0.0);
        this.target.addDelta(delta, this.targetAxis);
    }

    private boolean isInRange(float radians) {
        return this.floorValidRad <= radians && radians <= this.ceilingValidRad;
    }
}

