/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.animations;

import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.client.models.animations.IDeltaLink;
import com.pixelmonmod.pixelmon.client.models.animations.IModulized;
import com.pixelmonmod.pixelmon.client.models.animations.Module;
import com.pixelmonmod.pixelmon.client.models.animations.ModulizedRenderWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.model.ModelRenderer;

public class ModuleDeltaRelation
extends Module {
    public IModulized part;
    protected ArrayList<IDeltaLink> links = new ArrayList();
    protected float xrStart;
    protected float yrStart;
    protected float zrStart;
    protected float xLD;
    protected float yLD;
    protected float zLD;

    public ModuleDeltaRelation(IModulized target) {
        this.part = ModuleDeltaRelation.getModulizableFrom(target);
        this.xrStart = this.part.getValue(IModulized.EnumGeomData.xrot);
        this.yrStart = this.part.getValue(IModulized.EnumGeomData.yrot);
        this.zrStart = this.part.getValue(IModulized.EnumGeomData.zrot);
    }

    public ModuleDeltaRelation(ModelRenderer target) {
        this(new ModulizedRenderWrapper(target));
    }

    public ModuleDeltaRelation addLinks(IDeltaLink ... links) {
        Collections.addAll(this.links, links);
        return this;
    }

    @Override
    public void walk(EntityPixelmon entity, float f, float f1, float f2, float f3, float f4) {
        this.calcDeltas(entity);
        if (this.xrD != 0.0f) {
            this.part.setValue(this.xrD + this.xrStart, IModulized.EnumGeomData.xrot);
        }
        if (this.yrD != 0.0f) {
            this.part.setValue(this.yrD + this.yrStart, IModulized.EnumGeomData.yrot);
        }
        if (this.zrD != 0.0f) {
            this.part.setValue(this.zrD + this.zrStart, IModulized.EnumGeomData.zrot);
        }
        if (this.xLD != 0.0f) {
            this.part.setValue(this.xLD, IModulized.EnumGeomData.xloc);
        }
        if (this.yLD != 0.0f) {
            this.part.setValue(this.yLD, IModulized.EnumGeomData.yloc);
        }
        if (this.zLD != 0.0f) {
            this.part.setValue(this.zLD, IModulized.EnumGeomData.zloc);
        }
    }

    public void addDelta(float value, EnumRotation axis) {
        switch (axis) {
            case x: {
                this.xrD += value;
                break;
            }
            case y: {
                this.yrD += value;
                break;
            }
            case z: {
                this.zrD += value;
            }
        }
    }

    public void addDelta(float value, IModulized.EnumGeomData dim) {
        switch (dim) {
            case xrot: {
                this.xrD += value;
                break;
            }
            case yrot: {
                this.yrD += value;
                break;
            }
            case zrot: {
                this.zrD += value;
                break;
            }
            case xloc: {
                this.xLD += value;
                break;
            }
            case yloc: {
                this.yLD += value;
                break;
            }
            case zloc: {
                this.zLD += value;
            }
        }
    }

    public void addDelta(float x, float y, float z) {
        this.xrD += x;
        this.yrD += y;
        this.zrD += z;
    }

    public void addDeltaLoc(float x, float y, float z) {
        this.xLD += x;
        this.yLD += y;
        this.zLD += z;
    }

    @Override
    public void fly(EntityPixelmon entity, float f, float f1, float f2, float f3, float f4) {
    }

    protected void calcDeltas(EntityPixelmon entity) {
        this.xrD = 0.0f;
        this.yrD = 0.0f;
        this.zrD = 0.0f;
        this.xLD = 0.0f;
        this.yLD = 0.0f;
        this.zLD = 0.0f;
        for (IDeltaLink link : this.links) {
            link.apply(entity);
        }
    }
}

