/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.objHandling;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class Object3D {
    private ArrayList vertexsets = new ArrayList();
    private ArrayList vertexsetsnorms = new ArrayList();
    private ArrayList vertexsetstexs = new ArrayList();
    private ArrayList faces = new ArrayList();
    private ArrayList facestexs = new ArrayList();
    private ArrayList facesnorms = new ArrayList();
    private int objectlist;
    private int numpolys = 0;
    public float toppoint = 0.0f;
    public float bottompoint = 0.0f;
    public float leftpoint = 0.0f;
    public float rightpoint = 0.0f;
    public float farpoint = 0.0f;
    public float nearpoint = 0.0f;

    public Object3D(BufferedReader ref, boolean centerit) {
        this.loadobject(ref);
        if (centerit) {
            this.centerit();
        }
        this.opengldrawtolist();
        this.numpolys = this.faces.size();
        this.cleanup();
    }

    private void cleanup() {
        this.vertexsets.clear();
        this.vertexsetsnorms.clear();
        this.vertexsetstexs.clear();
        this.faces.clear();
        this.facestexs.clear();
        this.facesnorms.clear();
    }

    private void loadobject(BufferedReader br) {
        block19: {
            int linecounter = 0;
            try {
                String newline;
                boolean firstpass = true;
                while ((newline = br.readLine()) != null) {
                    int i;
                    String[] coordstext;
                    float[] coords;
                    ++linecounter;
                    if ((newline = newline.trim()).length() <= 0) continue;
                    if (newline.charAt(0) == 'v' && newline.charAt(1) == ' ') {
                        coords = new float[4];
                        coordstext = new String[4];
                        coordstext = newline.split("\\s+");
                        for (i = 1; i < coordstext.length; ++i) {
                            coords[i - 1] = Float.valueOf(coordstext[i]).floatValue();
                        }
                        if (firstpass) {
                            this.rightpoint = coords[0];
                            this.leftpoint = coords[0];
                            this.toppoint = coords[1];
                            this.bottompoint = coords[1];
                            this.nearpoint = coords[2];
                            this.farpoint = coords[2];
                            firstpass = false;
                        }
                        if (coords[0] > this.rightpoint) {
                            this.rightpoint = coords[0];
                        }
                        if (coords[0] < this.leftpoint) {
                            this.leftpoint = coords[0];
                        }
                        if (coords[1] > this.toppoint) {
                            this.toppoint = coords[1];
                        }
                        if (coords[1] < this.bottompoint) {
                            this.bottompoint = coords[1];
                        }
                        if (coords[2] > this.nearpoint) {
                            this.nearpoint = coords[2];
                        }
                        if (coords[2] < this.farpoint) {
                            this.farpoint = coords[2];
                        }
                        this.vertexsets.add(coords);
                    }
                    if (newline.charAt(0) == 'v' && newline.charAt(1) == 't') {
                        coords = new float[4];
                        coordstext = new String[4];
                        coordstext = newline.split("\\s+");
                        for (i = 1; i < coordstext.length; ++i) {
                            coords[i - 1] = Float.valueOf(coordstext[i]).floatValue();
                        }
                        this.vertexsetstexs.add(coords);
                    }
                    if (newline.charAt(0) == 'v' && newline.charAt(1) == 'n') {
                        coords = new float[4];
                        coordstext = new String[4];
                        coordstext = newline.split("\\s+");
                        for (i = 1; i < coordstext.length; ++i) {
                            coords[i - 1] = Float.valueOf(coordstext[i]).floatValue();
                        }
                        this.vertexsetsnorms.add(coords);
                    }
                    if (newline.charAt(0) != 'f' || newline.charAt(1) != ' ') continue;
                    String[] coordstext2 = newline.split("\\s+");
                    int[] v = new int[coordstext2.length - 1];
                    int[] vt = new int[coordstext2.length - 1];
                    int[] vn = new int[coordstext2.length - 1];
                    for (int i2 = 1; i2 < coordstext2.length; ++i2) {
                        String fixstring = coordstext2[i2].replaceAll("//", "/0/");
                        String[] tempstring = fixstring.split("/");
                        v[i2 - 1] = Integer.valueOf(tempstring[0]);
                        vt[i2 - 1] = tempstring.length > 1 ? Integer.valueOf(tempstring[1]) : 0;
                        vn[i2 - 1] = tempstring.length > 2 ? Integer.valueOf(tempstring[2]) : 0;
                    }
                    this.faces.add(v);
                    this.facestexs.add(vt);
                    this.facesnorms.add(vn);
                }
            }
            catch (IOException e) {
                if (PixelmonConfig.printErrors) {
                    System.out.println("Failed to read file: " + br.toString());
                }
            }
            catch (NumberFormatException e) {
                if (!PixelmonConfig.printErrors) break block19;
                System.out.println("Malformed OBJ (on line " + linecounter + "): " + br.toString() + "\r \r" + e.getMessage());
            }
        }
    }

    private void centerit() {
        float xshift = (this.rightpoint - this.leftpoint) / 2.0f;
        float yshift = (this.toppoint - this.bottompoint) / 2.0f;
        float zshift = (this.nearpoint - this.farpoint) / 2.0f;
        for (int i = 0; i < this.vertexsets.size(); ++i) {
            float[] coords = new float[4];
            coords[0] = ((float[])this.vertexsets.get(i))[0] - this.leftpoint - xshift;
            coords[1] = ((float[])this.vertexsets.get(i))[1] - this.bottompoint - yshift;
            coords[2] = ((float[])this.vertexsets.get(i))[2] - this.farpoint - zshift;
            this.vertexsets.set(i, coords);
        }
    }

    public float getXWidth() {
        float returnval = 0.0f;
        returnval = this.rightpoint - this.leftpoint;
        return returnval;
    }

    public float getYHeight() {
        float returnval = 0.0f;
        returnval = this.toppoint - this.bottompoint;
        return returnval;
    }

    public float getZDepth() {
        float returnval = 0.0f;
        returnval = this.nearpoint - this.farpoint;
        return returnval;
    }

    public int numpolygons() {
        return this.numpolys;
    }

    public void opengldrawtolist() {
        this.objectlist = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.objectlist, (int)4864);
        for (int i = 0; i < this.faces.size(); ++i) {
            int[] tempfaces = (int[])this.faces.get(i);
            int[] tempfacesnorms = (int[])this.facesnorms.get(i);
            int[] tempfacestexs = (int[])this.facestexs.get(i);
            int polytype = tempfaces.length == 3 ? 4 : (tempfaces.length == 4 ? 7 : 9);
            GL11.glBegin((int)polytype);
            for (int w = 0; w < tempfaces.length; ++w) {
                if (tempfacesnorms[w] != 0) {
                    float normtempx = ((float[])this.vertexsetsnorms.get(tempfacesnorms[w] - 1))[0];
                    float normtempy = ((float[])this.vertexsetsnorms.get(tempfacesnorms[w] - 1))[1];
                    float normtempz = ((float[])this.vertexsetsnorms.get(tempfacesnorms[w] - 1))[2];
                    GL11.glNormal3f((float)normtempx, (float)normtempy, (float)normtempz);
                }
                if (tempfacestexs[w] != 0) {
                    float textempx = ((float[])this.vertexsetstexs.get(tempfacestexs[w] - 1))[0];
                    float textempy = ((float[])this.vertexsetstexs.get(tempfacestexs[w] - 1))[1];
                    float textempz = ((float[])this.vertexsetstexs.get(tempfacestexs[w] - 1))[2];
                    GL11.glTexCoord3f((float)textempx, (float)(1.0f - textempy), (float)textempz);
                }
                float tempx = ((float[])this.vertexsets.get(tempfaces[w] - 1))[0];
                float tempy = ((float[])this.vertexsets.get(tempfaces[w] - 1))[1];
                float tempz = ((float[])this.vertexsets.get(tempfaces[w] - 1))[2];
                GL11.glVertex3f((float)tempx, (float)tempy, (float)tempz);
            }
            GL11.glEnd();
        }
        GL11.glEndList();
    }

    public void opengldraw() {
        GL11.glCallList((int)this.objectlist);
    }
}

