/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.pixelmonmod.pixelmon.client.models.smd.DeformVertex;
import java.util.ArrayList;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.Vertex;
import org.lwjgl.opengl.GL11;

public class NormalizedFace {
    public DeformVertex[] vertices;
    public TextureCoordinate[] textureCoordinates;
    public Vertex faceNormal;

    public NormalizedFace(DeformVertex[] xyz, TextureCoordinate[] uvs) {
        this.vertices = xyz;
        this.textureCoordinates = uvs;
    }

    public NormalizedFace(NormalizedFace face, ArrayList<DeformVertex> verts) {
        this.vertices = new DeformVertex[face.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            this.vertices[i] = verts.get(face.vertices[i].ID);
        }
        this.textureCoordinates = new TextureCoordinate[face.textureCoordinates.length];
        System.arraycopy(face.textureCoordinates, 0, this.textureCoordinates, 0, this.textureCoordinates.length);
        if (face.faceNormal != null) {
            this.faceNormal = face.faceNormal;
        }
    }

    public void addFaceForRender(boolean smoothShading) {
        if (!smoothShading && this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        for (int i = 0; i < 3; ++i) {
            GL11.glTexCoord2f((float)this.textureCoordinates[i].u, (float)this.textureCoordinates[i].v);
            if (!smoothShading) {
                GL11.glNormal3f((float)this.faceNormal.x, (float)this.faceNormal.y, (float)this.faceNormal.z);
            } else {
                Vec3 normalNormal = Vec3.func_72443_a((double)this.vertices[i].xn, (double)this.vertices[i].yn, (double)this.vertices[i].zn).func_72432_b();
                GL11.glNormal3f((float)((float)normalNormal.field_72450_a), (float)((float)normalNormal.field_72448_b), (float)((float)normalNormal.field_72449_c));
            }
            GL11.glVertex3d((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z);
        }
    }

    public Vertex calculateFaceNormal() {
        Vec3 v1 = Vec3.func_72443_a((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
        Vec3 v2 = Vec3.func_72443_a((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
        Vec3 normalVector = null;
        normalVector = v1.func_72431_c(v2).func_72432_b();
        return new Vertex((float)normalVector.field_72450_a, (float)normalVector.field_72448_b, (float)normalVector.field_72449_c);
    }
}

