/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.pixelmonmod.pixelmon.client.models.smd.AnimFrame;
import com.pixelmonmod.pixelmon.client.models.smd.Bone;
import com.pixelmonmod.pixelmon.client.models.smd.DeformVertex;
import com.pixelmonmod.pixelmon.client.models.smd.GabeNewellException;
import com.pixelmonmod.pixelmon.client.models.smd.Material;
import com.pixelmonmod.pixelmon.client.models.smd.NormalizedFace;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.util.helpers.VectorHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import org.lwjgl.opengl.GL11;

public class SmdModel {
    public final ValveStudioModel owner;
    public ArrayList<NormalizedFace> faces = new ArrayList(0);
    public ArrayList<DeformVertex> verts = new ArrayList(0);
    public ArrayList<Bone> bones = new ArrayList(0);
    public HashMap<String, Bone> nameToBoneMapping = new HashMap();
    public HashMap<String, Material> materialsByName;
    public HashMap<Material, ArrayList<NormalizedFace>> facesByMaterial;
    public SmdAnimation currentAnim;
    public String fileName;
    private int vertexIDBank = 0;
    protected boolean isBodyGroupPart;
    int lineCount = -1;
    public Bone root;

    public SmdModel(SmdModel model, ValveStudioModel owner) {
        Bone b;
        int i;
        this.owner = owner;
        this.isBodyGroupPart = model.isBodyGroupPart;
        for (NormalizedFace face : model.faces) {
            DeformVertex[] vertices = new DeformVertex[face.vertices.length];
            for (int i2 = 0; i2 < vertices.length; ++i2) {
                DeformVertex d = new DeformVertex(face.vertices[i2]);
                CommonHelper.ensureIndex(this.verts, d.ID);
                this.verts.set(d.ID, d);
            }
        }
        for (NormalizedFace face : model.faces) {
            this.faces.add(new NormalizedFace(face, this.verts));
        }
        for (i = 0; i < model.bones.size(); ++i) {
            b = model.bones.get(i);
            this.bones.add(new Bone(b, null, this));
        }
        for (i = 0; i < model.bones.size(); ++i) {
            b = model.bones.get(i);
            b.copy.setChildren(b, this.bones);
        }
        this.root = model.root.copy;
        owner.sendBoneData(this);
    }

    public SmdModel(ValveStudioModel owner, ResourceLocation resloc) throws GabeNewellException {
        this.owner = owner;
        this.isBodyGroupPart = false;
        this.loadSmdModel(resloc, null);
        this.setBoneChildren();
        this.determineRoot();
        owner.sendBoneData(this);
        ValveStudioModel.print("Number of vertices = " + this.verts.size());
    }

    public SmdModel(ValveStudioModel owner, ResourceLocation resloc, SmdModel body) {
        this.owner = owner;
        this.isBodyGroupPart = true;
        this.loadSmdModel(resloc, body);
        this.setBoneChildren();
        this.determineRoot();
        owner.sendBoneData(this);
    }

    private void loadSmdModel(ResourceLocation resloc, SmdModel body) throws GabeNewellException {
        BufferedInputStream inputStream = CommonHelper.getStreamForResLoc(resloc);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String currentLine = null;
        try {
            this.lineCount = 0;
            while ((currentLine = reader.readLine()) != null) {
                ++this.lineCount;
                if (currentLine.startsWith("version")) continue;
                if (currentLine.startsWith("nodes")) {
                    ++this.lineCount;
                    while (!(currentLine = reader.readLine()).startsWith("end")) {
                        ++this.lineCount;
                        this.parseBone(currentLine, this.lineCount, body);
                    }
                    ValveStudioModel.print("Number of model bones = " + this.bones.size());
                    continue;
                }
                if (currentLine.startsWith("skeleton")) {
                    ++this.lineCount;
                    reader.readLine();
                    ++this.lineCount;
                    while (!(currentLine = reader.readLine()).startsWith("end")) {
                        ++this.lineCount;
                        if (this.isBodyGroupPart) continue;
                        this.parseBoneValues(currentLine, this.lineCount);
                    }
                    continue;
                }
                if (!currentLine.startsWith("triangles")) continue;
                ++this.lineCount;
                while (!(currentLine = reader.readLine()).startsWith("end")) {
                    Material mat = this.owner.usesMaterials ? this.requestMaterial(currentLine) : null;
                    String[] params = new String[3];
                    for (int i = 0; i < 3; ++i) {
                        ++this.lineCount;
                        params[i] = reader.readLine();
                    }
                    this.parseFace(params, this.lineCount, mat);
                }
            }
        }
        catch (Exception e) {
            if (this.lineCount == -1) {
                throw new GabeNewellException("there was a problem opening the model file : " + resloc, e);
            }
            throw new GabeNewellException("an error occurred reading the SMD file \"" + resloc + "\" on line #" + this.lineCount, e);
        }
        ValveStudioModel.print("Number of faces = " + this.faces.size());
    }

    public Material requestMaterial(String materialName) {
        Material result;
        if (!this.owner.usesMaterials) {
            return null;
        }
        if (this.materialsByName == null) {
            this.materialsByName = new HashMap();
        }
        if ((result = this.materialsByName.get(materialName)) != null) {
            return result;
        }
        String materialPath = this.owner.getMaterialPath(materialName);
        URL materialURL = SmdModel.class.getResource(materialPath);
        try {
            File materialFile = new File(materialURL.toURI());
            result = new Material(materialFile);
            this.materialsByName.put(materialName, result);
            return result;
        }
        catch (Exception e) {
            throw new GabeNewellException(e);
        }
    }

    private void parseBone(String line, int lineCount, SmdModel body) {
        Bone theBone;
        String[] params = line.split("\\s+");
        int id = Integer.parseInt(params[0]);
        String boneName = params[1].replaceAll("\"", "");
        Bone bone = theBone = body != null ? body.getBoneByName(boneName) : null;
        if (theBone == null) {
            int parentID = Integer.parseInt(params[2]);
            Bone parent = parentID >= 0 ? this.bones.get(parentID) : null;
            theBone = new Bone(boneName, id, parent, this);
        }
        CommonHelper.ensureIndex(this.bones, id);
        this.bones.set(id, theBone);
        this.nameToBoneMapping.put(boneName, theBone);
        ValveStudioModel.print(boneName);
    }

    private void parseBoneValues(String line, int lineCount) {
        String[] params = line.split("\\s+");
        int id = Integer.parseInt(params[0]);
        float[] locRots = new float[6];
        for (int i = 1; i < 7; ++i) {
            locRots[i - 1] = Float.parseFloat(params[i]);
        }
        Bone theBone = this.bones.get(id);
        theBone.setRest(VectorHelper.matrix4FromLocRot(locRots[0], -locRots[1], -locRots[2], locRots[3], -locRots[4], -locRots[5]));
    }

    private void parseFace(String[] params, int lineCount, Material mat) {
        DeformVertex[] faceVerts = new DeformVertex[3];
        TextureCoordinate[] uvs = new TextureCoordinate[3];
        for (int i = 0; i < 3; ++i) {
            String[] values = params[i].split("\\s+");
            float x = Float.parseFloat(values[1]);
            float y = -Float.parseFloat(values[2]);
            float z = -Float.parseFloat(values[3]);
            float xn = Float.parseFloat(values[4]);
            float yn = -Float.parseFloat(values[5]);
            float zn = -Float.parseFloat(values[6]);
            DeformVertex v = this.getExisting(x, y, z);
            if (v == null) {
                faceVerts[i] = new DeformVertex(x, y, z, xn, yn, zn, this.vertexIDBank);
                CommonHelper.ensureIndex(this.verts, this.vertexIDBank);
                this.verts.set(this.vertexIDBank, faceVerts[i]);
                ++this.vertexIDBank;
            } else {
                faceVerts[i] = v;
            }
            uvs[i] = new TextureCoordinate(Float.parseFloat(values[7]), 1.0f - Float.parseFloat(values[8]));
            if (values.length <= 10) continue;
            this.doBoneWeights(values, faceVerts[i]);
        }
        NormalizedFace face = new NormalizedFace(faceVerts, uvs);
        face.vertices = faceVerts;
        face.textureCoordinates = uvs;
        this.faces.add(face);
        if (mat != null) {
            ArrayList<NormalizedFace> list;
            if (this.facesByMaterial == null) {
                this.facesByMaterial = new HashMap();
            }
            if ((list = this.facesByMaterial.get(mat)) == null) {
                list = new ArrayList();
                this.facesByMaterial.put(mat, list);
            }
            list.add(face);
        }
    }

    private DeformVertex getExisting(float x, float y, float z) {
        for (DeformVertex v : this.verts) {
            if (!v.equals(x, y, z)) continue;
            return v;
        }
        return null;
    }

    private void doBoneWeights(String[] values, DeformVertex vert) {
        int i;
        int links = Integer.parseInt(values[9]);
        float[] weights = new float[links];
        float sum = 0.0f;
        for (i = 0; i < links; ++i) {
            weights[i] = Float.parseFloat(values[i * 2 + 11]);
            sum += weights[i];
        }
        for (i = 0; i < links; ++i) {
            int boneID = Integer.parseInt(values[i * 2 + 10]);
            float weight = weights[i] / sum;
            this.bones.get(boneID).addVertex(vert, weight);
        }
    }

    private void setBoneChildren() {
        for (int i = 0; i < this.bones.size(); ++i) {
            Bone theBone = this.bones.get(i);
            for (Bone child : this.bones) {
                if (child.parent != theBone) continue;
                theBone.addChild(child);
            }
        }
    }

    private void determineRoot() {
        for (Bone b : this.bones) {
            if (b.parent != null || b.children.isEmpty()) continue;
            this.root = b;
            break;
        }
        if (this.root == null) {
            for (Bone b : this.bones) {
                if (b.name.equals("blender_implicit")) continue;
                this.root = b;
                break;
            }
        }
    }

    public void setAnimation(SmdAnimation anim) {
        this.currentAnim = anim;
    }

    public Bone getBoneByID(int id) {
        try {
            return this.bones.get(id);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Bone getBoneByName(String name) {
        for (Bone b : this.bones) {
            if (!b.name.equals(name)) continue;
            return b;
        }
        return null;
    }

    public AnimFrame currentFrame() {
        return this.currentAnim == null ? null : (this.currentAnim.frames == null ? null : (this.currentAnim.frames.isEmpty() ? null : this.currentAnim.frames.get(this.currentAnim.currentFrameIndex)));
    }

    public void resetVerts() {
        for (DeformVertex v : this.verts) {
            v.reset();
        }
    }

    public void render() {
        boolean smooth;
        GL11.glPushMatrix();
        GL11.glBegin((int)4);
        boolean isPokeball = false;
        if (this.owner.resource.func_110623_a().contains("pokeballs")) {
            isPokeball = true;
        }
        boolean bl = smooth = isPokeball ? PixelmonConfig.enableSmoothPokeballShading : PixelmonConfig.enableSmoothPokemonShading;
        if (!this.owner.usesMaterials) {
            for (NormalizedFace f : this.faces) {
                f.addFaceForRender(smooth);
            }
        } else {
            for (Map.Entry<Material, ArrayList<NormalizedFace>> entry : this.facesByMaterial.entrySet()) {
                if (entry.getKey() == null) continue;
                entry.getKey().pre();
                for (NormalizedFace face : entry.getValue()) {
                    face.addFaceForRender(smooth);
                }
                entry.getKey().post();
            }
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

