/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.pixelmonmod.pixelmon.client.models.smd.Bone;
import com.pixelmonmod.pixelmon.client.models.smd.DeformVertex;
import com.pixelmonmod.pixelmon.client.models.smd.GabeNewellException;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.SmdModel;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class ValveStudioModel
implements IModelCustom {
    public SmdModel body;
    public HashMap<String, SmdAnimation> anims = new HashMap();
    protected Bone root;
    ArrayList<Bone> allBones;
    public SmdAnimation currentAnimation;
    public ResourceLocation resource;
    protected String materialPath;
    public static boolean debugModel = false;
    private boolean hasAnimations = false;
    protected boolean usesMaterials = false;

    public ValveStudioModel(ValveStudioModel model) {
        this.body = new SmdModel(model.body, this);
        for (Map.Entry<String, SmdAnimation> entry : model.anims.entrySet()) {
            this.anims.put(entry.getKey(), new SmdAnimation(entry.getValue(), this));
        }
        this.hasAnimations = model.hasAnimations;
        this.usesMaterials = model.usesMaterials;
        this.resource = model.resource;
        this.currentAnimation = this.anims.get("idle");
    }

    public ValveStudioModel(ResourceLocation resource) throws GabeNewellException {
        this.resource = resource;
        this.loadQC(resource);
        this.reformBones();
        this.precalculateAnims();
    }

    private void loadQC(ResourceLocation resloc) throws GabeNewellException {
        BufferedInputStream inputStream = CommonHelper.getStreamForResLoc(resloc);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String currentLine = null;
        int lineCount = 0;
        String[] bodyParams = null;
        ArrayList<String[]> animParams = new ArrayList<String[]>();
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((currentLine = reader.readLine()) != null) {
                ++lineCount;
                String[] params = currentLine.split("\\s+");
                if (params[0].equalsIgnoreCase("$body")) {
                    bodyParams = params;
                    continue;
                }
                if (params[0].equalsIgnoreCase("$anim")) {
                    if (this.anims == null) {
                        this.anims = new HashMap();
                    }
                    this.hasAnimations = true;
                    animParams.add(params);
                    continue;
                }
                if (!params[0].equalsIgnoreCase("$cdmaterials")) continue;
                this.usesMaterials = true;
                this.materialPath = params[1];
            }
            ResourceLocation modelPath = this.getResource((String)bodyParams[1]);
            this.body = new SmdModel(this, modelPath);
            for (String[] animPars : animParams) {
                String animName = animPars[1];
                ResourceLocation animPath = this.getResource(animPars[2]);
                this.anims.put(animName, new SmdAnimation(this, animName, animPath));
                if (!animName.equalsIgnoreCase("idle")) continue;
                this.currentAnimation = this.anims.get(animName);
            }
        }
        catch (GabeNewellException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GabeNewellException("An error occurred reading the PQC file on line #" + lineCount, e);
        }
    }

    public ResourceLocation getResource(String fileName) {
        String urlAsString = this.resource.func_110623_a();
        int lastIndex = urlAsString.lastIndexOf(47);
        String startString = urlAsString.substring(0, lastIndex);
        return new ResourceLocation("pixelmon:" + startString + "/" + fileName);
    }

    public String getType() {
        return "pqc";
    }

    private void precalculateAnims() {
        for (SmdAnimation anim : this.anims.values()) {
            anim.precalculateAnimation(this.body);
        }
    }

    public void renderAll() {
        GL11.glShadeModel((int)7425);
        this.body.render();
        GL11.glShadeModel((int)7424);
    }

    void sendBoneData(SmdModel model) {
        this.allBones = model.bones;
        if (!model.isBodyGroupPart) {
            this.root = model.root;
        }
    }

    private void reformBones() {
        this.root.reformChildren();
        for (Bone b : this.allBones) {
            b.invertRestMatrix();
        }
    }

    public void animate() {
        this.resetVerts(this.body);
        if (this.body.currentAnim == null) {
            this.setAnimation("idle");
        }
        this.root.setModified();
        for (Bone b : this.allBones) {
            b.applyModified();
        }
        this.applyVertChange(this.body);
    }

    private void resetVerts(SmdModel model) {
        if (model == null) {
            return;
        }
        for (DeformVertex v : model.verts) {
            v.reset();
        }
    }

    private void applyVertChange(SmdModel model) {
        if (model == null) {
            return;
        }
        for (DeformVertex v : model.verts) {
            v.applyChange();
        }
    }

    public void setAnimation(String animname) {
        this.currentAnimation = this.anims.containsKey(animname) ? this.anims.get(animname) : this.anims.get("idle");
        this.body.setAnimation(this.currentAnimation);
    }

    public void renderPart(String partName) {
    }

    public static void print(Object o) {
        if (debugModel) {
            System.out.println(o);
        }
    }

    public void renderOnly(String ... groupNames) {
    }

    public void renderAllExcept(String ... excludedGroupNames) {
    }

    public boolean hasAnimations() {
        return this.hasAnimations;
    }

    protected String getMaterialPath(String subFile) {
        int lastDot;
        String result = "/assets/pixelmon";
        if (!this.materialPath.startsWith("/")) {
            result = result + "/";
        }
        result = result + this.materialPath;
        if (!subFile.startsWith("/")) {
            result = result + "/";
        }
        result = (lastDot = (result = result + subFile).lastIndexOf(".")) == -1 ? result + ".mat" : result.substring(0, lastDot) + ".mat";
        return result;
    }
}

