/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.PlayerExtraData;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballBase;
import com.pixelmonmod.pixelmon.entities.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.enums.EnumCustomModel;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class RenderPlayerExtra {
    IModelCustom model;
    HashMap<Class, ModelPokeballBase> models = new HashMap();
    float partialTick = 0.0f;
    RenderPlayer renderer;

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        this.partialTick = event.partialRenderTick;
        this.renderer = event.renderer;
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderLivingEvent.Post event) {
        float scale;
        boolean hasArmour;
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        PlayerExtraData extras = Pixelmon.proxy.getExtras().getExtras(player);
        if (!extras.hasSash) {
            return;
        }
        int[] balls = EntityPlayerExtension.getPlayerPokeballs(player);
        if (this.model == null) {
            this.model = EnumCustomModel.Sash.getModel();
        }
        float f2 = this.interpolateRotation(player.field_70760_ar, player.field_70761_aq, this.partialTick);
        float f3 = this.interpolateRotation(player.field_70758_at, player.field_70759_as, this.partialTick);
        if (player.func_70115_ae() && player.field_70154_o instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase1 = (EntityLivingBase)player.field_70154_o;
            f2 = this.interpolateRotation(entitylivingbase1.field_70760_ar, entitylivingbase1.field_70761_aq, this.partialTick);
            float f4 = MathHelper.func_76142_g((float)(f3 - f2));
            if (f4 < -85.0f) {
                f4 = -85.0f;
            }
            if (f4 >= 85.0f) {
                f4 = 85.0f;
            }
            f2 = f3 - f4;
            if (f4 * f4 > 2500.0f) {
                f2 += f4 * 0.2f;
            }
        }
        String path = "pixelmon:textures/playeritems/sash.png";
        RenderManager.field_78727_a.field_78724_e.func_110577_a(new ResourceLocation(path));
        GL11.glPushMatrix();
        GL11.glTranslated((double)event.x, (double)(event.y + (double)Minecraft.func_71410_x().field_71439_g.field_70129_M), (double)event.z);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = hasArmour = player.field_71071_by.func_70440_f(2) != null;
        if (hasArmour) {
            GL11.glTranslated((double)0.0, (double)-1.69, (double)0.0);
            GL11.glRotatef((float)(this.renderer.field_77109_a.field_78115_e.field_78796_g + f2), (float)0.0f, (float)-1.0f, (float)0.0f);
            scale = 0.77f;
            GL11.glScalef((float)scale, (float)scale, (float)(scale + 0.21f));
        } else {
            GL11.glTranslated((double)0.0, (double)-1.69, (double)0.0);
            GL11.glRotatef((float)(this.renderer.field_77109_a.field_78115_e.field_78796_g + f2), (float)0.0f, (float)-1.0f, (float)0.0f);
            scale = 0.75f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
        this.model.renderAll();
        GL11.glPopMatrix();
        for (int i = 0; i < balls.length; ++i) {
            if (balls[i] < 0) continue;
            GL11.glPushMatrix();
            GL11.glTranslated((double)event.x, (double)(event.y + (double)Minecraft.func_71410_x().field_71439_g.field_70129_M), (double)event.z);
            EnumPokeballs en = EnumPokeballs.getFromIndex(balls[i]);
            Class c = en.getModel();
            if (this.models.get(c) == null) {
                this.models.put(c, Pixelmon.proxy.loadPokeballModel(c));
            }
            RenderManager.field_78727_a.field_78724_e.func_110577_a(new ResourceLocation(en.getTextureDirectory() + en.getTexture()));
            GL11.glRotatef((float)(this.renderer.field_77109_a.field_78115_e.field_78796_g + f2), (float)0.0f, (float)-1.0f, (float)0.0f);
            this.moveToOffset(i, hasArmour);
            this.models.get(c).render(null, 9.090909E-4f);
            GL11.glPopMatrix();
        }
    }

    private void moveToOffset(int i, boolean hasArmour) {
        if (!hasArmour) {
            double xdiff = 0.032;
            double ydiff = 0.055;
            GL11.glTranslated((double)(-0.16 + (double)i * xdiff), (double)(-0.325 - (double)i * ydiff), (double)0.12);
        } else {
            double xdiff = 0.031;
            double ydiff = 0.055;
            GL11.glTranslated((double)(-0.16 + (double)i * xdiff), (double)(-0.293 - (double)i * ydiff), (double)0.165);
        }
    }

    private void undoMoveToOffset(int i) {
        switch (i) {
            case 0: {
                GL11.glTranslated((double)0.15, (double)0.32, (double)-0.13);
            }
            case 1: {
                GL11.glTranslated((double)0.15, (double)0.42, (double)-0.13);
            }
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
    }

    private float interpolateRotation(float p_77034_1_, float p_77034_2_, float p_77034_3_) {
        float f3;
        for (f3 = p_77034_2_ - p_77034_1_; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return p_77034_1_ + p_77034_3_ * f3;
    }
}

